/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.connection.refresher.util;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.oracle.type.OracleDatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.single.api.config.SingleRuleConfiguration;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class TableRefreshUtils {
    public static String getTableName(DatabaseType databaseType, IdentifierValue identifierValue) {
        return databaseType instanceof OracleDatabaseType && QuoteCharacter.NONE == identifierValue.getQuoteCharacter() ? identifierValue.getValue().toUpperCase() : identifierValue.getValue();
    }

    public static boolean isSingleTable(String tableName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(TableContainedRule.class).stream().noneMatch(each -> each.getDistributedTableMapper().contains(tableName));
    }

    public static boolean isRuleRefreshRequired(RuleMetaData ruleMetaData, String schemaName, Collection<SimpleTableSegment> tableSegments) {
        for (SimpleTableSegment each : tableSegments) {
            if (!TableRefreshUtils.isRuleRefreshRequired(ruleMetaData, schemaName, each.getTableName().getIdentifier().getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRuleRefreshRequired(RuleMetaData ruleMetaData, String schemaName, String tableName) {
        Optional singleRule = ruleMetaData.findSingleRule(MutableDataNodeRule.class);
        if (!singleRule.isPresent()) {
            return false;
        }
        RuleConfiguration ruleConfig = ((MutableDataNodeRule)singleRule.get()).getConfiguration();
        if (!(ruleConfig instanceof SingleRuleConfiguration)) {
            return false;
        }
        Collection tablesConfig = ((SingleRuleConfiguration)ruleConfig).getTables();
        if (tablesConfig.contains("*.*") || tablesConfig.contains("*.*.*")) {
            return false;
        }
        Optional dataNode = ((MutableDataNodeRule)singleRule.get()).findTableDataNode(schemaName, tableName);
        if (!dataNode.isPresent()) {
            return false;
        }
        DataNode actualNode = (DataNode)dataNode.get();
        return !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), "*")) && !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), "*", "*")) && !tablesConfig.contains(TableRefreshUtils.joinDataNodeSegments(actualNode.getDataSourceName(), actualNode.getSchemaName(), "*"));
    }

    private static String joinDataNodeSegments(String ... segments) {
        return Joiner.on((String)".").join((Object[])segments);
    }

    @Generated
    private TableRefreshUtils() {
    }
}

