/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.hikari.metadata;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.datasource.pool.props.validator.DataSourcePoolPropertiesContentValidator;

public final class HikariDataSourcePoolPropertiesContentValidator
implements DataSourcePoolPropertiesContentValidator {
    private static final long MIN_CONNECTION_TIMEOUT_MILLISECONDS = 250L;
    private static final long MIN_LIFETIME_MILLISECONDS = TimeUnit.SECONDS.toMillis(30L);
    private static final long MIN_KEEP_ALIVE_TIME_MILLISECONDS = TimeUnit.SECONDS.toMillis(30L);

    public void validate(DataSourcePoolProperties props) {
        Map allLocalProps = props.getAllLocalProperties();
        this.validateConnectionTimeout(allLocalProps);
        this.validateIdleTimeout(allLocalProps);
        this.validateMaxLifetime(allLocalProps);
        this.validateMaximumPoolSize(allLocalProps);
        this.validateMinimumIdle(allLocalProps);
        this.validateKeepAliveTime(allLocalProps);
    }

    private void validateConnectionTimeout(Map<String, Object> allLocalProps) {
        if (this.isExisted(allLocalProps, "connectionTimeout")) {
            long connectionTimeout = Long.parseLong(allLocalProps.get("connectionTimeout").toString());
            Preconditions.checkState((connectionTimeout >= 250L ? 1 : 0) != 0, (String)"connectionTimeout can not less than %s ms.", (long)250L);
        }
    }

    private void validateIdleTimeout(Map<String, Object> allLocalProps) {
        if (this.isExisted(allLocalProps, "idleTimeout")) {
            long idleTimeout = Long.parseLong(allLocalProps.get("idleTimeout").toString());
            Preconditions.checkState((idleTimeout >= 0L ? 1 : 0) != 0, (Object)"idleTimeout can not be negative.");
        }
    }

    private void validateMaxLifetime(Map<String, Object> allLocalProps) {
        if (this.isExisted(allLocalProps, "maxLifetime")) {
            long maxLifetime = Long.parseLong(allLocalProps.get("maxLifetime").toString());
            Preconditions.checkState((maxLifetime >= MIN_LIFETIME_MILLISECONDS ? 1 : 0) != 0, (String)"maxLifetime can not less than %s ms.", (long)MIN_LIFETIME_MILLISECONDS);
        }
    }

    private void validateMaximumPoolSize(Map<String, Object> allLocalProps) {
        if (this.isExisted(allLocalProps, "maximumPoolSize")) {
            int maximumPoolSize = Integer.parseInt(allLocalProps.get("maximumPoolSize").toString());
            Preconditions.checkState((maximumPoolSize >= 1 ? 1 : 0) != 0, (Object)"maxPoolSize can not less than 1.");
        }
    }

    private void validateMinimumIdle(Map<String, Object> allLocalProps) {
        if (this.isExisted(allLocalProps, "minimumIdle")) {
            int minimumIdle = Integer.parseInt(allLocalProps.get("minimumIdle").toString());
            Preconditions.checkState((minimumIdle >= 0 ? 1 : 0) != 0, (Object)"minimumIdle can not be negative.");
        }
    }

    private void validateKeepAliveTime(Map<String, Object> allLocalProps) {
        if (!this.isExisted(allLocalProps, "keepaliveTime")) {
            return;
        }
        int keepAliveTime = Integer.parseInt(allLocalProps.get("keepaliveTime").toString());
        if (0 == keepAliveTime) {
            return;
        }
        Preconditions.checkState(((long)keepAliveTime >= MIN_KEEP_ALIVE_TIME_MILLISECONDS ? 1 : 0) != 0, (String)"keepaliveTime can not be less than %s ms.", (long)MIN_KEEP_ALIVE_TIME_MILLISECONDS);
    }

    private boolean isExisted(Map<String, Object> allLocalProps, String key) {
        return allLocalProps.containsKey(key) && null != allLocalProps.get(key);
    }

    public Object getType() {
        return "com.zaxxer.hikari.HikariDataSource";
    }
}

