/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process.model.yaml;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessContext;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessUnit;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.YamlExecuteProcessUnit;

public final class YamlExecuteProcessContext {
    private String executionID;
    private String databaseName;
    private String username;
    private String hostname;
    private String sql;
    private Collection<YamlExecuteProcessUnit> unitStatuses;
    private Long startTimeMillis;

    public YamlExecuteProcessContext(ExecuteProcessContext executeProcessContext) {
        this.executionID = executeProcessContext.getExecutionID();
        this.databaseName = executeProcessContext.getDatabaseName();
        this.username = executeProcessContext.getUsername();
        this.hostname = executeProcessContext.getHostname();
        this.sql = executeProcessContext.getSql();
        this.unitStatuses = new ArrayList<YamlExecuteProcessUnit>(executeProcessContext.getProcessUnits().size());
        for (ExecuteProcessUnit each : executeProcessContext.getProcessUnits().values()) {
            this.unitStatuses.add(new YamlExecuteProcessUnit(each));
        }
        this.startTimeMillis = executeProcessContext.getStartTimeMillis();
    }

    @Generated
    public YamlExecuteProcessContext() {
    }

    @Generated
    public YamlExecuteProcessContext(String executionID, String databaseName, String username, String hostname, String sql, Collection<YamlExecuteProcessUnit> unitStatuses, Long startTimeMillis) {
        this.executionID = executionID;
        this.databaseName = databaseName;
        this.username = username;
        this.hostname = hostname;
        this.sql = sql;
        this.unitStatuses = unitStatuses;
        this.startTimeMillis = startTimeMillis;
    }

    @Generated
    public String getExecutionID() {
        return this.executionID;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public Collection<YamlExecuteProcessUnit> getUnitStatuses() {
        return this.unitStatuses;
    }

    @Generated
    public Long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    @Generated
    public void setExecutionID(String executionID) {
        this.executionID = executionID;
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setUnitStatuses(Collection<YamlExecuteProcessUnit> unitStatuses) {
        this.unitStatuses = unitStatuses;
    }

    @Generated
    public void setStartTimeMillis(Long startTimeMillis) {
        this.startTimeMillis = startTimeMillis;
    }
}

