/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.kernel.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;

public final class ExecutorServiceManager {
    private static final String DEFAULT_NAME_FORMAT = "%d";
    private static final ExecutorService SHUTDOWN_EXECUTOR = Executors.newSingleThreadExecutor(ExecutorThreadFactoryBuilder.build("Executor-Engine-Closer"));
    private final ExecutorService executorService;

    public ExecutorServiceManager(int executorSize) {
        this(executorSize, DEFAULT_NAME_FORMAT);
    }

    public ExecutorServiceManager(int executorSize, String nameFormat) {
        this.executorService = this.getExecutorService(executorSize, nameFormat);
    }

    private ExecutorService getExecutorService(int executorSize, String nameFormat) {
        ThreadFactory threadFactory = ExecutorThreadFactoryBuilder.build(nameFormat);
        return 0 == executorSize ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(executorSize, threadFactory);
    }

    public void close() {
        SHUTDOWN_EXECUTOR.execute(() -> {
            try {
                this.executorService.shutdown();
                while (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        });
    }

    @Generated
    public ExecutorService getExecutorService() {
        return this.executorService;
    }
}

