/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.kernel;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.external.sql.type.generic.UnknownSQLException;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorCallback;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorServiceManager;

public final class ExecutorEngine
implements AutoCloseable {
    private final ExecutorServiceManager executorServiceManager;

    private ExecutorEngine(int executorSize) {
        this.executorServiceManager = new ExecutorServiceManager(executorSize);
    }

    public static ExecutorEngine createExecutorEngineWithSize(int executorSize) {
        return new ExecutorEngine(executorSize);
    }

    public <I, O> List<O> execute(ExecutionGroupContext<I> executionGroupContext, ExecutorCallback<I, O> firstCallback, ExecutorCallback<I, O> callback, boolean serial) throws SQLException {
        if (executionGroupContext.getInputGroups().isEmpty()) {
            return Collections.emptyList();
        }
        return serial ? this.serialExecute(executionGroupContext.getInputGroups().iterator(), firstCallback, callback) : this.parallelExecute(executionGroupContext.getInputGroups().iterator(), firstCallback, callback);
    }

    private <I, O> List<O> serialExecute(Iterator<ExecutionGroup<I>> executionGroups, ExecutorCallback<I, O> firstCallback, ExecutorCallback<I, O> callback) throws SQLException {
        ExecutionGroup<I> firstInputs = executionGroups.next();
        LinkedList<O> result = new LinkedList<O>(this.syncExecute(firstInputs, null == firstCallback ? callback : firstCallback));
        while (executionGroups.hasNext()) {
            result.addAll(this.syncExecute(executionGroups.next(), callback));
        }
        return result;
    }

    private <I, O> List<O> parallelExecute(Iterator<ExecutionGroup<I>> executionGroups, ExecutorCallback<I, O> firstCallback, ExecutorCallback<I, O> callback) throws SQLException {
        ExecutionGroup<I> firstInputs = executionGroups.next();
        Collection<Future<Collection<O>>> restResultFutures = this.asyncExecute(executionGroups, callback);
        return this.getGroupResults(this.syncExecute(firstInputs, null == firstCallback ? callback : firstCallback), restResultFutures);
    }

    private <I, O> Collection<O> syncExecute(ExecutionGroup<I> executionGroup, ExecutorCallback<I, O> callback) throws SQLException {
        return callback.execute(executionGroup.getInputs(), true);
    }

    private <I, O> Collection<Future<Collection<O>>> asyncExecute(Iterator<ExecutionGroup<I>> executionGroups, ExecutorCallback<I, O> callback) {
        LinkedList<Future<Collection<O>>> result = new LinkedList<Future<Collection<O>>>();
        while (executionGroups.hasNext()) {
            result.add(this.asyncExecute(executionGroups.next(), callback));
        }
        return result;
    }

    private <I, O> Future<Collection<O>> asyncExecute(ExecutionGroup<I> executionGroup, ExecutorCallback<I, O> callback) {
        return this.executorServiceManager.getExecutorService().submit(() -> callback.execute(executionGroup.getInputs(), false));
    }

    private <O> List<O> getGroupResults(Collection<O> firstResults, Collection<Future<Collection<O>>> restFutures) throws SQLException {
        LinkedList<O> result = new LinkedList<O>(firstResults);
        for (Future<Collection<O>> each : restFutures) {
            try {
                result.addAll(each.get());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                return this.throwException(ex);
            }
        }
        return result;
    }

    private <O> List<O> throwException(Exception exception) throws SQLException {
        if (exception.getCause() instanceof SQLException) {
            throw (SQLException)exception.getCause();
        }
        throw new UnknownSQLException(exception);
    }

    @Override
    public void close() {
        this.executorServiceManager.close();
    }

    @Generated
    public ExecutorServiceManager getExecutorServiceManager() {
        return this.executorServiceManager;
    }
}

