/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.metadata.user.Grantee;

public final class Process {
    private final String id;
    private final long startMillis;
    private final String sql;
    private final String databaseName;
    private final String username;
    private final String hostname;
    private final int totalUnitCount;
    private final Collection<Statement> processStatements;
    private final AtomicInteger completedUnitCount;
    private final boolean idle;
    private final boolean heldByConnection;

    public Process(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, boolean heldByConnection) {
        this("", executionGroupContext, true, heldByConnection);
    }

    public Process(String sql, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, boolean heldByConnection) {
        this(sql, executionGroupContext, false, heldByConnection);
    }

    private Process(String sql, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, boolean idle, boolean heldByConnection) {
        this.id = executionGroupContext.getReportContext().getProcessId();
        this.startMillis = System.currentTimeMillis();
        this.sql = sql;
        this.databaseName = executionGroupContext.getReportContext().getDatabaseName();
        Grantee grantee = executionGroupContext.getReportContext().getGrantee();
        this.username = null == grantee ? null : grantee.getUsername();
        this.hostname = null == grantee ? null : grantee.getHostname();
        this.totalUnitCount = this.getTotalUnitCount(executionGroupContext);
        this.processStatements = this.getProcessStatements(executionGroupContext);
        this.completedUnitCount = new AtomicInteger(0);
        this.idle = idle;
        this.heldByConnection = heldByConnection;
    }

    private int getTotalUnitCount(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext) {
        int result = 0;
        for (ExecutionGroup<? extends SQLExecutionUnit> each : executionGroupContext.getInputGroups()) {
            result += each.getInputs().size();
        }
        return result;
    }

    private Collection<Statement> getProcessStatements(ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (ExecutionGroup<? extends SQLExecutionUnit> each : executionGroupContext.getInputGroups()) {
            for (SQLExecutionUnit sQLExecutionUnit : each.getInputs()) {
                if (!(sQLExecutionUnit instanceof JDBCExecutionUnit)) continue;
                result.add(((JDBCExecutionUnit)sQLExecutionUnit).getStorageResource());
            }
        }
        return result;
    }

    public void completeExecutionUnit() {
        this.completedUnitCount.incrementAndGet();
    }

    public int getCompletedUnitCount() {
        return this.completedUnitCount.get();
    }

    @Generated
    public Process(String id, long startMillis, String sql, String databaseName, String username, String hostname, int totalUnitCount, Collection<Statement> processStatements, AtomicInteger completedUnitCount, boolean idle, boolean heldByConnection) {
        this.id = id;
        this.startMillis = startMillis;
        this.sql = sql;
        this.databaseName = databaseName;
        this.username = username;
        this.hostname = hostname;
        this.totalUnitCount = totalUnitCount;
        this.processStatements = processStatements;
        this.completedUnitCount = completedUnitCount;
        this.idle = idle;
        this.heldByConnection = heldByConnection;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getStartMillis() {
        return this.startMillis;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public int getTotalUnitCount() {
        return this.totalUnitCount;
    }

    @Generated
    public Collection<Statement> getProcessStatements() {
        return this.processStatements;
    }

    @Generated
    public boolean isIdle() {
        return this.idle;
    }

    @Generated
    public boolean isHeldByConnection() {
        return this.heldByConnection;
    }
}

