/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.advanced.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.federation.executor.advanced.resultset.WrapperAdapter;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;

public final class FederationResultSetMetaData
extends WrapperAdapter
implements ResultSetMetaData {
    private final ShardingSphereSchema schema;
    private final AbstractSchema filterableSchema;
    private final RelDataTypeFactory relDataTypeFactory;
    private final SelectStatementContext selectStatementContext;

    @Override
    public int getColumnCount() throws SQLException {
        return this.selectStatementContext.getProjectionsContext().getExpandProjections().size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return false;
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.filterableSchema.getTable(optional)));
        return !table.isPresent() || ((Table)table.get()).getRowType(this.relDataTypeFactory).isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.filterableSchema.getTable(optional))).map(optional -> optional.getRowType(this.relDataTypeFactory).getPrecision()).orElse(0);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        Projection projection = (Projection)this.selectStatementContext.getProjectionsContext().getExpandProjections().get(column - 1);
        if (projection instanceof ColumnProjection) {
            return ((ColumnProjection)projection).getName();
        }
        return projection.getColumnLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        Projection projection = (Projection)this.selectStatementContext.getProjectionsContext().getExpandProjections().get(column - 1);
        if (projection instanceof ColumnProjection) {
            return ((ColumnProjection)projection).getName();
        }
        return projection.getColumnLabel();
    }

    @Override
    public String getSchemaName(int column) {
        return "logic_db";
    }

    @Override
    public int getPrecision(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.filterableSchema.getTable(optional)));
        return !table.isPresent() || -1 == ((Table)table.get()).getRowType(this.relDataTypeFactory).getPrecision() ? 0 : ((Table)table.get()).getRowType(this.relDataTypeFactory).getPrecision();
    }

    @Override
    public int getScale(int column) {
        Optional table = this.findTableName(column).flatMap(optional -> Optional.ofNullable(this.filterableSchema.getTable(optional)));
        return !table.isPresent() || Integer.MIN_VALUE == ((Table)table.get()).getRowType(this.relDataTypeFactory).getScale() ? 0 : ((Table)table.get()).getRowType(this.relDataTypeFactory).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.findTableName(column).orElse("");
    }

    @Override
    public String getCatalogName(int column) {
        return "logic_db";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return "";
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public String getColumnClassName(int column) {
        return "";
    }

    private Optional<String> findTableName(int column) {
        Projection projection = (Projection)this.selectStatementContext.getProjectionsContext().getExpandProjections().get(column - 1);
        if (projection instanceof ColumnProjection) {
            Map tableNamesByColumnProjection = this.selectStatementContext.getTablesContext().findTableNamesByColumnProjection(Collections.singletonList((ColumnProjection)projection), this.schema);
            return Optional.of(tableNamesByColumnProjection.get(projection.getExpression()));
        }
        return Optional.empty();
    }

    @Generated
    public FederationResultSetMetaData(ShardingSphereSchema schema, AbstractSchema filterableSchema, RelDataTypeFactory relDataTypeFactory, SelectStatementContext selectStatementContext) {
        this.schema = schema;
        this.filterableSchema = filterableSchema;
        this.relDataTypeFactory = relDataTypeFactory;
        this.selectStatementContext = selectStatementContext;
    }
}

