/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.advanced.table;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlString;
import org.apache.calcite.tools.RelBuilder;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.common.row.CommonRowEnumerator;
import org.apache.shardingsphere.infra.federation.executor.common.row.EmptyRowEnumerator;
import org.apache.shardingsphere.infra.federation.executor.common.table.CommonTableScanExecutorContext;
import org.apache.shardingsphere.infra.federation.executor.original.SQLDialectFactory;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.executor.ScanNodeExecutorContext;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TranslatableScanNodeExecutorContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.filter.FilterableSchema;
import org.apache.shardingsphere.infra.federation.optimizer.planner.QueryOptimizePlannerFactory;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.infra.util.exception.sql.SQLWrapperException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class TranslatableTableScanExecutor
implements TableScanExecutor {
    private final DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine;
    private final JDBCExecutor jdbcExecutor;
    private final JDBCExecutorCallback<? extends ExecuteResult> callback;
    private final OptimizerContext optimizerContext;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final CommonTableScanExecutorContext executorContext;
    private final EventBusContext eventBusContext;

    public Enumerable<Object[]> execute(ShardingSphereTable table, ScanNodeExecutorContext scanContext) {
        String databaseName = this.executorContext.getDatabaseName();
        String schemaName = this.executorContext.getSchemaName();
        DatabaseType databaseType = DatabaseTypeEngine.getTrunkDatabaseType((String)((OptimizerParserContext)this.optimizerContext.getParserContexts().get(databaseName)).getDatabaseType().getType());
        SqlString sqlString = this.createSQLString(table, (TranslatableScanNodeExecutorContext)scanContext, SQLDialectFactory.getSQLDialect(databaseType));
        FederationContext federationContext = this.executorContext.getFederationContext();
        QueryContext queryContext = this.createQueryContext(federationContext.getDatabases(), sqlString, databaseType);
        ShardingSphereDatabase database = federationContext.getDatabases().get(databaseName.toLowerCase());
        ExecutionContext context = new KernelProcessor().generateExecutionContext(queryContext, database, this.globalRuleMetaData, this.executorContext.getProps(), new ConnectionContext());
        if (federationContext.isPreview() || databaseType.getSystemSchemas().contains(schemaName)) {
            federationContext.getExecutionUnits().addAll(context.getExecutionUnits());
            return this.createEmptyEnumerable();
        }
        return this.execute(databaseType, queryContext, database, context);
    }

    private AbstractEnumerable<Object[]> execute(DatabaseType databaseType, QueryContext queryContext, ShardingSphereDatabase database, ExecutionContext context) {
        try {
            ExecutionGroupContext executionGroupContext = this.prepareEngine.prepare(context.getRouteContext(), context.getExecutionUnits());
            this.setParameters(executionGroupContext.getInputGroups());
            ExecuteProcessEngine.initialize((QueryContext)context.getQueryContext(), (ExecutionGroupContext)executionGroupContext, (EventBusContext)this.eventBusContext);
            List<QueryResult> queryResults = this.execute((ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext, databaseType);
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID(), (EventBusContext)this.eventBusContext);
            MergeEngine mergeEngine = new MergeEngine(database, this.executorContext.getProps(), new ConnectionContext());
            MergedResult mergedResult = mergeEngine.merge(queryResults, queryContext.getSqlStatementContext());
            Collection<Statement> statements = this.getStatements(executionGroupContext.getInputGroups());
            AbstractEnumerable<Object[]> abstractEnumerable = this.createEnumerable(mergedResult, queryResults.get(0).getMetaData(), statements);
            return abstractEnumerable;
        }
        catch (SQLException ex) {
            throw new SQLWrapperException(ex);
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    private List<QueryResult> execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, DatabaseType databaseType) throws SQLException {
        Collection queryResults = this.jdbcExecutor.execute(executionGroupContext, this.callback).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
        LinkedList<QueryResult> result = new LinkedList<QueryResult>();
        for (QueryResult each2 : queryResults) {
            QueryResult queryResult = each2 instanceof JDBCStreamQueryResult ? new JDBCMemoryQueryResult(((JDBCStreamQueryResult)each2).getResultSet(), databaseType) : each2;
            result.add(queryResult);
        }
        return result;
    }

    private Collection<Statement> getStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        LinkedList<Statement> result = new LinkedList<Statement>();
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                result.add(executionUnit.getStorageResource());
            }
        }
        return result;
    }

    private SqlString createSQLString(ShardingSphereTable table, TranslatableScanNodeExecutorContext scanContext, SqlDialect sqlDialect) {
        return new RelToSqlConverter(sqlDialect).visitRoot(this.createRelNode(table, scanContext)).asStatement().toSqlString(sqlDialect);
    }

    private void setParameters(Collection<ExecutionGroup<JDBCExecutionUnit>> inputGroups) {
        for (ExecutionGroup<JDBCExecutionUnit> each : inputGroups) {
            for (JDBCExecutionUnit executionUnit : each.getInputs()) {
                if (!(executionUnit.getStorageResource() instanceof PreparedStatement)) continue;
                this.setParameters((PreparedStatement)executionUnit.getStorageResource(), executionUnit.getExecutionUnit().getSqlUnit().getParameters());
            }
        }
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameter = parameters.get(i);
            preparedStatement.setObject(i + 1, parameter);
        }
    }

    private RelNode createRelNode(ShardingSphereTable table, TranslatableScanNodeExecutorContext scanContext) {
        String databaseName = this.executorContext.getDatabaseName();
        String schemaName = this.executorContext.getSchemaName();
        CalciteConnectionConfigImpl connectionConfig = new CalciteConnectionConfigImpl(OptimizerPlannerContextFactory.createConnectionProperties());
        ShardingSphereSchema schema = this.executorContext.getFederationContext().getDatabases().get(databaseName).getSchema(schemaName);
        CalciteCatalogReader catalogReader = OptimizerPlannerContextFactory.createCatalogReader((String)schemaName, (Schema)new FilterableSchema(schemaName, schema, null), (RelDataTypeFactory)new JavaTypeFactoryImpl(), (CalciteConnectionConfig)connectionConfig);
        RelOptCluster relOptCluster = RelOptCluster.create((RelOptPlanner)QueryOptimizePlannerFactory.createVolcanoPlanner(), (RexBuilder)new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl()));
        RelBuilder builder = RelFactories.LOGICAL_BUILDER.create(relOptCluster, (RelOptSchema)catalogReader).scan(new String[]{table.getName()});
        if (null != scanContext.getFilterValues()) {
            builder.filter(this.createFilters(scanContext.getFilterValues(), builder, table.getColumnNames()));
        }
        if (null != scanContext.getProjects()) {
            builder.project(this.createProjections(scanContext.getProjects(), builder, table.getColumnNames()));
        }
        return builder.build();
    }

    private Collection<RexNode> createFilters(String[] filterValues, RelBuilder builder, List<String> columnNames) {
        LinkedList<RexNode> result = new LinkedList<RexNode>();
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
        for (int i = 0; i < filterValues.length; ++i) {
            if (Strings.isNullOrEmpty((String)filterValues[i])) continue;
            RelDataType nonNullableInt = typeFactory.createSqlType(SqlTypeName.INTEGER);
            RexNode n2 = rexBuilder.makeLiteral((Object)Integer.valueOf(filterValues[i]), nonNullableInt, false);
            RexInputRef n1 = rexBuilder.makeInputRef(nonNullableInt, i);
            RexNode tmp = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{n1, n2});
            result.add(tmp);
        }
        return result;
    }

    private Collection<RexNode> createProjections(int[] projects, RelBuilder relBuilder, List<String> columnNames) {
        LinkedList<RexNode> result = new LinkedList<RexNode>();
        for (int each : projects) {
            result.add((RexNode)relBuilder.field(columnNames.get(each)));
        }
        return result;
    }

    private AbstractEnumerable<Object[]> createEnumerable(final MergedResult mergedResult, final QueryResultMetaData metaData, final Collection<Statement> statements) {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new CommonRowEnumerator(mergedResult, metaData, statements);
            }
        };
    }

    private QueryContext createQueryContext(Map<String, ShardingSphereDatabase> databases, SqlString sqlString, DatabaseType databaseType) {
        String sql = sqlString.getSql().replace("\n", " ");
        SQLStatement sqlStatement = new SQLStatementParserEngine(databaseType.getType(), this.optimizerContext.getSqlParserRule().getSqlStatementCache(), this.optimizerContext.getSqlParserRule().getParseTreeCache(), this.optimizerContext.getSqlParserRule().isSqlCommentParseEnabled()).parse(sql, false);
        List<Object> parameters = this.getParameters((List<Integer>)sqlString.getDynamicParameters());
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance(databases, parameters, (SQLStatement)sqlStatement, (String)this.executorContext.getDatabaseName());
        return new QueryContext(sqlStatementContext, sql, parameters);
    }

    private List<Object> getParameters(List<Integer> parameterIndexes) {
        if (null == parameterIndexes) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Integer each : parameterIndexes) {
            result.add(this.executorContext.getFederationContext().getQueryContext().getParameters().get(each));
        }
        return result;
    }

    private AbstractEnumerable<Object[]> createEmptyEnumerable() {
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new EmptyRowEnumerator();
            }
        };
    }

    @Generated
    public TranslatableTableScanExecutor(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutor jdbcExecutor, JDBCExecutorCallback<? extends ExecuteResult> callback, OptimizerContext optimizerContext, ShardingSphereRuleMetaData globalRuleMetaData, CommonTableScanExecutorContext executorContext, EventBusContext eventBusContext) {
        this.prepareEngine = prepareEngine;
        this.jdbcExecutor = jdbcExecutor;
        this.callback = callback;
        this.optimizerContext = optimizerContext;
        this.globalRuleMetaData = globalRuleMetaData;
        this.executorContext = executorContext;
        this.eventBusContext = eventBusContext;
    }
}

