/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter;

import java.util.Arrays;
import java.util.Iterator;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.exception.OptimizationSQLNodeConvertException;
import org.apache.shardingsphere.infra.federation.optimizer.converter.statement.select.SelectStatementConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.type.CombineOperatorConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.combine.CombineSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SQLNodeConverterEngine {
    public static SqlNode convert(SQLStatement statement) {
        if (statement instanceof SelectStatement) {
            SqlNode sqlNode = new SelectStatementConverter().convert((SelectStatement)statement);
            Iterator iterator = ((SelectStatement)statement).getCombines().iterator();
            if (iterator.hasNext()) {
                CombineSegment each = (CombineSegment)iterator.next();
                SqlNode combineSqlNode = SQLNodeConverterEngine.convert((SQLStatement)each.getSelectStatement());
                return new SqlBasicCall(CombineOperatorConverter.convert(each.getCombineType()), Arrays.asList(sqlNode, combineSqlNode), SqlParserPos.ZERO);
            }
            return sqlNode;
        }
        throw new OptimizationSQLNodeConvertException(statement);
    }

    @Generated
    private SQLNodeConverterEngine() {
    }
}

