/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable;

import java.lang.reflect.Type;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TranslatableScanNodeExecutorContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.statistic.FederationStatistic;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable.TranslatableTableScan;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class FederationTranslatableTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final ShardingSphereTable table;
    private final TableScanExecutor executor;
    private final FederationStatistic statistic;

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.createRelDataType(this.table, typeFactory);
    }

    public Enumerable<Object[]> projectAndFilter(DataContext root, String[] filterValues, int[] projects) {
        return this.executor.execute(this.table, new TranslatableScanNodeExecutorContext(root, filterValues, projects));
    }

    public Enumerable<Object[]> project(DataContext root, int[] projects) {
        return this.executor.execute(this.table, new TranslatableScanNodeExecutorContext(root, null, projects));
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int[] fields = this.getFieldIndexes(relOptTable.getRowType().getFieldCount());
        return new TranslatableTableScan(context.getCluster(), relOptTable, this, fields);
    }

    public String toString() {
        return "FederationTranslatableTable";
    }

    public Statistic getStatistic() {
        return this.statistic;
    }

    private int[] getFieldIndexes(int fieldCount) {
        int[] result = new int[fieldCount];
        for (int index = 0; index < fieldCount; ++index) {
            result[index] = index;
        }
        return result;
    }

    private RelDataType createRelDataType(ShardingSphereTable table, RelDataTypeFactory typeFactory) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = typeFactory.builder();
        for (ShardingSphereColumn each : table.getColumns().values()) {
            fieldInfoBuilder.add(each.getName(), this.getRelDataType(each, typeFactory));
        }
        return fieldInfoBuilder.build();
    }

    private RelDataType getRelDataType(ShardingSphereColumn column, RelDataTypeFactory typeFactory) {
        Class sqlTypeClass = SqlType.valueOf((int)column.getDataType()).clazz;
        RelDataType javaType = typeFactory.createJavaType(sqlTypeClass);
        return typeFactory.createTypeWithNullability(javaType, true);
    }

    @Generated
    public FederationTranslatableTable(ShardingSphereTable table, TableScanExecutor executor, FederationStatistic statistic) {
        this.table = table;
        this.executor = executor;
        this.statistic = statistic;
    }
}

