/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite;

import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContextDecoratorFactory;
import org.apache.shardingsphere.infra.rewrite.engine.GenericSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.RouteSQLRewriteEngine;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sqltranslator.rule.SQLTranslatorRule;

public final class SQLRewriteEntry {
    private final ShardingSphereDatabase database;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators;

    public SQLRewriteEntry(ShardingSphereDatabase database, ShardingSphereRuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        this.database = database;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.decorators = SQLRewriteContextDecoratorFactory.getInstance(database.getRuleMetaData().getRules());
    }

    public SQLRewriteResult rewrite(String sql, List<Object> parameters, SQLStatementContext<?> sqlStatementContext, RouteContext routeContext, ConnectionContext connectionContext) {
        SQLRewriteContext sqlRewriteContext = this.createSQLRewriteContext(sql, parameters, sqlStatementContext, routeContext, connectionContext);
        SQLTranslatorRule rule = (SQLTranslatorRule)this.globalRuleMetaData.getSingleRule(SQLTranslatorRule.class);
        DatabaseType protocolType = this.database.getProtocolType();
        DatabaseType storageType = this.database.getResource().getDatabaseType();
        return routeContext.getRouteUnits().isEmpty() ? new GenericSQLRewriteEngine(rule, protocolType, storageType).rewrite(sqlRewriteContext) : new RouteSQLRewriteEngine(rule, protocolType, storageType).rewrite(sqlRewriteContext, routeContext);
    }

    private SQLRewriteContext createSQLRewriteContext(String sql, List<Object> parameters, SQLStatementContext<?> sqlStatementContext, RouteContext routeContext, ConnectionContext connectionContext) {
        SQLRewriteContext result = new SQLRewriteContext(this.database.getName(), this.database.getSchemas(), sqlStatementContext, sql, parameters, connectionContext);
        this.decorate(this.decorators, result, routeContext);
        result.generateSQLTokens();
        return result;
    }

    private void decorate(Map<ShardingSphereRule, SQLRewriteContextDecorator> decorators, SQLRewriteContext sqlRewriteContext, RouteContext routeContext) {
        for (Map.Entry<ShardingSphereRule, SQLRewriteContextDecorator> entry : decorators.entrySet()) {
            entry.getValue().decorate(entry.getKey(), this.props, sqlRewriteContext, routeContext);
        }
    }
}

