/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.context;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.context.ConnectionContext;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.SQLTokenGenerators;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.builder.DefaultTokenGeneratorBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;

public final class SQLRewriteContext {
    private final String databaseName;
    private final Map<String, ShardingSphereSchema> schemas;
    private final SQLStatementContext<?> sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final ParameterBuilder parameterBuilder;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLTokenGenerators sqlTokenGenerators = new SQLTokenGenerators();
    private final ConnectionContext connectionContext;

    public SQLRewriteContext(String databaseName, Map<String, ShardingSphereSchema> schemas, SQLStatementContext<?> sqlStatementContext, String sql, List<Object> parameters, ConnectionContext connectionContext) {
        this.databaseName = databaseName;
        this.schemas = schemas;
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = parameters;
        this.connectionContext = connectionContext;
        this.addSQLTokenGenerators(new DefaultTokenGeneratorBuilder(sqlStatementContext).getSQLTokenGenerators());
        this.parameterBuilder = sqlStatementContext instanceof InsertStatementContext && null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext() ? new GroupedParameterBuilder(((InsertStatementContext)sqlStatementContext).getGroupedParameters(), ((InsertStatementContext)sqlStatementContext).getOnDuplicateKeyUpdateParameters()) : new StandardParameterBuilder(parameters);
    }

    public void addSQLTokenGenerators(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        this.sqlTokenGenerators.addAll(sqlTokenGenerators);
    }

    public void generateSQLTokens() {
        this.sqlTokens.addAll(this.sqlTokenGenerators.generateSQLTokens(this.databaseName, this.schemas, this.sqlStatementContext, this.parameters, this.connectionContext));
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public Map<String, ShardingSphereSchema> getSchemas() {
        return this.schemas;
    }

    @Generated
    public SQLStatementContext<?> getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public ParameterBuilder getParameterBuilder() {
        return this.parameterBuilder;
    }

    @Generated
    public List<SQLToken> getSqlTokens() {
        return this.sqlTokens;
    }

    @Generated
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

