/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.engine;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.engine.result.GenericSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteUnit;
import org.apache.shardingsphere.infra.rewrite.sql.impl.DefaultSQLBuilder;
import org.apache.shardingsphere.sqltranslator.rule.SQLTranslatorRule;

public final class GenericSQLRewriteEngine {
    private final SQLTranslatorRule translatorRule;
    private final DatabaseType protocolType;
    private final Map<String, StorageUnit> storageUnits;

    public GenericSQLRewriteResult rewrite(SQLRewriteContext sqlRewriteContext) {
        String sql = this.translatorRule.translate(new DefaultSQLBuilder(sqlRewriteContext).toSQL(), sqlRewriteContext.getSqlStatementContext().getSqlStatement(), this.protocolType, this.storageUnits.isEmpty() ? this.protocolType : this.storageUnits.values().iterator().next().getStorageType());
        return new GenericSQLRewriteResult(new SQLRewriteUnit(sql, sqlRewriteContext.getParameterBuilder().getParameters()));
    }

    @Generated
    public GenericSQLRewriteEngine(SQLTranslatorRule translatorRule, DatabaseType protocolType, Map<String, StorageUnit> storageUnits) {
        this.translatorRule = translatorRule;
        this.protocolType = protocolType;
        this.storageUnits = storageUnits;
    }
}

