/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.parameter.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;

public final class StandardParameterBuilder
implements ParameterBuilder {
    private final List<Object> originalParameters;
    private final Map<Integer, Collection<Object>> addedIndexAndParameters = new TreeMap<Integer, Collection<Object>>();
    private final Map<Integer, Object> replacedIndexAndParameters = new LinkedHashMap<Integer, Object>();

    public void addAddedParameters(int index, Collection<Object> params) {
        this.addedIndexAndParameters.put(index, params);
    }

    public void addReplacedParameters(int index, Object param) {
        this.replacedIndexAndParameters.put(index, param);
    }

    @Override
    public List<Object> getParameters() {
        ArrayList<Object> replacedParams = new ArrayList<Object>(this.originalParameters);
        for (Map.Entry<Integer, Object> entry : this.replacedIndexAndParameters.entrySet()) {
            replacedParams.set(entry.getKey(), entry.getValue());
        }
        int maxParamIndex = this.getMaxParameterIndex();
        LinkedList<Object> result = new LinkedList<Object>();
        for (int index = 0; index <= maxParamIndex; ++index) {
            LinkedList<Object> currentIndexParams = new LinkedList<Object>();
            if (replacedParams.size() > index) {
                currentIndexParams.add(replacedParams.get(index));
            }
            if (this.addedIndexAndParameters.containsKey(index)) {
                currentIndexParams.addAll(this.addedIndexAndParameters.get(index));
            }
            result.addAll(currentIndexParams);
        }
        return result;
    }

    private int getMaxParameterIndex() {
        return this.addedIndexAndParameters.isEmpty() ? this.originalParameters.size() - 1 : Math.max(this.originalParameters.size() - 1, (Integer)((TreeMap)this.addedIndexAndParameters).descendingMap().firstKey());
    }

    @Generated
    public StandardParameterBuilder(List<Object> originalParameters) {
        this.originalParameters = originalParameters;
    }

    @Generated
    public Map<Integer, Collection<Object>> getAddedIndexAndParameters() {
        return this.addedIndexAndParameters;
    }
}

