/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.hint.SQLHintDataSourceNotExistsException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.route.engine.SQLRouteExecutor;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class PartialSQLRouteExecutor
implements SQLRouteExecutor {
    private final ConfigurationProperties props;
    private final Map<ShardingSphereRule, SQLRouter> routers;

    public PartialSQLRouteExecutor(Collection<ShardingSphereRule> rules, ConfigurationProperties props) {
        this.props = props;
        this.routers = OrderedSPILoader.getServices(SQLRouter.class, rules);
    }

    @Override
    public RouteContext route(ConnectionContext connectionContext, QueryContext queryContext, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database) {
        RouteContext result = new RouteContext();
        Optional<String> dataSourceName = this.findDataSourceByHint(queryContext.getHintValueContext(), database.getResourceMetaData().getStorageUnitMetaData().getStorageUnits());
        if (dataSourceName.isPresent()) {
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName.get(), dataSourceName.get()), Collections.emptyList()));
            return result;
        }
        for (Map.Entry<ShardingSphereRule, SQLRouter> entry : this.routers.entrySet()) {
            if (result.getRouteUnits().isEmpty()) {
                result = entry.getValue().createRouteContext(queryContext, globalRuleMetaData, database, entry.getKey(), this.props, connectionContext);
                continue;
            }
            entry.getValue().decorateRouteContext(result, queryContext, database, entry.getKey(), this.props, connectionContext);
        }
        if (result.getRouteUnits().isEmpty() && 1 == database.getResourceMetaData().getStorageUnitMetaData().getStorageUnits().size()) {
            String singleDataSourceName = (String)database.getResourceMetaData().getStorageUnitMetaData().getStorageUnits().keySet().iterator().next();
            result.getRouteUnits().add(new RouteUnit(new RouteMapper(singleDataSourceName, singleDataSourceName), Collections.emptyList()));
        }
        return result;
    }

    private Optional<String> findDataSourceByHint(HintValueContext hintValueContext, Map<String, StorageUnit> storageUnits) {
        Optional result;
        Optional optional = result = HintManager.isInstantiated() && HintManager.getDataSourceName().isPresent() ? HintManager.getDataSourceName() : hintValueContext.findHintDataSourceName();
        if (result.isPresent() && !storageUnits.containsKey(result.get())) {
            throw new SQLHintDataSourceNotExistsException((String)result.get());
        }
        return result;
    }
}

