/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.type.typed;

import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;

public final class TypedSPILoader {
    public static <T extends TypedSPI> Optional<T> findService(Class<T> serviceInterface, Object type) {
        return TypedSPILoader.findService(serviceInterface, type, new Properties());
    }

    public static <T extends TypedSPI> Optional<T> findService(Class<T> serviceInterface, Object type, Properties props) {
        if (null == type) {
            return TypedSPILoader.findDefaultService(serviceInterface);
        }
        for (TypedSPI each : ShardingSphereServiceLoader.getServiceInstances(serviceInterface)) {
            if (!TypedSPILoader.matchesType(type, each)) continue;
            each.init(null == props ? new Properties() : TypedSPILoader.convertToStringTypedProperties(props));
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private static <T extends TypedSPI> Optional<T> findDefaultService(Class<T> serviceInterface) {
        for (TypedSPI each : ShardingSphereServiceLoader.getServiceInstances(serviceInterface)) {
            if (!each.isDefault()) continue;
            each.init(new Properties());
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private static Properties convertToStringTypedProperties(Properties props) {
        if (props.isEmpty()) {
            return props;
        }
        Properties result = new Properties();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> result.setProperty(key.toString(), null == value ? null : value.toString())));
        return result;
    }

    public static <T extends TypedSPI> T getService(Class<T> serviceInterface, Object type) {
        return TypedSPILoader.getService(serviceInterface, type, new Properties());
    }

    public static <T extends TypedSPI> T getService(Class<T> serviceInterface, Object type, Properties props) {
        return (T)((TypedSPI)TypedSPILoader.findService(serviceInterface, type, props).orElseThrow(() -> new ServiceProviderNotFoundException(serviceInterface, type)));
    }

    public static <T extends TypedSPI> void checkService(Class<T> serviceInterface, Object type, Properties props) {
        for (TypedSPI each : ShardingSphereServiceLoader.getServiceInstances(serviceInterface)) {
            if (!TypedSPILoader.matchesType(type, each)) continue;
            each.init(null == props ? new Properties() : TypedSPILoader.convertToStringTypedProperties(props));
            return;
        }
        throw new ServiceProviderNotFoundException(serviceInterface, type);
    }

    private static boolean matchesType(Object type, TypedSPI instance) {
        Object instanceType = instance.getType();
        if (null == instanceType) {
            return false;
        }
        if (instanceType instanceof String && type instanceof String) {
            return instanceType.toString().equalsIgnoreCase(type.toString()) || instance.getTypeAliases().contains(type);
        }
        return instanceType.equals(type) || instance.getTypeAliases().contains(type);
    }

    @Generated
    private TypedSPILoader() {
    }
}

