/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.props;

import lombok.Generated;
import org.apache.shardingsphere.infra.util.props.TypedPropertyKey;
import org.apache.shardingsphere.infra.util.props.exception.TypedPropertyValueException;

public final class TypedPropertyValue {
    private final Object value;

    public TypedPropertyValue(TypedPropertyKey key, String value) {
        this.value = this.createTypedValue(key, value);
    }

    private Object createTypedValue(TypedPropertyKey key, String value) {
        if (Boolean.TYPE == key.getType() || Boolean.class == key.getType()) {
            return Boolean.valueOf(value);
        }
        if (Integer.TYPE == key.getType() || Integer.class == key.getType()) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new TypedPropertyValueException(key, value);
            }
        }
        if (Long.TYPE == key.getType() || Long.class == key.getType()) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException ex) {
                throw new TypedPropertyValueException(key, value);
            }
        }
        return value;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }
}

