/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.statement.type;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DDLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.statement.MySQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.enums.AlgorithmOption;
import org.apache.shardingsphere.sql.parser.sql.common.enums.LockTableOption;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.charset.CharsetNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ChangeColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.position.ColumnAfterPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.position.ColumnFirstPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.AddConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.DropConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.alter.ModifyConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.engine.EngineSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.DropIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.RenameIndexDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.FunctionNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.RoutineBodySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.routine.ValidStatementSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.AlgorithmTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.ConvertTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.CreateTableOptionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.LockTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.tablespace.TablespaceSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.CommentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterEventStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterInstanceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLAlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateEventStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLCreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDeallocateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropEventStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropFunctionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropLogfileGroupStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropProcedureStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropTablespaceStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropTriggerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLDropViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLExecuteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLPrepareStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLRenameTableStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.ddl.MySQLTruncateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLUpdateStatement;

public final class MySQLDDLStatementVisitor
extends MySQLStatementVisitor
implements DDLStatementVisitor {
    @Override
    public ASTNode visitCreateView(MySQLStatementParser.CreateViewContext ctx) {
        MySQLCreateViewStatement result = new MySQLCreateViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)((MySQLSelectStatement)this.visit((ParseTree)ctx.select())));
        return result;
    }

    @Override
    public ASTNode visitAlterView(MySQLStatementParser.AlterViewContext ctx) {
        MySQLAlterViewStatement result = new MySQLAlterViewStatement();
        result.setView((SimpleTableSegment)this.visit((ParseTree)ctx.viewName()));
        result.setViewDefinition(this.getOriginalText(ctx.select()));
        result.setSelect((SelectStatement)((MySQLSelectStatement)this.visit((ParseTree)ctx.select())));
        return result;
    }

    @Override
    public ASTNode visitDropView(MySQLStatementParser.DropViewContext ctx) {
        MySQLDropViewStatement result = new MySQLDropViewStatement();
        result.getViews().addAll(((CollectionValue)this.visit((ParseTree)ctx.viewNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitCreateDatabase(MySQLStatementParser.CreateDatabaseContext ctx) {
        MySQLCreateDatabaseStatement result = new MySQLCreateDatabaseStatement();
        result.setDatabaseName(new IdentifierValue(ctx.schemaName().getText()).getValue());
        result.setIfNotExists(null != ctx.ifNotExists());
        return result;
    }

    @Override
    public ASTNode visitAlterDatabase(MySQLStatementParser.AlterDatabaseContext ctx) {
        return new MySQLAlterDatabaseStatement();
    }

    @Override
    public ASTNode visitDropDatabase(MySQLStatementParser.DropDatabaseContext ctx) {
        MySQLDropDatabaseStatement result = new MySQLDropDatabaseStatement();
        result.setDatabaseName(new IdentifierValue(ctx.schemaName().getText()).getValue());
        result.setIfExists(null != ctx.ifExists());
        return result;
    }

    @Override
    public ASTNode visitCreateTable(MySQLStatementParser.CreateTableContext ctx) {
        MySQLCreateTableStatement result = new MySQLCreateTableStatement(null != ctx.ifNotExists());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        if (null != ctx.createLikeClause()) {
            result.setLikeTable((SimpleTableSegment)this.visit((ParseTree)ctx.createLikeClause()));
        }
        if (null != ctx.createTableOptions()) {
            result.setCreateTableOptionSegment((CreateTableOptionSegment)this.visit((ParseTree)ctx.createTableOptions()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateTableOptions(MySQLStatementParser.CreateTableOptionsContext ctx) {
        CreateTableOptionSegment result = new CreateTableOptionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        for (MySQLStatementParser.CreateTableOptionContext each : ctx.createTableOption()) {
            if (null != each.engineRef()) {
                result.setEngine((EngineSegment)this.visit((ParseTree)each.engineRef()));
                continue;
            }
            if (null == each.COMMENT()) continue;
            result.setCommentSegment(new CommentSegment(each.string_().getText(), each.string_().getStart().getStartIndex(), each.string_().getStop().getStopIndex()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(MySQLStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.TableElementContext each : ctx.tableElementList().tableElement()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraintDef()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraintDef()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateLikeClause(MySQLStatementParser.CreateLikeClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitAlterTable(MySQLStatementParser.AlterTableContext ctx) {
        MySQLAlterTableStatement result = new MySQLAlterTableStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null == ctx.alterTableActions() || null == ctx.alterTableActions().alterCommandList() || null == ctx.alterTableActions().alterCommandList().alterList()) {
            return result;
        }
        for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)ctx.alterTableActions().alterCommandList().alterList())).getValue()) {
            this.setAlterDefinition(result, each);
        }
        return result;
    }

    private void setAlterDefinition(MySQLAlterTableStatement alterTableStatement, AlterDefinitionSegment alterDefinitionSegment) {
        if (alterDefinitionSegment instanceof AddColumnDefinitionSegment) {
            alterTableStatement.getAddColumnDefinitions().add((AddColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof ModifyColumnDefinitionSegment) {
            alterTableStatement.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof ChangeColumnDefinitionSegment) {
            alterTableStatement.getChangeColumnDefinitions().add((ChangeColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropColumnDefinitionSegment) {
            alterTableStatement.getDropColumnDefinitions().add((DropColumnDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof AddConstraintDefinitionSegment) {
            alterTableStatement.getAddConstraintDefinitions().add((AddConstraintDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropConstraintDefinitionSegment) {
            alterTableStatement.getDropConstraintDefinitions().add((DropConstraintDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameTableDefinitionSegment) {
            alterTableStatement.setRenameTable(((RenameTableDefinitionSegment)alterDefinitionSegment).getRenameTable());
        } else if (alterDefinitionSegment instanceof ConvertTableDefinitionSegment) {
            alterTableStatement.setConvertTableDefinition((ConvertTableDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof DropIndexDefinitionSegment) {
            alterTableStatement.getDropIndexDefinitions().add((DropIndexDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameIndexDefinitionSegment) {
            alterTableStatement.getRenameIndexDefinitions().add((RenameIndexDefinitionSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof RenameColumnSegment) {
            alterTableStatement.getRenameColumnDefinitions().add((RenameColumnSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof AlgorithmTypeSegment) {
            alterTableStatement.setAlgorithmSegment((AlgorithmTypeSegment)alterDefinitionSegment);
        } else if (alterDefinitionSegment instanceof LockTableSegment) {
            alterTableStatement.setLockTableSegment((LockTableSegment)alterDefinitionSegment);
        }
    }

    private ColumnDefinitionSegment generateColumnDefinitionSegment(ColumnSegment column, MySQLStatementParser.FieldDefinitionContext ctx) {
        DataTypeSegment dataTypeSegment = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = ctx.columnAttribute().stream().anyMatch(each -> null != each.KEY() && null == each.UNIQUE());
        return new ColumnDefinitionSegment(column.getStartIndex(), ctx.getStop().getStopIndex(), column, dataTypeSegment, isPrimaryKey, false);
    }

    @Override
    public ASTNode visitAlterConstraint(MySQLStatementParser.AlterConstraintContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterList(MySQLStatementParser.AlterListContext ctx) {
        CollectionValue result = new CollectionValue();
        if (ctx.alterListItem().isEmpty()) {
            return result;
        }
        result.getValue().addAll(this.getAlterDefinitionSegments(ctx));
        for (MySQLStatementParser.AlterCommandsModifierContext each : ctx.alterCommandsModifier()) {
            if (null != each.alterAlgorithmOption()) {
                result.getValue().add((AlgorithmTypeSegment)this.visit((ParseTree)each));
                continue;
            }
            if (null == each.alterLockOption()) continue;
            result.getValue().add((LockTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private Collection<AlterDefinitionSegment> getAlterDefinitionSegments(MySQLStatementParser.AlterListContext ctx) {
        LinkedList<AlterDefinitionSegment> result = new LinkedList<AlterDefinitionSegment>();
        for (MySQLStatementParser.AlterListItemContext each : ctx.alterListItem()) {
            this.getAlterDefinitionSegment(ctx, each).ifPresent(result::add);
        }
        return result;
    }

    private Optional<AlterDefinitionSegment> getAlterDefinitionSegment(MySQLStatementParser.AlterListContext alterListContext, MySQLStatementParser.AlterListItemContext alterListItemContext) {
        if (alterListItemContext instanceof MySQLStatementParser.AddColumnContext) {
            return Optional.of((AddColumnDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.AlterConstraintContext || alterListItemContext instanceof MySQLStatementParser.AlterCheckContext) {
            return Optional.of((AlterDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.ChangeColumnContext) {
            return Optional.of(this.generateModifyColumnDefinitionSegment((MySQLStatementParser.ChangeColumnContext)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.ModifyColumnContext) {
            return Optional.of(this.generateModifyColumnDefinitionSegment((MySQLStatementParser.ModifyColumnContext)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.AlterTableDropContext) {
            return this.getDropItemDefinitionSegment(alterListContext, (MySQLStatementParser.AlterTableDropContext)alterListItemContext);
        }
        if (alterListItemContext instanceof MySQLStatementParser.AddTableConstraintContext) {
            return Optional.of((AddConstraintDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.AlterRenameTableContext) {
            return Optional.of((RenameTableDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.AlterConvertContext) {
            return Optional.of((ConvertTableDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.RenameColumnContext) {
            return Optional.of((RenameColumnSegment)this.visit((ParseTree)alterListItemContext));
        }
        if (alterListItemContext instanceof MySQLStatementParser.RenameIndexContext) {
            return Optional.of((RenameIndexDefinitionSegment)this.visit((ParseTree)alterListItemContext));
        }
        return Optional.empty();
    }

    private Optional<AlterDefinitionSegment> getDropItemDefinitionSegment(MySQLStatementParser.AlterListContext alterListContext, MySQLStatementParser.AlterTableDropContext alterTableDrop) {
        if (null != alterTableDrop.CHECK() || null != alterTableDrop.CONSTRAINT()) {
            ConstraintSegment constraint = new ConstraintSegment(alterTableDrop.identifier().getStart().getStartIndex(), alterTableDrop.identifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)alterTableDrop.identifier()));
            return Optional.of(new DropConstraintDefinitionSegment(alterListContext.getStart().getStartIndex(), alterListContext.getStop().getStopIndex(), constraint));
        }
        if (null == alterTableDrop.KEY() && null == alterTableDrop.keyOrIndex()) {
            ColumnSegment column = new ColumnSegment(alterTableDrop.columnInternalRef.start.getStartIndex(), alterTableDrop.columnInternalRef.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)alterTableDrop.columnInternalRef));
            return Optional.of(new DropColumnDefinitionSegment(alterTableDrop.getStart().getStartIndex(), alterTableDrop.getStop().getStopIndex(), Collections.singleton(column)));
        }
        if (null != alterTableDrop.keyOrIndex()) {
            return Optional.of(new DropIndexDefinitionSegment(alterListContext.getStart().getStartIndex(), alterListContext.getStop().getStopIndex(), (IndexSegment)this.visit((ParseTree)alterTableDrop.indexName())));
        }
        return Optional.empty();
    }

    @Override
    public ASTNode visitAlterAlgorithmOption(MySQLStatementParser.AlterAlgorithmOptionContext ctx) {
        AlgorithmOption algorithmOption = null;
        if (null != ctx.INSTANT()) {
            algorithmOption = AlgorithmOption.INSTANT;
        } else if (null != ctx.DEFAULT()) {
            algorithmOption = AlgorithmOption.DEFAULT;
        } else if (null != ctx.INPLACE()) {
            algorithmOption = AlgorithmOption.INPLACE;
        } else if (null != ctx.COPY()) {
            algorithmOption = AlgorithmOption.COPY;
        }
        return new AlgorithmTypeSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), algorithmOption);
    }

    @Override
    public ASTNode visitAlterLockOption(MySQLStatementParser.AlterLockOptionContext ctx) {
        LockTableOption lockOption = null;
        if (null != ctx.DEFAULT()) {
            lockOption = LockTableOption.DEFAULT;
        } else if (null != ctx.NONE()) {
            lockOption = LockTableOption.NONE;
        } else if (null != ctx.SHARED()) {
            lockOption = LockTableOption.SHARED;
        } else if (null != ctx.EXCLUSIVE()) {
            lockOption = LockTableOption.EXCLUSIVE;
        }
        return new LockTableSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), lockOption);
    }

    @Override
    public ASTNode visitAlterConvert(MySQLStatementParser.AlterConvertContext ctx) {
        ConvertTableDefinitionSegment result = new ConvertTableDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (CharsetNameSegment)this.visit((ParseTree)ctx.charsetName()));
        if (null != ctx.collateClause()) {
            result.setCollateValue((SimpleExpressionSegment)this.visit((ParseTree)ctx.collateClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitCharsetName(MySQLStatementParser.CharsetNameContext ctx) {
        return new CharsetNameSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitAddTableConstraint(MySQLStatementParser.AddTableConstraintContext ctx) {
        return new AddConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintDefinitionSegment)this.visit((ParseTree)ctx.tableConstraintDef()));
    }

    @Override
    public ASTNode visitAlterCheck(MySQLStatementParser.AlterCheckContext ctx) {
        return new ModifyConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ConstraintSegment)this.visit((ParseTree)ctx.constraintName()));
    }

    @Override
    public ASTNode visitAlterRenameTable(MySQLStatementParser.AlterRenameTableContext ctx) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.setRenameTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitRenameTable(MySQLStatementParser.RenameTableContext ctx) {
        MySQLRenameTableStatement result = new MySQLRenameTableStatement();
        int len = ctx.tableName().size();
        for (int i = 0; i < len; i += 2) {
            MySQLStatementParser.TableNameContext tableName = ctx.tableName(i);
            MySQLStatementParser.TableNameContext renameTableName = ctx.tableName(i + 1);
            result.getRenameTables().add(this.createRenameTableDefinitionSegment(tableName, renameTableName));
        }
        return result;
    }

    private RenameTableDefinitionSegment createRenameTableDefinitionSegment(MySQLStatementParser.TableNameContext tableName, MySQLStatementParser.TableNameContext renameTableName) {
        RenameTableDefinitionSegment result = new RenameTableDefinitionSegment(tableName.start.getStartIndex(), renameTableName.stop.getStopIndex());
        result.setTable((SimpleTableSegment)this.visit((ParseTree)tableName));
        result.setRenameTable((SimpleTableSegment)this.visit((ParseTree)renameTableName));
        return result;
    }

    private ModifyColumnDefinitionSegment generateModifyColumnDefinitionSegment(MySQLStatementParser.ModifyColumnContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.columnInternalRef.start.getStartIndex(), ctx.columnInternalRef.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.columnInternalRef));
        ModifyColumnDefinitionSegment result = new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.generateColumnDefinitionSegment(column, ctx.fieldDefinition()));
        if (null != ctx.place()) {
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    private ChangeColumnDefinitionSegment generateModifyColumnDefinitionSegment(MySQLStatementParser.ChangeColumnContext ctx) {
        ChangeColumnDefinitionSegment result = new ChangeColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition()));
        result.setPreviousColumn(new ColumnSegment(ctx.columnInternalRef.getStart().getStartIndex(), ctx.columnInternalRef.getStop().getStopIndex(), new IdentifierValue(ctx.columnInternalRef.getText())));
        if (null != ctx.place()) {
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumn(MySQLStatementParser.AddColumnContext ctx) {
        LinkedList<ColumnDefinitionSegment> columnDefinitions = new LinkedList<ColumnDefinitionSegment>();
        if (null != ctx.columnDefinition()) {
            columnDefinitions.add((ColumnDefinitionSegment)this.visit((ParseTree)ctx.columnDefinition()));
        }
        if (null != ctx.tableElementList()) {
            for (MySQLStatementParser.TableElementContext each : ctx.tableElementList().tableElement()) {
                if (null == each.columnDefinition()) continue;
                columnDefinitions.add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
        }
        AddColumnDefinitionSegment result = new AddColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinitions);
        if (null != ctx.place()) {
            Preconditions.checkState((1 == columnDefinitions.size() ? 1 : 0) != 0);
            result.setColumnPosition((ColumnPositionSegment)this.visit((ParseTree)ctx.place()));
        }
        return result;
    }

    @Override
    public ASTNode visitRenameColumn(MySQLStatementParser.RenameColumnContext ctx) {
        ColumnSegment oldColumnSegment = (ColumnSegment)this.visit((ParseTree)ctx.oldColumn());
        ColumnSegment newColumnSegment = (ColumnSegment)this.visit((ParseTree)ctx.newColumn());
        return new RenameColumnSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), oldColumnSegment, newColumnSegment);
    }

    @Override
    public ASTNode visitColumnDefinition(MySQLStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.column_name.start.getStartIndex(), ctx.column_name.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.column_name));
        DataTypeSegment dataTypeSegment = (DataTypeSegment)this.visit((ParseTree)ctx.fieldDefinition().dataType());
        boolean isPrimaryKey = ctx.fieldDefinition().columnAttribute().stream().anyMatch(each -> null != each.KEY() && null == each.UNIQUE());
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataTypeSegment, isPrimaryKey, false);
        result.getReferencedTables().addAll(this.getReferencedTables(ctx));
        return result;
    }

    private Collection<SimpleTableSegment> getReferencedTables(MySQLStatementParser.ColumnDefinitionContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        if (null != ctx.referenceDefinition()) {
            result.add((SimpleTableSegment)this.visit((ParseTree)ctx.referenceDefinition()));
        }
        return result;
    }

    @Override
    public ASTNode visitTableConstraintDef(MySQLStatementParser.TableConstraintDefContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.constraintClause() && null != ctx.constraintClause().constraintName()) {
            result.setConstraintName((ConstraintSegment)this.visit((ParseTree)ctx.constraintClause().constraintName()));
        }
        if (null != ctx.KEY() && null != ctx.PRIMARY()) {
            result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
            return result;
        }
        if (null != ctx.FOREIGN()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.referenceDefinition()));
            return result;
        }
        if (null != ctx.UNIQUE()) {
            result.getIndexColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
            if (null != ctx.indexName()) {
                result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
            }
            return result;
        }
        if (null != ctx.checkConstraint()) {
            return result;
        }
        result.getIndexColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
        if (null != ctx.indexName()) {
            result.setIndexName((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        return result;
    }

    @Override
    public ASTNode visitKeyListWithExpression(MySQLStatementParser.KeyListWithExpressionContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.KeyPartWithExpressionContext each : ctx.keyPartWithExpression()) {
            if (null == each.keyPart()) continue;
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each.keyPart().columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitReferenceDefinition(MySQLStatementParser.ReferenceDefinitionContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitPlace(MySQLStatementParser.PlaceContext ctx) {
        ColumnSegment columnName = null;
        if (null != ctx.columnName()) {
            columnName = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        }
        return null == ctx.columnName() ? new ColumnFirstPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName) : new ColumnAfterPositionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnName);
    }

    @Override
    public ASTNode visitDropTable(MySQLStatementParser.DropTableContext ctx) {
        MySQLDropTableStatement result = new MySQLDropTableStatement(null != ctx.ifExists());
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableList())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(MySQLStatementParser.TruncateTableContext ctx) {
        MySQLTruncateStatement result = new MySQLTruncateStatement();
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitCreateIndex(MySQLStatementParser.CreateIndexContext ctx) {
        MySQLCreateIndexStatement result = new MySQLCreateIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.setIndex(new IndexSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), indexName));
        result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.keyListWithExpression())).getValue());
        if (null != ctx.algorithmOptionAndLockOption()) {
            if (null != ctx.algorithmOptionAndLockOption().alterAlgorithmOption()) {
                result.setAlgorithmSegment((AlgorithmTypeSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterAlgorithmOption()));
            }
            if (null != ctx.algorithmOptionAndLockOption().alterLockOption()) {
                result.setLockTableSegment((LockTableSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterLockOption()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDropIndex(MySQLStatementParser.DropIndexContext ctx) {
        MySQLDropIndexStatement result = new MySQLDropIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        IndexNameSegment indexName = new IndexNameSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), new IdentifierValue(ctx.indexName().getText()));
        result.getIndexes().add(new IndexSegment(ctx.indexName().start.getStartIndex(), ctx.indexName().stop.getStopIndex(), indexName));
        if (null != ctx.algorithmOptionAndLockOption()) {
            if (null != ctx.algorithmOptionAndLockOption().alterAlgorithmOption()) {
                result.setAlgorithmSegment((AlgorithmTypeSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterAlgorithmOption()));
            }
            if (null != ctx.algorithmOptionAndLockOption().alterLockOption()) {
                result.setLockTableSegment((LockTableSegment)this.visit((ParseTree)ctx.algorithmOptionAndLockOption().alterLockOption()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitRenameIndex(MySQLStatementParser.RenameIndexContext ctx) {
        IndexSegment indexNameSegment = (IndexSegment)this.visitIndexName(ctx.indexName(0));
        IndexSegment renameIndexName = (IndexSegment)this.visitIndexName(ctx.indexName(1));
        return new RenameIndexDefinitionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), indexNameSegment, renameIndexName);
    }

    @Override
    public ASTNode visitKeyParts(MySQLStatementParser.KeyPartsContext ctx) {
        CollectionValue result = new CollectionValue();
        List<MySQLStatementParser.KeyPartContext> keyParts = ctx.keyPart();
        for (MySQLStatementParser.KeyPartContext each : keyParts) {
            if (null == each.columnName()) continue;
            result.getValue().add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateProcedure(MySQLStatementParser.CreateProcedureContext ctx) {
        MySQLCreateProcedureStatement result = new MySQLCreateProcedureStatement();
        result.setProcedureName((FunctionNameSegment)this.visit((ParseTree)ctx.functionName()));
        result.setRoutineBody((RoutineBodySegment)this.visit((ParseTree)ctx.routineBody()));
        return result;
    }

    @Override
    public ASTNode visitFunctionName(MySQLStatementParser.FunctionNameContext ctx) {
        FunctionNameSegment result = new FunctionNameSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        if (null != ctx.owner()) {
            result.setOwner((OwnerSegment)this.visit((ParseTree)ctx.owner()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterProcedure(MySQLStatementParser.AlterProcedureContext ctx) {
        return new MySQLAlterProcedureStatement();
    }

    @Override
    public ASTNode visitDropProcedure(MySQLStatementParser.DropProcedureContext ctx) {
        return new MySQLDropProcedureStatement();
    }

    @Override
    public ASTNode visitCreateFunction(MySQLStatementParser.CreateFunctionContext ctx) {
        MySQLCreateFunctionStatement result = new MySQLCreateFunctionStatement();
        result.setFunctionName((FunctionNameSegment)this.visit((ParseTree)ctx.functionName()));
        result.setRoutineBody((RoutineBodySegment)this.visit((ParseTree)ctx.routineBody()));
        return result;
    }

    @Override
    public ASTNode visitRoutineBody(MySQLStatementParser.RoutineBodyContext ctx) {
        RoutineBodySegment result = new RoutineBodySegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        CollectionValue validStatements = null == ctx.simpleStatement() ? (CollectionValue)this.visit((ParseTree)ctx.compoundStatement()) : (CollectionValue)this.visit((ParseTree)ctx.simpleStatement());
        result.getValidStatements().addAll(validStatements.getValue());
        return result;
    }

    @Override
    public ASTNode visitSimpleStatement(MySQLStatementParser.SimpleStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.validStatement());
    }

    @Override
    public ASTNode visitCompoundStatement(MySQLStatementParser.CompoundStatementContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.beginStatement());
    }

    @Override
    public ASTNode visitBeginStatement(MySQLStatementParser.BeginStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitValidStatement(MySQLStatementParser.ValidStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        ValidStatementSegment validStatement = this.createValidStatementSegment(ctx);
        if (null != validStatement.getSqlStatement()) {
            result.getValue().add(validStatement);
        }
        if (null != ctx.beginStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.beginStatement()));
        }
        if (null != ctx.flowControlStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.flowControlStatement()));
        }
        return result;
    }

    private ValidStatementSegment createValidStatementSegment(MySQLStatementParser.ValidStatementContext ctx) {
        ValidStatementSegment result = new ValidStatementSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        MySQLCreateTableStatement sqlStatement = null;
        if (null != ctx.createTable()) {
            sqlStatement = (MySQLCreateTableStatement)this.visit((ParseTree)ctx.createTable());
        } else if (null != ctx.alterTable()) {
            sqlStatement = (MySQLAlterTableStatement)this.visit((ParseTree)ctx.alterTable());
        } else if (null != ctx.dropTable()) {
            sqlStatement = (MySQLDropTableStatement)this.visit((ParseTree)ctx.dropTable());
        } else if (null != ctx.truncateTable()) {
            sqlStatement = (MySQLTruncateStatement)this.visit((ParseTree)ctx.truncateTable());
        } else if (null != ctx.insert()) {
            sqlStatement = (MySQLInsertStatement)this.visit((ParseTree)ctx.insert());
        } else if (null != ctx.replace()) {
            sqlStatement = (MySQLInsertStatement)this.visit((ParseTree)ctx.replace());
        } else if (null != ctx.update()) {
            sqlStatement = (MySQLUpdateStatement)this.visit((ParseTree)ctx.update());
        } else if (null != ctx.delete()) {
            sqlStatement = (MySQLDeleteStatement)this.visit((ParseTree)ctx.delete());
        } else if (null != ctx.select()) {
            sqlStatement = (MySQLSelectStatement)this.visit((ParseTree)ctx.select());
        }
        result.setSqlStatement((SQLStatement)sqlStatement);
        return result;
    }

    @Override
    public ASTNode visitFlowControlStatement(MySQLStatementParser.FlowControlStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.caseStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.caseStatement()));
        }
        if (null != ctx.ifStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.ifStatement()));
        }
        if (null != ctx.loopStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.loopStatement()));
        }
        if (null != ctx.repeatStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.repeatStatement()));
        }
        if (null != ctx.whileStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)ctx.whileStatement()));
        }
        return result;
    }

    @Override
    public ASTNode visitCaseStatement(MySQLStatementParser.CaseStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitIfStatement(MySQLStatementParser.IfStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitLoopStatement(MySQLStatementParser.LoopStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitRepeatStatement(MySQLStatementParser.RepeatStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitWhileStatement(MySQLStatementParser.WhileStatementContext ctx) {
        CollectionValue result = new CollectionValue();
        for (MySQLStatementParser.ValidStatementContext each : ctx.validStatement()) {
            result.combine((CollectionValue)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterFunction(MySQLStatementParser.AlterFunctionContext ctx) {
        return new MySQLAlterFunctionStatement();
    }

    @Override
    public ASTNode visitDropFunction(MySQLStatementParser.DropFunctionContext ctx) {
        return new MySQLDropFunctionStatement();
    }

    @Override
    public ASTNode visitCreateEvent(MySQLStatementParser.CreateEventContext ctx) {
        return new MySQLCreateEventStatement();
    }

    @Override
    public ASTNode visitAlterEvent(MySQLStatementParser.AlterEventContext ctx) {
        return new MySQLAlterEventStatement();
    }

    @Override
    public ASTNode visitDropEvent(MySQLStatementParser.DropEventContext ctx) {
        return new MySQLDropEventStatement();
    }

    @Override
    public ASTNode visitAlterInstance(MySQLStatementParser.AlterInstanceContext ctx) {
        return new MySQLAlterInstanceStatement();
    }

    @Override
    public ASTNode visitCreateLogfileGroup(MySQLStatementParser.CreateLogfileGroupContext ctx) {
        return new MySQLCreateLogfileGroupStatement();
    }

    @Override
    public ASTNode visitAlterLogfileGroup(MySQLStatementParser.AlterLogfileGroupContext ctx) {
        return new MySQLAlterLogfileGroupStatement();
    }

    @Override
    public ASTNode visitDropLogfileGroup(MySQLStatementParser.DropLogfileGroupContext ctx) {
        return new MySQLDropLogfileGroupStatement();
    }

    @Override
    public ASTNode visitCreateServer(MySQLStatementParser.CreateServerContext ctx) {
        return new MySQLCreateServerStatement();
    }

    @Override
    public ASTNode visitAlterServer(MySQLStatementParser.AlterServerContext ctx) {
        return new MySQLAlterServerStatement();
    }

    @Override
    public ASTNode visitDropServer(MySQLStatementParser.DropServerContext ctx) {
        return new MySQLDropServerStatement();
    }

    @Override
    public ASTNode visitCreateTrigger(MySQLStatementParser.CreateTriggerContext ctx) {
        return new MySQLCreateTriggerStatement();
    }

    @Override
    public ASTNode visitDropTrigger(MySQLStatementParser.DropTriggerContext ctx) {
        return new MySQLDropTriggerStatement();
    }

    @Override
    public ASTNode visitCreateTablespace(MySQLStatementParser.CreateTablespaceContext ctx) {
        return new MySQLCreateTablespaceStatement();
    }

    @Override
    public ASTNode visitAlterTablespace(MySQLStatementParser.AlterTablespaceContext ctx) {
        if (null != ctx.alterTablespaceInnodb()) {
            return (ASTNode)this.visit((ParseTree)ctx.alterTablespaceInnodb());
        }
        return (ASTNode)this.visit((ParseTree)ctx.alterTablespaceNdb());
    }

    @Override
    public ASTNode visitAlterTablespaceInnodb(MySQLStatementParser.AlterTablespaceInnodbContext ctx) {
        MySQLAlterTablespaceStatement result = new MySQLAlterTablespaceStatement();
        if (null != ctx.tablespace) {
            result.setTablespaceSegment(this.createTablespaceSegment(ctx.tablespace));
        }
        if (null != ctx.renameTablespace) {
            result.setRenameTablespaceSegment(this.createTablespaceSegment(ctx.renameTablespace));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTablespaceNdb(MySQLStatementParser.AlterTablespaceNdbContext ctx) {
        MySQLAlterTablespaceStatement result = new MySQLAlterTablespaceStatement();
        if (null != ctx.tablespace) {
            result.setTablespaceSegment(this.createTablespaceSegment(ctx.tablespace));
        }
        if (null != ctx.renameTableSpace) {
            result.setRenameTablespaceSegment(this.createTablespaceSegment(ctx.renameTableSpace));
        }
        return result;
    }

    private TablespaceSegment createTablespaceSegment(MySQLStatementParser.IdentifierContext ctx) {
        return new TablespaceSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx));
    }

    @Override
    public ASTNode visitDropTablespace(MySQLStatementParser.DropTablespaceContext ctx) {
        return new MySQLDropTablespaceStatement();
    }

    @Override
    public ASTNode visitPrepare(MySQLStatementParser.PrepareContext ctx) {
        return new MySQLPrepareStatement();
    }

    @Override
    public ASTNode visitExecuteStmt(MySQLStatementParser.ExecuteStmtContext ctx) {
        return new MySQLExecuteStatement();
    }

    @Override
    public ASTNode visitDeallocate(MySQLStatementParser.DeallocateContext ctx) {
        return new MySQLDeallocateStatement();
    }
}

