/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.rewrite.context;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.SQLTokenGenerators;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.builder.DefaultTokenGeneratorBuilder;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;

public final class SQLRewriteContext {
    private final SchemaMetaData schemaMetaData;
    private final SQLStatementContext sqlStatementContext;
    private final String sql;
    private final List<Object> parameters;
    private final ParameterBuilder parameterBuilder;
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private final SQLTokenGenerators sqlTokenGenerators = new SQLTokenGenerators();

    public SQLRewriteContext(SchemaMetaData schemaMetaData, SQLStatementContext sqlStatementContext, String sql, List<Object> parameters) {
        this.schemaMetaData = schemaMetaData;
        this.sqlStatementContext = sqlStatementContext;
        this.sql = sql;
        this.parameters = parameters;
        this.addSQLTokenGenerators(new DefaultTokenGeneratorBuilder().getSQLTokenGenerators());
        this.parameterBuilder = sqlStatementContext instanceof InsertStatementContext ? new GroupedParameterBuilder(((InsertStatementContext)sqlStatementContext).getGroupedParameters()) : new StandardParameterBuilder(parameters);
    }

    public void addSQLTokenGenerators(Collection<SQLTokenGenerator> sqlTokenGenerators) {
        this.sqlTokenGenerators.addAll(sqlTokenGenerators);
    }

    public void generateSQLTokens() {
        this.sqlTokens.addAll(this.sqlTokenGenerators.generateSQLTokens(this.sqlStatementContext, this.parameters, this.schemaMetaData));
    }

    @Generated
    public SchemaMetaData getSchemaMetaData() {
        return this.schemaMetaData;
    }

    @Generated
    public SQLStatementContext getSqlStatementContext() {
        return this.sqlStatementContext;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public List<Object> getParameters() {
        return this.parameters;
    }

    @Generated
    public ParameterBuilder getParameterBuilder() {
        return this.parameterBuilder;
    }

    @Generated
    public List<SQLToken> getSqlTokens() {
        return this.sqlTokens;
    }
}

