/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spi;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Properties;
import org.apache.shardingsphere.spi.NewInstanceServiceLoader;
import org.apache.shardingsphere.spi.TypeBasedSPI;

public abstract class TypeBasedSPIServiceLoader<T extends TypeBasedSPI> {
    private final Class<T> classType;

    public final T newService(String type, Properties props) {
        Collection<T> typeBasedServices = this.loadTypeBasedServices(type);
        if (typeBasedServices.isEmpty()) {
            throw new RuntimeException(String.format("Invalid `%s` SPI type `%s`.", this.classType.getName(), type));
        }
        TypeBasedSPI result = (TypeBasedSPI)typeBasedServices.iterator().next();
        result.setProperties(props);
        return (T)result;
    }

    public final T newService() {
        T result = this.loadFirstTypeBasedService();
        result.setProperties(new Properties());
        return result;
    }

    private Collection<T> loadTypeBasedServices(final String type) {
        return Collections2.filter(NewInstanceServiceLoader.newServiceInstances(this.classType), (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return type.equalsIgnoreCase(input.getType());
            }
        });
    }

    private T loadFirstTypeBasedService() {
        Collection<T> instances = NewInstanceServiceLoader.newServiceInstances(this.classType);
        if (instances.isEmpty()) {
            throw new RuntimeException(String.format("Invalid `%s` SPI, no implementation class load from SPI.", this.classType.getName()));
        }
        return (T)((TypeBasedSPI)instances.iterator().next());
    }

    @ConstructorProperties(value={"classType"})
    public TypeBasedSPIServiceLoader(Class<T> classType) {
        this.classType = classType;
    }
}

