/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.column.ColumnMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;

public final class GeneratedKeyContextEngine {
    private final SchemaMetaData schemaMetaData;

    public Optional<GeneratedKeyContext> createGenerateKeyContext(List<Object> parameters, InsertStatement insertStatement) {
        String tableName = insertStatement.getTable().getTableName().getIdentifier().getValue();
        return this.findGenerateKeyColumn(tableName).map(generateKeyColumnName -> this.containsGenerateKey(insertStatement, (String)generateKeyColumnName) ? this.findGeneratedKey(parameters, insertStatement, (String)generateKeyColumnName) : new GeneratedKeyContext((String)generateKeyColumnName, true));
    }

    private Optional<String> findGenerateKeyColumn(String tableName) {
        if (!this.schemaMetaData.containsTable(tableName)) {
            return Optional.empty();
        }
        for (Map.Entry<String, ColumnMetaData> entry : this.schemaMetaData.get(tableName).getColumns().entrySet()) {
            if (!entry.getValue().isGenerated()) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    private boolean containsGenerateKey(InsertStatement insertStatement, String generateKeyColumnName) {
        return insertStatement.getColumnNames().isEmpty() ? this.schemaMetaData.getAllColumnNames(insertStatement.getTable().getTableName().getIdentifier().getValue()).size() == insertStatement.getValueCountForPerGroup() : insertStatement.getColumnNames().contains(generateKeyColumnName);
    }

    private GeneratedKeyContext findGeneratedKey(List<Object> parameters, InsertStatement insertStatement, String generateKeyColumnName) {
        GeneratedKeyContext result = new GeneratedKeyContext(generateKeyColumnName, false);
        for (ExpressionSegment each : this.findGenerateKeyExpressions(insertStatement, generateKeyColumnName)) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                result.getGeneratedValues().add((Comparable)parameters.get(((ParameterMarkerExpressionSegment)each).getParameterMarkerIndex()));
                continue;
            }
            if (!(each instanceof LiteralExpressionSegment)) continue;
            result.getGeneratedValues().add((Comparable)((LiteralExpressionSegment)each).getLiterals());
        }
        return result;
    }

    private Collection<ExpressionSegment> findGenerateKeyExpressions(InsertStatement insertStatement, String generateKeyColumnName) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (List each : insertStatement.getAllValueExpressions()) {
            result.add((ExpressionSegment)each.get(this.findGenerateKeyIndex(insertStatement, generateKeyColumnName.toLowerCase())));
        }
        return result;
    }

    private int findGenerateKeyIndex(InsertStatement insertStatement, String generateKeyColumnName) {
        return insertStatement.getColumnNames().isEmpty() ? this.schemaMetaData.getAllColumnNames(insertStatement.getTable().getTableName().getIdentifier().getValue()).indexOf(generateKeyColumnName) : insertStatement.getColumnNames().indexOf(generateKeyColumnName);
    }

    @Generated
    public GeneratedKeyContextEngine(SchemaMetaData schemaMetaData) {
        this.schemaMetaData = schemaMetaData;
    }
}

