/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.segment.table.TablesContext;
import org.apache.shardingsphere.sql.parser.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.IndexAvailable;
import org.apache.shardingsphere.sql.parser.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateTableStatement;

public final class CreateTableStatementContext
extends CommonSQLStatementContext<CreateTableStatement>
implements TableAvailable,
IndexAvailable {
    private final TablesContext tablesContext;

    public CreateTableStatementContext(CreateTableStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getTable());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        result.add(((CreateTableStatement)this.getSqlStatement()).getTable());
        for (ColumnDefinitionSegment each : ((CreateTableStatement)this.getSqlStatement()).getColumnDefinitions()) {
            result.addAll(each.getReferencedTables());
        }
        for (ColumnDefinitionSegment each : ((CreateTableStatement)this.getSqlStatement()).getConstraintDefinitions()) {
            if (!each.getReferencedTable().isPresent()) continue;
            result.add((SimpleTableSegment)each.getReferencedTable().get());
        }
        return result;
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        return ((CreateTableStatement)this.getSqlStatement()).getIndexes();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

