/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.statement.dml;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.groupby.engine.GroupByContextEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.sql.parser.binder.segment.select.orderby.engine.OrderByContextEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.pagination.engine.PaginationContextEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.engine.ProjectionsContextEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.sql.parser.binder.segment.table.TablesContext;
import org.apache.shardingsphere.sql.parser.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.predicate.PredicateExtractor;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.util.SQLUtil;

public final class SelectStatementContext
extends CommonSQLStatementContext<SelectStatement>
implements TableAvailable,
WhereAvailable {
    private final TablesContext tablesContext;
    private final ProjectionsContext projectionsContext;
    private final GroupByContext groupByContext;
    private final OrderByContext orderByContext;
    private final PaginationContext paginationContext;
    private final boolean containsSubquery;

    public SelectStatementContext(SelectStatement sqlStatement, GroupByContext groupByContext, OrderByContext orderByContext, ProjectionsContext projectionsContext, PaginationContext paginationContext) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getSimpleTableSegments());
        this.groupByContext = groupByContext;
        this.orderByContext = orderByContext;
        this.projectionsContext = projectionsContext;
        this.paginationContext = paginationContext;
        this.containsSubquery = this.containsSubquery();
    }

    public SelectStatementContext(SchemaMetaData schemaMetaData, String sql, List<Object> parameters, SelectStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getSimpleTableSegments());
        this.groupByContext = new GroupByContextEngine().createGroupByContext(sqlStatement);
        this.orderByContext = new OrderByContextEngine().createOrderBy(sqlStatement, this.groupByContext);
        this.projectionsContext = new ProjectionsContextEngine(schemaMetaData).createProjectionsContext(sql, sqlStatement, this.groupByContext, this.orderByContext);
        this.paginationContext = new PaginationContextEngine().createPaginationContext(sqlStatement, this.projectionsContext, parameters);
        this.containsSubquery = this.containsSubquery();
    }

    private boolean containsSubquery() {
        return false;
    }

    public void setIndexes(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationProjection(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByContext.getItems());
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByContext.getItems());
    }

    private void setIndexForAggregationProjection(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationProjection each : this.projectionsContext.getAggregationProjections()) {
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (String)"Can't find index: %s, please add alias for aggregate selections", (Object[])new Object[]{each});
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
            for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derived.getColumnLabel()), (String)"Can't find index: %s", (Object[])new Object[]{derived});
                derived.setIndex(columnLabelIndexMap.get(derived.getColumnLabel()));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Optional<Integer> itemIndex;
            if (each.getSegment() instanceof IndexOrderByItemSegment) {
                each.setIndex(((IndexOrderByItemSegment)each.getSegment()).getColumnIndex());
                continue;
            }
            if (each.getSegment() instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)each.getSegment()).getColumn().getOwner().isPresent() && (itemIndex = this.projectionsContext.findProjectionIndex(((ColumnOrderByItemSegment)each.getSegment()).getText())).isPresent()) {
                each.setIndex(itemIndex.get());
                continue;
            }
            String columnLabel = this.getAlias(((TextOrderByItemSegment)each.getSegment()).getText()).orElseGet(() -> this.getOrderItemText((TextOrderByItemSegment)each.getSegment()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s", (Object[])new Object[]{each});
            if (!columnLabelIndexMap.containsKey(columnLabel)) continue;
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private Optional<String> getAlias(String name) {
        if (this.projectionsContext.isUnqualifiedShorthandProjection()) {
            return Optional.empty();
        }
        String rawName = SQLUtil.getExactlyValue((String)name);
        for (Projection each : this.projectionsContext.getProjections()) {
            if (SQLUtil.getExactlyExpression((String)rawName).equalsIgnoreCase(SQLUtil.getExactlyExpression((String)SQLUtil.getExactlyValue((String)each.getExpression())))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase(each.getAlias().orElse(null))) continue;
            return Optional.of(rawName);
        }
        return Optional.empty();
    }

    private String getOrderItemText(TextOrderByItemSegment orderByItemSegment) {
        return orderByItemSegment instanceof ColumnOrderByItemSegment ? ((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue() : ((ExpressionOrderByItemSegment)orderByItemSegment).getExpression();
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.groupByContext.getItems().isEmpty() && this.groupByContext.getItems().equals(this.orderByContext.getItems());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>(((SelectStatement)this.getSqlStatement()).getSimpleTableSegments());
        if (((SelectStatement)this.getSqlStatement()).getWhere().isPresent()) {
            result.addAll(this.getAllTablesFromWhere((WhereSegment)((SelectStatement)this.getSqlStatement()).getWhere().get()));
        }
        result.addAll(this.getAllTablesFromProjections(((SelectStatement)this.getSqlStatement()).getProjections()));
        if (((SelectStatement)this.getSqlStatement()).getGroupBy().isPresent()) {
            result.addAll(this.getAllTablesFromOrderByItems(((GroupBySegment)((SelectStatement)this.getSqlStatement()).getGroupBy().get()).getGroupByItems()));
        }
        if (((SelectStatement)this.getSqlStatement()).getOrderBy().isPresent()) {
            result.addAll(this.getAllTablesFromOrderByItems(((OrderBySegment)((SelectStatement)this.getSqlStatement()).getOrderBy().get()).getOrderByItems()));
        }
        return result;
    }

    private Collection<SimpleTableSegment> getAllTablesFromWhere(WhereSegment where) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (AndPredicate each : where.getAndPredicates()) {
            for (PredicateSegment predicate : each.getPredicates()) {
                result.addAll(new PredicateExtractor(((SelectStatement)this.getSqlStatement()).getSimpleTableSegments(), predicate).extractTables());
            }
        }
        return result;
    }

    private Collection<SimpleTableSegment> getAllTablesFromProjections(ProjectionsSegment projections) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (ProjectionSegment each : projections.getProjections()) {
            Optional<SimpleTableSegment> table = this.getTableSegment(each);
            table.ifPresent(result::add);
        }
        return result;
    }

    private Optional<SimpleTableSegment> getTableSegment(ProjectionSegment each) {
        Optional<OwnerSegment> owner = this.getTableOwner(each);
        if (owner.isPresent() && this.isTable(owner.get(), ((SelectStatement)this.getSqlStatement()).getSimpleTableSegments())) {
            return Optional.of(new SimpleTableSegment(owner.get().getStartIndex(), owner.get().getStopIndex(), owner.get().getIdentifier()));
        }
        return Optional.empty();
    }

    private Optional<OwnerSegment> getTableOwner(ProjectionSegment each) {
        if (each instanceof OwnerAvailable) {
            return ((OwnerAvailable)each).getOwner();
        }
        if (each instanceof ColumnProjectionSegment) {
            return ((ColumnProjectionSegment)each).getColumn().getOwner();
        }
        return Optional.empty();
    }

    private Collection<SimpleTableSegment> getAllTablesFromOrderByItems(Collection<OrderByItemSegment> orderByItems) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (OrderByItemSegment each : orderByItems) {
            Optional owner;
            if (!(each instanceof ColumnOrderByItemSegment) || !(owner = ((ColumnOrderByItemSegment)each).getColumn().getOwner()).isPresent() || !this.isTable((OwnerSegment)owner.get(), ((SelectStatement)this.getSqlStatement()).getSimpleTableSegments())) continue;
            Preconditions.checkState((boolean)((ColumnOrderByItemSegment)each).getColumn().getOwner().isPresent());
            OwnerSegment segment = (OwnerSegment)((ColumnOrderByItemSegment)each).getColumn().getOwner().get();
            result.add(new SimpleTableSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getIdentifier()));
        }
        return result;
    }

    private boolean isTable(OwnerSegment owner, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            if (!owner.getIdentifier().getValue().equals(each.getAlias().orElse(null))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<WhereSegment> getWhere() {
        return ((SelectStatement)this.getSqlStatement()).getWhere();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public ProjectionsContext getProjectionsContext() {
        return this.projectionsContext;
    }

    @Generated
    public GroupByContext getGroupByContext() {
        return this.groupByContext;
    }

    @Generated
    public OrderByContext getOrderByContext() {
        return this.orderByContext;
    }

    @Generated
    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    @Generated
    public boolean isContainsSubquery() {
        return this.containsSubquery;
    }

    @Override
    @Generated
    public String toString() {
        return "SelectStatementContext(super=" + super.toString() + ", tablesContext=" + this.getTablesContext() + ", projectionsContext=" + this.getProjectionsContext() + ", groupByContext=" + this.getGroupByContext() + ", orderByContext=" + this.getOrderByContext() + ", paginationContext=" + this.getPaginationContext() + ", containsSubquery=" + this.isContainsSubquery() + ")";
    }
}

