/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.binder.statement.dml;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.keygen.engine.GeneratedKeyContextEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.sql.parser.binder.segment.table.TablesContext;
import org.apache.shardingsphere.sql.parser.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;

public final class InsertStatementContext
extends CommonSQLStatementContext<InsertStatement>
implements TableAvailable {
    private final TablesContext tablesContext;
    private final List<String> columnNames;
    private final List<InsertValueContext> insertValueContexts;
    private final GeneratedKeyContext generatedKeyContext;

    public InsertStatementContext(SchemaMetaData schemaMetaData, List<Object> parameters, InsertStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getTable());
        this.columnNames = sqlStatement.useDefaultColumns() ? schemaMetaData.getAllColumnNames(sqlStatement.getTable().getTableName().getIdentifier().getValue()) : sqlStatement.getColumnNames();
        this.insertValueContexts = this.getInsertValueContexts(parameters);
        this.generatedKeyContext = new GeneratedKeyContextEngine(schemaMetaData).createGenerateKeyContext(parameters, sqlStatement).orElse(null);
    }

    private List<InsertValueContext> getInsertValueContexts(List<Object> parameters) {
        LinkedList<InsertValueContext> result = new LinkedList<InsertValueContext>();
        int parametersOffset = 0;
        for (Collection each : ((InsertStatement)this.getSqlStatement()).getAllValueExpressions()) {
            InsertValueContext insertValueContext = new InsertValueContext(each, parameters, parametersOffset);
            result.add(insertValueContext);
            parametersOffset += insertValueContext.getParametersCount();
        }
        return result;
    }

    public Iterator<String> getDescendingColumnNames() {
        return new LinkedList<String>(this.columnNames).descendingIterator();
    }

    public List<List<Object>> getGroupedParameters() {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        for (InsertValueContext each : this.insertValueContexts) {
            result.add(each.getParameters());
        }
        return result;
    }

    public Optional<GeneratedKeyContext> getGeneratedKeyContext() {
        return Optional.ofNullable(this.generatedKeyContext);
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return Collections.singletonList(((InsertStatement)this.getSqlStatement()).getTable());
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Generated
    public List<InsertValueContext> getInsertValueContexts() {
        return this.insertValueContexts;
    }

    @Override
    @Generated
    public String toString() {
        return "InsertStatementContext(super=" + super.toString() + ", tablesContext=" + this.getTablesContext() + ", columnNames=" + this.getColumnNames() + ", insertValueContexts=" + this.getInsertValueContexts() + ", generatedKeyContext=" + this.getGeneratedKeyContext() + ")";
    }
}

