/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.common.table;

import com.google.common.base.Optional;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.SchemaSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableSegment;

public final class TableExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<TableSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> tableNameNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.TABLE_NAME);
        if (!tableNameNode.isPresent()) {
            return Optional.absent();
        }
        TableSegment result = this.getTableSegment((ParserRuleContext)tableNameNode.get());
        this.setAlias((ParserRuleContext)tableNameNode.get(), result);
        return Optional.of((Object)result);
    }

    private TableSegment getTableSegment(ParserRuleContext tableNode) {
        ParserRuleContext nameNode = ExtractorUtils.getFirstChildNode(tableNode, RuleName.NAME);
        TableSegment result = new TableSegment(nameNode.getStart().getStartIndex(), nameNode.getStop().getStopIndex(), nameNode.getText());
        Optional<ParserRuleContext> ownerNode = ExtractorUtils.findFirstChildNodeNoneRecursive(tableNode, RuleName.OWNER);
        if (ownerNode.isPresent()) {
            result.setOwner(new SchemaSegment(((ParserRuleContext)ownerNode.get()).getStart().getStartIndex(), ((ParserRuleContext)ownerNode.get()).getStop().getStopIndex(), ((ParserRuleContext)ownerNode.get()).getText()));
        }
        return result;
    }

    private void setAlias(ParserRuleContext tableNameNode, TableSegment tableSegment) {
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNode(tableNameNode.getParent(), RuleName.ALIAS);
        if (aliasNode.isPresent()) {
            tableSegment.setAlias(((ParserRuleContext)aliasNode.get()).getText());
        }
    }
}

