/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select.item.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ColumnSelectItemSegment;

public final class ColumnSelectItemExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnExtractor columnExtractor = new ColumnExtractor();

    public Optional<ColumnSelectItemSegment> extract(ParserRuleContext expressionNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> columnNode = ExtractorUtils.findFirstChildNodeNoneRecursive(expressionNode, RuleName.COLUMN_NAME);
        if (!columnNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ColumnSegment> columnSegment = this.columnExtractor.extract((ParserRuleContext)columnNode.get(), parameterMarkerIndexes);
        Preconditions.checkState((boolean)columnSegment.isPresent());
        ColumnSelectItemSegment result = new ColumnSelectItemSegment(((ParserRuleContext)columnNode.get()).getText(), (ColumnSegment)columnSegment.get());
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNodeNoneRecursive(expressionNode, RuleName.ALIAS);
        if (aliasNode.isPresent()) {
            result.setAlias(((ParserRuleContext)aliasNode.get()).getText());
        }
        return Optional.of((Object)result);
    }
}

