/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.impl.dml.select.item.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.impl.common.expression.ExpressionExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.NumberLiteralRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.ParameterMarkerRowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.rownum.RowNumberValueSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.pagination.top.TopSegment;

public final class TopSelectItemExtractor
implements OptionalSQLSegmentExtractor {
    private final ExpressionExtractor expressionExtractor = new ExpressionExtractor();

    public Optional<TopSegment> extract(ParserRuleContext expressionNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional<ParserRuleContext> topNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.TOP);
        if (!topNode.isPresent()) {
            return Optional.absent();
        }
        ParserRuleContext topExprNode = ExtractorUtils.getFirstChildNode((ParserRuleContext)topNode.get(), RuleName.EXPR);
        Optional<? extends ExpressionSegment> topExpr = this.expressionExtractor.extract(topExprNode, parameterMarkerIndexes);
        Preconditions.checkState((boolean)topExpr.isPresent());
        Optional<RowNumberValueSegment> rowNumberValueSegment = this.createRowNumberValueSegment((ExpressionSegment)topExpr.get());
        Preconditions.checkState((boolean)rowNumberValueSegment.isPresent());
        ParserRuleContext rowNumberAliasNode = ExtractorUtils.getFirstChildNode(((ParserRuleContext)topNode.get()).getParent(), RuleName.ALIAS);
        return Optional.of((Object)new TopSegment(((ParserRuleContext)topNode.get()).getStart().getStartIndex(), ((ParserRuleContext)topNode.get()).getStop().getStopIndex(), ((ParserRuleContext)topNode.get()).getText(), (RowNumberValueSegment)rowNumberValueSegment.get(), rowNumberAliasNode.getText()));
    }

    private Optional<RowNumberValueSegment> createRowNumberValueSegment(ExpressionSegment topExpr) {
        if (topExpr instanceof ParameterMarkerExpressionSegment) {
            return Optional.of((Object)new ParameterMarkerRowNumberValueSegment(topExpr.getStartIndex(), topExpr.getStopIndex(), ((ParameterMarkerExpressionSegment)topExpr).getParameterMarkerIndex(), false));
        }
        if (topExpr instanceof LiteralExpressionSegment && ((LiteralExpressionSegment)topExpr).getLiterals() instanceof Number) {
            return Optional.of((Object)new NumberLiteralRowNumberValueSegment(topExpr.getStartIndex(), topExpr.getStopIndex(), ((Number)((LiteralExpressionSegment)topExpr).getLiterals()).intValue(), false));
        }
        return Optional.absent();
    }
}

