/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.visitor;

import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.shardingsphere.spi.NewInstanceServiceLoader;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitorFacade;
import org.apache.shardingsphere.sql.parser.core.visitor.VisitorRule;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.spi.SQLParserConfiguration;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatementType;

public final class ParseTreeVisitorFactory {
    public static ParseTreeVisitor newInstance(String databaseTypeName, VisitorRule visitorRule) {
        for (SQLParserConfiguration each : NewInstanceServiceLoader.newServiceInstances(SQLParserConfiguration.class)) {
            if (!each.getDatabaseTypeName().equals(databaseTypeName)) continue;
            return ParseTreeVisitorFactory.createParseTreeVisitor(each, visitorRule.getType());
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type '%s'", databaseTypeName));
    }

    private static ParseTreeVisitor createParseTreeVisitor(SQLParserConfiguration configuration, SQLStatementType type) {
        SQLVisitorFacade visitorFacade = (SQLVisitorFacade)configuration.getVisitorFacadeClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        switch (type) {
            case DML: {
                return (ParseTreeVisitor)visitorFacade.getDMLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DDL: {
                return (ParseTreeVisitor)visitorFacade.getDDLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case TCL: {
                return (ParseTreeVisitor)visitorFacade.getTCLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DCL: {
                return (ParseTreeVisitor)visitorFacade.getDCLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DAL: {
                return (ParseTreeVisitor)visitorFacade.getDALVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case RL: {
                return (ParseTreeVisitor)visitorFacade.getRLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        throw new SQLParsingException("Can not support SQL statement type: `%s`", type);
    }

    @Generated
    private ParseTreeVisitorFactory() {
    }
}

