/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.hook;

import java.util.Collection;
import org.apache.shardingsphere.spi.NewInstanceServiceLoader;
import org.apache.shardingsphere.sql.parser.hook.ParsingHook;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public final class SPIParsingHook
implements ParsingHook {
    private final Collection<ParsingHook> parsingHooks = NewInstanceServiceLoader.newServiceInstances(ParsingHook.class);

    @Override
    public void start(String sql) {
        for (ParsingHook each : this.parsingHooks) {
            each.start(sql);
        }
    }

    @Override
    public void finishSuccess(SQLStatement sqlStatement) {
        for (ParsingHook each : this.parsingHooks) {
            each.finishSuccess(sqlStatement);
        }
    }

    @Override
    public void finishFailure(Exception cause) {
        for (ParsingHook each : this.parsingHooks) {
            each.finishFailure(cause);
        }
    }

    static {
        NewInstanceServiceLoader.register(ParsingHook.class);
    }
}

