/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.oracle.visitor.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.DMLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.oracle.visitor.OracleVisitor;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.JoinSpecificationSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.JoinedTableSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.TableFactorSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.TableReferenceSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.OrPredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.value.literal.impl.BooleanLiteralValue;

public final class OracleDMLVisitor
extends OracleVisitor
implements DMLVisitor {
    @Override
    public ASTNode visitInsert(OracleStatementParser.InsertContext ctx) {
        if (null != ctx.insertSingleTable()) {
            InsertStatement result = (InsertStatement)this.visit((ParseTree)ctx.insertSingleTable().insertValuesClause());
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.insertSingleTable().insertIntoClause().tableName()));
            result.setParameterCount(this.getCurrentParameterIndex());
            return result;
        }
        return new InsertStatement();
    }

    @Override
    public ASTNode visitInsertValuesClause(OracleStatementParser.InsertValuesClauseContext ctx) {
        InsertStatement result = new InsertStatement();
        if (null != ctx.columnNames()) {
            OracleStatementParser.ColumnNamesContext columnNames = ctx.columnNames();
            CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)columnNames);
            result.setInsertColumns(new InsertColumnsSegment(columnNames.start.getStartIndex(), columnNames.stop.getStopIndex(), columnSegments.getValue()));
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.start.getStartIndex() - 1, ctx.start.getStartIndex() - 1, Collections.emptyList()));
        }
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(Collection<OracleStatementParser.AssignmentValuesContext> assignmentValuesContexts) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        for (OracleStatementParser.AssignmentValuesContext each : assignmentValuesContexts) {
            result.add((InsertValuesSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdate(OracleStatementParser.UpdateContext ctx) {
        UpdateStatement result = new UpdateStatement();
        CollectionValue tableReferences = (CollectionValue)this.visit((ParseTree)ctx.tableReferences());
        for (TableReferenceSegment each : tableReferences.getValue()) {
            result.getTables().addAll(each.getTables());
        }
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.setAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitSetAssignmentsClause(OracleStatementParser.SetAssignmentsClauseContext ctx) {
        LinkedList<AssignmentSegment> assignments = new LinkedList<AssignmentSegment>();
        for (OracleStatementParser.AssignmentContext each : ctx.assignment()) {
            assignments.add((AssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitAssignmentValues(OracleStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (OracleStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignment(OracleStatementParser.AssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.assignmentValue());
        return new AssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, value);
    }

    @Override
    public ASTNode visitAssignmentValue(OracleStatementParser.AssignmentValueContext ctx) {
        OracleStatementParser.ExprContext expr = ctx.expr();
        if (null != expr) {
            return (ASTNode)this.visit((ParseTree)expr);
        }
        return new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText());
    }

    @Override
    public ASTNode visitDelete(OracleStatementParser.DeleteContext ctx) {
        DeleteStatement result = new DeleteStatement();
        if (null != ctx.multipleTablesClause()) {
            result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.multipleTablesClause())).getValue());
        } else {
            result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.singleTableClause()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitSingleTableClause(OracleStatementParser.SingleTableClauseContext ctx) {
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitMultipleTablesClause(OracleStatementParser.MultipleTablesClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        result.combine((CollectionValue)this.visit((ParseTree)ctx.multipleTableNames()));
        CollectionValue tableReferences = (CollectionValue)this.visit((ParseTree)ctx.tableReferences());
        for (TableReferenceSegment each : tableReferences.getValue()) {
            result.getValue().addAll(each.getTables());
        }
        return result;
    }

    @Override
    public ASTNode visitMultipleTableNames(OracleStatementParser.MultipleTableNamesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.TableNameContext each : ctx.tableName()) {
            result.getValue().add((SimpleTableSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitSelect(OracleStatementParser.SelectContext ctx) {
        SelectStatement result = (SelectStatement)this.visit((ParseTree)ctx.unionClause());
        result.setParameterCount(this.getCurrentParameterIndex());
        return result;
    }

    @Override
    public ASTNode visitUnionClause(OracleStatementParser.UnionClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectClause(0));
    }

    @Override
    public ASTNode visitSelectClause(OracleStatementParser.SelectClauseContext ctx) {
        SelectStatement result = new SelectStatement();
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.projections()));
        if (null != ctx.duplicateSpecification()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx));
        }
        if (null != ctx.fromClause()) {
            CollectionValue tableReferences = (CollectionValue)this.visit((ParseTree)ctx.fromClause());
            for (TableReferenceSegment each : tableReferences.getValue()) {
                result.getTableReferences().add(each);
            }
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        return result;
    }

    private Collection<SimpleTableSegment> getTableSegments(Collection<SimpleTableSegment> tableSegments, OracleStatementParser.JoinedTableContext joinedTable) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (SimpleTableSegment tableSegment : ((CollectionValue)this.visit((ParseTree)joinedTable)).getValue()) {
            if (!this.isTable(tableSegment, tableSegments)) continue;
            result.add(tableSegment);
        }
        return result;
    }

    private boolean isTable(SimpleTableSegment owner, Collection<SimpleTableSegment> tableSegments) {
        for (SimpleTableSegment each : tableSegments) {
            if (!owner.getTableName().getIdentifier().getValue().equals(each.getAlias().orElse(null))) continue;
            return false;
        }
        return true;
    }

    private boolean isDistinct(OracleStatementParser.SelectClauseContext ctx) {
        return ((BooleanLiteralValue)this.visit((ParseTree)ctx.duplicateSpecification())).getValue();
    }

    @Override
    public ASTNode visitDuplicateSpecification(OracleStatementParser.DuplicateSpecificationContext ctx) {
        return new BooleanLiteralValue(null != ctx.DISTINCT());
    }

    @Override
    public ASTNode visitProjections(OracleStatementParser.ProjectionsContext ctx) {
        LinkedList<Object> projections = new LinkedList<Object>();
        if (null != ctx.unqualifiedShorthand()) {
            projections.add(new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex()));
        }
        for (OracleStatementParser.ProjectionContext each : ctx.projection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        result.getProjections().addAll(projections);
        return result;
    }

    @Override
    public ASTNode visitProjection(OracleStatementParser.ProjectionContext ctx) {
        AliasSegment alias;
        if (null != ctx.qualifiedShorthand()) {
            OracleStatementParser.QualifiedShorthandContext shorthand = ctx.qualifiedShorthand();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(shorthand.getStart().getStartIndex(), shorthand.getStop().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(shorthand.identifier().getText());
            result.setOwner(new OwnerSegment(shorthand.identifier().getStart().getStartIndex(), shorthand.identifier().getStop().getStopIndex(), identifier));
            return result;
        }
        AliasSegment aliasSegment = alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        if (null != ctx.columnName()) {
            ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
            ColumnProjectionSegment result = new ColumnProjectionSegment(column);
            result.setAlias(alias);
            return result;
        }
        return this.createProjection(ctx, alias);
    }

    @Override
    public ASTNode visitAlias(OracleStatementParser.AliasContext ctx) {
        if (null != ctx.identifier()) {
            return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        }
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.STRING_().getText()));
    }

    private ASTNode createProjection(OracleStatementParser.ProjectionContext ctx, AliasSegment alias) {
        ASTNode projection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText());
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), ctx.getText());
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((SubqueryExpressionSegment)projection).getSubquery());
            result.setAlias(alias);
            return result;
        }
        LiteralExpressionSegment column = (LiteralExpressionSegment)projection;
        ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(column.getStartIndex(), column.getStopIndex(), String.valueOf(column.getLiterals())) : new ExpressionProjectionSegment(column.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(column.getLiterals()));
        result.setAlias(alias);
        return result;
    }

    @Override
    public ASTNode visitFromClause(OracleStatementParser.FromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableReferences());
    }

    @Override
    public ASTNode visitTableReferences(OracleStatementParser.TableReferencesContext ctx) {
        CollectionValue result = new CollectionValue();
        for (OracleStatementParser.TableReferenceContext each : ctx.tableReference()) {
            result.getValue().add((TableReferenceSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitTableReference(OracleStatementParser.TableReferenceContext ctx) {
        TableReferenceSegment result = new TableReferenceSegment();
        if (null != ctx.tableFactor()) {
            TableFactorSegment tableFactor = (TableFactorSegment)this.visit((ParseTree)ctx.tableFactor());
            result.setTableFactor(tableFactor);
        }
        if (!ctx.joinedTable().isEmpty()) {
            for (OracleStatementParser.JoinedTableContext each : ctx.joinedTable()) {
                JoinedTableSegment joinedTableSegment = (JoinedTableSegment)this.visit((ParseTree)each);
                result.getJoinedTables().add(joinedTableSegment);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitTableFactor(OracleStatementParser.TableFactorContext ctx) {
        TableFactorSegment result = new TableFactorSegment();
        if (null != ctx.subquery()) {
            SelectStatement subquery = (SelectStatement)this.visit((ParseTree)ctx.subquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), subquery);
            SubqueryTableSegment subqueryTableSegment = new SubqueryTableSegment(subquerySegment);
            if (null != ctx.alias()) {
                subqueryTableSegment.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            result.setTable((TableSegment)subqueryTableSegment);
        }
        if (null != ctx.tableName()) {
            SimpleTableSegment table = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                table.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            result.setTable((TableSegment)table);
        }
        if (null != ctx.tableReferences()) {
            CollectionValue tableReferences = (CollectionValue)this.visit((ParseTree)ctx.tableReferences());
            result.getTableReferences().addAll(tableReferences.getValue());
        }
        return result;
    }

    @Override
    public ASTNode visitJoinedTable(OracleStatementParser.JoinedTableContext ctx) {
        JoinedTableSegment result = new JoinedTableSegment();
        TableFactorSegment tableFactor = (TableFactorSegment)this.visit((ParseTree)ctx.tableFactor());
        result.setTableFactor(tableFactor);
        if (null != ctx.joinSpecification()) {
            result.setJoinSpecification((JoinSpecificationSegment)this.visit((ParseTree)ctx.joinSpecification()));
        }
        return result;
    }

    @Override
    public ASTNode visitJoinSpecification(OracleStatementParser.JoinSpecificationContext ctx) {
        ASTNode expr;
        JoinSpecificationSegment result = new JoinSpecificationSegment();
        if (null != ctx.expr() && (expr = (ASTNode)this.visit((ParseTree)ctx.expr())) instanceof PredicateSegment) {
            PredicateSegment predicate = (PredicateSegment)expr;
            result.setPredicateSegment(predicate);
        }
        if (null != ctx.USING()) {
            LinkedList<ColumnSegment> columnSegmentList = new LinkedList<ColumnSegment>();
            for (OracleStatementParser.ColumnNameContext cname : ctx.columnNames().columnName()) {
                columnSegmentList.add((ColumnSegment)this.visit((ParseTree)cname));
            }
            result.setUsingColumns(columnSegmentList);
        }
        return result;
    }

    private SimpleTableSegment createTableSegment(OwnerSegment ownerSegment) {
        return new SimpleTableSegment(ownerSegment.getStartIndex(), ownerSegment.getStopIndex(), ownerSegment.getIdentifier());
    }

    @Override
    public ASTNode visitWhereClause(OracleStatementParser.WhereClauseContext ctx) {
        WhereSegment result = new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (segment instanceof OrPredicateSegment) {
            result.getAndPredicates().addAll(((OrPredicateSegment)segment).getAndPredicates());
        } else if (segment instanceof PredicateSegment) {
            AndPredicate andPredicate = new AndPredicate();
            andPredicate.getPredicates().add((PredicateSegment)segment);
            result.getAndPredicates().add(andPredicate);
        }
        return result;
    }

    @Override
    public ASTNode visitGroupByClause(OracleStatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (OracleStatementParser.OrderByItemContext each : ctx.orderByItem()) {
            items.add((OrderByItemSegment)this.visit((ParseTree)each));
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }
}

