/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.relation.segment.select.projection.engine;

import com.google.common.base.Optional;
import org.apache.shardingsphere.sql.parser.core.constant.AggregationType;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.ExpressionProjection;
import org.apache.shardingsphere.sql.parser.relation.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.AggregationDistinctSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.AggregationSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ColumnSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ExpressionSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ShorthandSelectItemSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.TableSegment;

public final class ProjectionEngine {
    private int aggregationAverageDerivedColumnCount;
    private int aggregationDistinctDerivedColumnCount;

    public Optional<Projection> createProjection(String sql, SelectItemSegment selectItemSegment) {
        if (selectItemSegment instanceof ShorthandSelectItemSegment) {
            return Optional.of((Object)this.createProjection((ShorthandSelectItemSegment)selectItemSegment));
        }
        if (selectItemSegment instanceof ColumnSelectItemSegment) {
            return Optional.of((Object)this.createProjection((ColumnSelectItemSegment)selectItemSegment));
        }
        if (selectItemSegment instanceof ExpressionSelectItemSegment) {
            return Optional.of((Object)this.createProjection((ExpressionSelectItemSegment)selectItemSegment));
        }
        if (selectItemSegment instanceof AggregationDistinctSelectItemSegment) {
            return Optional.of((Object)this.createProjection(sql, (AggregationDistinctSelectItemSegment)selectItemSegment));
        }
        if (selectItemSegment instanceof AggregationSelectItemSegment) {
            return Optional.of((Object)this.createProjection(sql, (AggregationSelectItemSegment)selectItemSegment));
        }
        return Optional.absent();
    }

    private ShorthandProjection createProjection(ShorthandSelectItemSegment selectItemSegment) {
        Optional owner = selectItemSegment.getOwner();
        return new ShorthandProjection(owner.isPresent() ? ((TableSegment)owner.get()).getTableName() : null);
    }

    private ColumnProjection createProjection(ColumnSelectItemSegment selectItemSegment) {
        String owner = selectItemSegment.getOwner().isPresent() ? ((TableSegment)selectItemSegment.getOwner().get()).getTableName() : null;
        return new ColumnProjection(owner, selectItemSegment.getName(), (String)selectItemSegment.getAlias().orNull());
    }

    private ExpressionProjection createProjection(ExpressionSelectItemSegment selectItemSegment) {
        return new ExpressionProjection(selectItemSegment.getText(), (String)selectItemSegment.getAlias().orNull());
    }

    private AggregationDistinctProjection createProjection(String sql, AggregationDistinctSelectItemSegment selectItemSegment) {
        String innerExpression = sql.substring(selectItemSegment.getInnerExpressionStartIndex(), selectItemSegment.getStopIndex() + 1);
        String alias = (String)selectItemSegment.getAlias().or((Object)DerivedColumn.AGGREGATION_DISTINCT_DERIVED.getDerivedColumnAlias(this.aggregationDistinctDerivedColumnCount++));
        AggregationDistinctProjection result = new AggregationDistinctProjection(selectItemSegment.getStartIndex(), selectItemSegment.getStopIndex(), selectItemSegment.getType(), innerExpression, alias, selectItemSegment.getDistinctExpression());
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDistinctDerivedProjection(result);
        }
        return result;
    }

    private AggregationProjection createProjection(String sql, AggregationSelectItemSegment selectItemSegment) {
        String innerExpression = sql.substring(selectItemSegment.getInnerExpressionStartIndex(), selectItemSegment.getStopIndex() + 1);
        AggregationProjection result = new AggregationProjection(selectItemSegment.getType(), innerExpression, (String)selectItemSegment.getAlias().orNull());
        if (AggregationType.AVG == result.getType()) {
            this.appendAverageDerivedProjection(result);
        }
        return result;
    }

    private void appendAverageDistinctDerivedProjection(AggregationDistinctProjection averageDistinctProjection) {
        String innerExpression = averageDistinctProjection.getInnerExpression();
        String distinctInnerExpression = averageDistinctProjection.getDistinctInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection countDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.COUNT, innerExpression, countAlias, distinctInnerExpression);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationDistinctProjection sumDistinctProjection = new AggregationDistinctProjection(0, 0, AggregationType.SUM, innerExpression, sumAlias, distinctInnerExpression);
        averageDistinctProjection.getDerivedAggregationProjections().add(countDistinctProjection);
        averageDistinctProjection.getDerivedAggregationProjections().add(sumDistinctProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }

    private void appendAverageDerivedProjection(AggregationProjection averageProjection) {
        String innerExpression = averageProjection.getInnerExpression();
        String countAlias = DerivedColumn.AVG_COUNT_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection countProjection = new AggregationProjection(AggregationType.COUNT, innerExpression, countAlias);
        String sumAlias = DerivedColumn.AVG_SUM_ALIAS.getDerivedColumnAlias(this.aggregationAverageDerivedColumnCount);
        AggregationProjection sumProjection = new AggregationProjection(AggregationType.SUM, innerExpression, sumAlias);
        averageProjection.getDerivedAggregationProjections().add(countProjection);
        averageProjection.getDerivedAggregationProjections().add(sumProjection);
        ++this.aggregationAverageDerivedColumnCount;
    }
}

