/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sqlserver.visitor.impl;

import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.DDLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.AlterDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.CreateDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.DataTypeSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.statement.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.sql.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sqlserver.visitor.SQLServerVisitor;

public final class SQLServerDDLVisitor
extends SQLServerVisitor
implements DDLVisitor {
    @Override
    public ASTNode visitCreateTable(SQLServerStatementParser.CreateTableContext ctx) {
        CreateTableStatement result = new CreateTableStatement((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        if (null != ctx.createDefinitionClause()) {
            CollectionValue createDefinitions = (CollectionValue)this.visit((ParseTree)ctx.createDefinitionClause());
            for (CreateDefinitionSegment each : createDefinitions.getValue()) {
                if (each instanceof ColumnDefinitionSegment) {
                    result.getColumnDefinitions().add((ColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitCreateDefinitionClause(SQLServerStatementParser.CreateDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        for (SQLServerStatementParser.CreateTableDefinitionContext each : ctx.createTableDefinitions().createTableDefinition()) {
            if (null != each.columnDefinition()) {
                result.getValue().add((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition()));
            }
            if (null == each.tableConstraint()) continue;
            result.getValue().add((ConstraintDefinitionSegment)this.visit((ParseTree)each.tableConstraint()));
        }
        return result;
    }

    @Override
    public ASTNode visitColumnDefinition(SQLServerStatementParser.ColumnDefinitionContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        boolean isPrimaryKey = this.isPrimaryKey(ctx);
        ColumnDefinitionSegment result = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, isPrimaryKey);
        for (SQLServerStatementParser.ColumnDefinitionOptionContext columnDefinitionOptionContext : ctx.columnDefinitionOption()) {
            for (SQLServerStatementParser.ColumnConstraintContext columnConstraint : columnDefinitionOptionContext.columnConstraint()) {
                if (null == columnConstraint.columnForeignKeyConstraint()) continue;
                result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)columnConstraint.columnForeignKeyConstraint().tableName()));
            }
        }
        for (SQLServerStatementParser.ColumnConstraintContext columnConstraintContext : ctx.columnConstraints().columnConstraint()) {
            if (null == columnConstraintContext.columnForeignKeyConstraint()) continue;
            result.getReferencedTables().add((SimpleTableSegment)this.visit((ParseTree)columnConstraintContext.columnForeignKeyConstraint().tableName()));
        }
        return result;
    }

    private boolean isPrimaryKey(SQLServerStatementParser.ColumnDefinitionContext ctx) {
        for (SQLServerStatementParser.ColumnDefinitionOptionContext columnDefinitionOptionContext : ctx.columnDefinitionOption()) {
            for (SQLServerStatementParser.ColumnConstraintContext columnConstraint : columnDefinitionOptionContext.columnConstraint()) {
                if (null == columnConstraint.primaryKeyConstraint() || null == columnConstraint.primaryKeyConstraint().primaryKey()) continue;
                return true;
            }
        }
        for (SQLServerStatementParser.ColumnConstraintContext columnConstraintContext : ctx.columnConstraints().columnConstraint()) {
            if (null == columnConstraintContext.primaryKeyConstraint() || null == columnConstraintContext.primaryKeyConstraint().primaryKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASTNode visitTableConstraint(SQLServerStatementParser.TableConstraintContext ctx) {
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.tablePrimaryConstraint() && null != ctx.tablePrimaryConstraint().primaryKeyUnique().primaryKey()) {
            if (null != ctx.tablePrimaryConstraint().diskTablePrimaryConstraintOption()) {
                result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tablePrimaryConstraint().diskTablePrimaryConstraintOption().columnNames())).getValue());
            }
            if (null != ctx.tablePrimaryConstraint().memoryTablePrimaryConstraintOption()) {
                result.getPrimaryKeyColumns().addAll(((CollectionValue)this.visit((ParseTree)ctx.tablePrimaryConstraint().memoryTablePrimaryConstraintOption().columnNames())).getValue());
            }
        }
        if (null != ctx.tableForeignKeyConstraint()) {
            result.setReferencedTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableForeignKeyConstraint().tableName()));
        }
        return result;
    }

    @Override
    public ASTNode visitAlterTable(SQLServerStatementParser.AlterTableContext ctx) {
        AlterTableStatement result = new AlterTableStatement((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        for (SQLServerStatementParser.AlterDefinitionClauseContext alterDefinitionClauseContext : ctx.alterDefinitionClause()) {
            for (AlterDefinitionSegment each : ((CollectionValue)this.visit((ParseTree)alterDefinitionClauseContext)).getValue()) {
                if (each instanceof AddColumnDefinitionSegment) {
                    result.getAddColumnDefinitions().add((AddColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof ModifyColumnDefinitionSegment) {
                    result.getModifyColumnDefinitions().add((ModifyColumnDefinitionSegment)each);
                    continue;
                }
                if (each instanceof DropColumnDefinitionSegment) {
                    result.getDropColumnDefinitions().add((DropColumnDefinitionSegment)each);
                    continue;
                }
                if (!(each instanceof ConstraintDefinitionSegment)) continue;
                result.getAddConstraintDefinitions().add((ConstraintDefinitionSegment)each);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitAlterDefinitionClause(SQLServerStatementParser.AlterDefinitionClauseContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.addColumnSpecification()) {
            result.getValue().addAll(((CollectionValue)this.visit((ParseTree)ctx.addColumnSpecification())).getValue());
        }
        if (null != ctx.modifyColumnSpecification()) {
            result.getValue().add((ModifyColumnDefinitionSegment)this.visit((ParseTree)ctx.modifyColumnSpecification()));
        }
        if (null != ctx.alterDrop() && null != ctx.alterDrop().dropColumnSpecification()) {
            result.getValue().add((DropColumnDefinitionSegment)this.visit((ParseTree)ctx.alterDrop().dropColumnSpecification()));
        }
        return result;
    }

    @Override
    public ASTNode visitAddColumnSpecification(SQLServerStatementParser.AddColumnSpecificationContext ctx) {
        CollectionValue result = new CollectionValue();
        if (null != ctx.alterColumnAddOptions()) {
            for (SQLServerStatementParser.AlterColumnAddOptionContext each : ctx.alterColumnAddOptions().alterColumnAddOption()) {
                if (null == each.columnDefinition()) continue;
                AddColumnDefinitionSegment addColumnDefinition = new AddColumnDefinitionSegment(each.columnDefinition().getStart().getStartIndex(), each.columnDefinition().getStop().getStopIndex(), Collections.singletonList((ColumnDefinitionSegment)this.visit((ParseTree)each.columnDefinition())));
                result.getValue().add(addColumnDefinition);
            }
        }
        return result;
    }

    @Override
    public ASTNode visitModifyColumnSpecification(SQLServerStatementParser.ModifyColumnSpecificationContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visit((ParseTree)ctx.alterColumnOperation().columnName());
        DataTypeSegment dataType = (DataTypeSegment)this.visit((ParseTree)ctx.dataType());
        ColumnDefinitionSegment columnDefinition = new ColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), column, dataType, false);
        return new ModifyColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnDefinition);
    }

    @Override
    public ASTNode visitDropColumnSpecification(SQLServerStatementParser.DropColumnSpecificationContext ctx) {
        LinkedList<ColumnSegment> columns = new LinkedList<ColumnSegment>();
        for (SQLServerStatementParser.ColumnNameContext each : ctx.columnName()) {
            columns.add((ColumnSegment)this.visit((ParseTree)each));
        }
        return new DropColumnDefinitionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columns);
    }

    @Override
    public ASTNode visitDropTable(SQLServerStatementParser.DropTableContext ctx) {
        DropTableStatement result = new DropTableStatement();
        result.getTables().addAll(((CollectionValue)this.visit((ParseTree)ctx.tableNames())).getValue());
        return result;
    }

    @Override
    public ASTNode visitTruncateTable(SQLServerStatementParser.TruncateTableContext ctx) {
        TruncateStatement result = new TruncateStatement();
        result.getTables().add((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitCreateIndex(SQLServerStatementParser.CreateIndexContext ctx) {
        CreateIndexStatement result = new CreateIndexStatement();
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        return result;
    }

    @Override
    public ASTNode visitAlterIndex(SQLServerStatementParser.AlterIndexContext ctx) {
        AlterIndexStatement result = new AlterIndexStatement();
        if (null != ctx.indexName()) {
            result.setIndex((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        }
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }

    @Override
    public ASTNode visitDropIndex(SQLServerStatementParser.DropIndexContext ctx) {
        DropIndexStatement result = new DropIndexStatement();
        result.getIndexes().add((IndexSegment)this.visit((ParseTree)ctx.indexName()));
        result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.tableName()));
        return result;
    }
}

