/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SubqueryExtractUtil;

public final class WhereExtractUtil {
    public static Collection<WhereSegment> getJoinWhereSegments(SelectStatement selectStatement) {
        if (null == selectStatement.getFrom()) {
            return Collections.emptyList();
        }
        return WhereExtractUtil.getJoinWhereSegments(selectStatement.getFrom());
    }

    private static Collection<WhereSegment> getJoinWhereSegments(TableSegment tableSegment) {
        if (!(tableSegment instanceof JoinTableSegment) || null == ((JoinTableSegment)tableSegment).getCondition()) {
            return Collections.emptyList();
        }
        JoinTableSegment joinTableSegment = (JoinTableSegment)tableSegment;
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        result.add(WhereExtractUtil.generateWhereSegment(joinTableSegment));
        result.addAll(WhereExtractUtil.getJoinWhereSegments(joinTableSegment.getLeft()));
        result.addAll(WhereExtractUtil.getJoinWhereSegments(joinTableSegment.getRight()));
        return result;
    }

    private static WhereSegment generateWhereSegment(JoinTableSegment joinTableSegment) {
        ExpressionSegment expressionSegment = joinTableSegment.getCondition();
        return new WhereSegment(expressionSegment.getStartIndex(), expressionSegment.getStopIndex(), expressionSegment);
    }

    public static Collection<WhereSegment> getSubqueryWhereSegments(SelectStatement selectStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        for (SubquerySegment each : SubqueryExtractUtil.getSubquerySegments(selectStatement)) {
            each.getSelect().getWhere().ifPresent(result::add);
        }
        return result;
    }

    @Generated
    private WhereExtractUtil() {
    }
}

