/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike$class;
import org.apache.spark.sql.catalyst.expressions.ArrayIntersect$;
import org.apache.spark.sql.catalyst.expressions.ArraySetLike$class;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast$class;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression$class;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.util.collection.OpenHashSet;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n  _FUNC_(array1, array2) - Returns an array of the elements in the intersection of array1 and\n    array2, without duplicates.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(1, 3, 5));\n       [1,3]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u0001>\u0011a\"\u0011:sCfLe\u000e^3sg\u0016\u001cGO\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003F\f\u001bAA\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!aD!se\u0006L()\u001b8befd\u0015n[3\u0011\u0005EA\u0012BA\r\u0003\u0005q\u0019u.\u001c9mKb$\u0016\u0010]3NKJ<\u0017N\\4FqB\u0014Xm]:j_:\u0004\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u001a!C\u0001K\u0005!A.\u001a4u+\u00051\u0003CA\t(\u0013\tA#A\u0001\u0006FqB\u0014Xm]:j_:D\u0001B\u000b\u0001\u0003\u0012\u0003\u0006IAJ\u0001\u0006Y\u00164G\u000f\t\u0005\tY\u0001\u0011)\u001a!C\u0001K\u0005)!/[4ii\"Aa\u0006\u0001B\tB\u0003%a%\u0001\u0004sS\u001eDG\u000f\t\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007I\u001aD\u0007\u0005\u0002\u0012\u0001!)Ae\fa\u0001M!)Af\fa\u0001M!)a\u0007\u0001C!o\u0005AA-\u0019;b)f\u0004X-F\u00019!\tID(D\u0001;\u0015\tYd!A\u0003usB,7/\u0003\u0002>u\tAA)\u0019;b)f\u0004X\r\u0003\u0005@\u0001!\u0015\r\u0011\"\u0001A\u00035)g/\u00197J]R,'o]3diV\t\u0011\tE\u0003\u001c\u0005\u0012#E)\u0003\u0002D9\tIa)\u001e8di&|gN\r\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u0012\tA!\u001e;jY&\u0011\u0011J\u0012\u0002\n\u0003J\u0014\u0018-\u001f#bi\u0006D\u0001b\u0013\u0001\t\u0002\u0003\u0006K!Q\u0001\u000fKZ\fG.\u00138uKJ\u001cXm\u0019;!Q\tQU\n\u0005\u0002\u001c\u001d&\u0011q\n\b\u0002\niJ\fgn]5f]RDQ!\u0015\u0001\u0005BI\u000bAB\\;mYN\u000bg-Z#wC2$2a\u0015,Y!\tYB+\u0003\u0002V9\t\u0019\u0011I\\=\t\u000b]\u0003\u0006\u0019A*\u0002\r%t\u0007/\u001e;2\u0011\u0015I\u0006\u000b1\u0001T\u0003\u0019Ig\u000e];ue!)1\f\u0001C!9\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0004;\u000eD\u0007C\u00010b\u001b\u0005y&B\u00011\u0003\u0003\u001d\u0019w\u000eZ3hK:L!AY0\u0003\u0011\u0015C\bO]\"pI\u0016DQ\u0001\u001a.A\u0002\u0015\f1a\u0019;y!\tqf-\u0003\u0002h?\nq1i\u001c3fO\u0016t7i\u001c8uKb$\b\"B5[\u0001\u0004i\u0016AA3w\u0011\u0015Y\u0007\u0001\"\u0011m\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002[B\u0011a.\u001d\b\u00037=L!\u0001\u001d\u000f\u0002\rA\u0013X\rZ3g\u0013\t\u00118O\u0001\u0004TiJLgn\u001a\u0006\u0003arAq!\u001e\u0001\u0002\u0002\u0013\u0005a/\u0001\u0003d_BLHc\u0001\u001axq\"9A\u0005\u001eI\u0001\u0002\u00041\u0003b\u0002\u0017u!\u0003\u0005\rA\n\u0005\bu\u0002\t\n\u0011\"\u0001|\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012\u0001 \u0016\u0003Mu\\\u0013A \t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00049\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0011\u0011\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\u0002CA\b\u0001E\u0005I\u0011A>\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u00111\u0003\u0001\u0002\u0002\u0013\u0005\u0013QC\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\u0005Y\u0006twM\u0003\u0002\u0002\"\u0005!!.\u0019<b\u0013\r\u0011\u00181\u0004\u0005\n\u0003O\u0001\u0011\u0011!C\u0001\u0003S\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000b\u0011\u0007m\ti#C\u0002\u00020q\u00111!\u00138u\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007M\u000b9\u0004\u0003\u0006\u0002:\u0005E\u0012\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u0011%\ti\u0004AA\u0001\n\u0003\ny$A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0005E\u0003\u0002D\u0005%3+\u0004\u0002\u0002F)\u0019\u0011q\t\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0005\u0015#\u0001C%uKJ\fGo\u001c:\t\u0013\u0005=\u0003!!A\u0005\u0002\u0005E\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005M\u0013\u0011\f\t\u00047\u0005U\u0013bAA,9\t9!i\\8mK\u0006t\u0007\"CA\u001d\u0003\u001b\n\t\u00111\u0001T\u0011%\ti\u0006AA\u0001\n\u0003\ny&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003'\n\t\u0007C\u0005\u0002:\u0005m\u0013\u0011!a\u0001'\"z\u0001!!\u001a\u0002l\u00055\u0014\u0011OA:\u0003o\nI\bE\u0002\u0012\u0003OJ1!!\u001b\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u001c\u0002\u0003\u0007Q\u0001\u0005I0G+:\u001bu\fK1se\u0006L\u0018\u0007\f\u0011beJ\f\u0017PM\u0015![\u0001\u0012V\r^;s]N\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I8gAQDW\rI3mK6,g\u000e^:!S:\u0004C\u000f[3!S:$XM]:fGRLwN\u001c\u0011pM\u0002\n'O]1zc\u0001\ng\u000e\u001a\u0006!A\u0001\u0002\u0013M\u001d:bsJb\u0003e^5uQ>,H\u000f\t3va2L7-\u0019;fg:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011QO\u0001V\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g%b\u0003%\u0019:sCfD\u0013\u0007\f\u00114Y\u0001*\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7Fb3'\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111P\u0001\u0006e9\"d\u0006M\u0004\n\u0003\u007f\u0012\u0011\u0011!E\u0001\u0003\u0003\u000ba\"\u0011:sCfLe\u000e^3sg\u0016\u001cG\u000fE\u0002\u0012\u0003\u00073\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QQ\n\u0006\u0003\u0007\u000b9\t\t\t\b\u0003\u0013\u000byI\n\u00143\u001b\t\tYIC\u0002\u0002\u000er\tqA];oi&lW-\u0003\u0003\u0002\u0012\u0006-%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9\u0001'a!\u0005\u0002\u0005UECAAA\u0011)\tI*a!\u0002\u0002\u0013\u0015\u00131T\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0003\u0005\u000b\u0003?\u000b\u0019)!A\u0005\u0002\u0006\u0005\u0016!B1qa2LH#\u0002\u001a\u0002$\u0006\u0015\u0006B\u0002\u0013\u0002\u001e\u0002\u0007a\u0005\u0003\u0004-\u0003;\u0003\rA\n\u0005\u000b\u0003S\u000b\u0019)!A\u0005\u0002\u0006-\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003[\u000bI\fE\u0003\u001c\u0003_\u000b\u0019,C\u0002\u00022r\u0011aa\u00149uS>t\u0007#B\u000e\u00026\u001a2\u0013bAA\\9\t1A+\u001e9mKJB\u0011\"a/\u0002(\u0006\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002@\u0006\r\u0015\u0011!C\u0005\u0003\u0003\f1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0019\t\u0005\u00033\t)-\u0003\u0003\u0002H\u0006m!AB(cU\u0016\u001cG\u000f")
public class ArrayIntersect
extends BinaryExpression
implements ArrayBinaryLike,
ComplexTypeMergingExpression,
Serializable {
    private final Expression left;
    private final Expression right;
    private transient Function2<ArrayData, ArrayData, ArrayData> evalIntersect;
    private final transient Seq<DataType> inputTypesForMerging;
    private final transient boolean canUseSpecializedHashSet;
    private final transient Ordering<Object> ordering;
    private final Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
    private final transient String hsPostFix;
    private final transient String hsTypeName;
    private final transient String hsValueCast;
    private final transient String nullValueHolder;
    private final transient DataType elementType;
    private volatile transient int bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayIntersect arrayIntersect) {
        return ArrayIntersect$.MODULE$.unapply(arrayIntersect);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayIntersect> tupled() {
        return ArrayIntersect$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayIntersect>> curried() {
        return ArrayIntersect$.MODULE$.curried();
    }

    private Function2 evalIntersect$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.evalIntersect = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArrayIntersect $outer;

                    public final ArrayData apply(ArrayData array1, ArrayData array2) {
                        GenericArrayData genericArrayData;
                        if (array1.numElements() != 0 && array2.numElements() != 0) {
                            int i;
                            OpenHashSet hs = new OpenHashSet(ClassTag$.MODULE$.Any());
                            OpenHashSet hsResult = new OpenHashSet(ClassTag$.MODULE$.Any());
                            boolean foundNullElement = false;
                            for (i = 0; i < array2.numElements(); ++i) {
                                if (array2.isNullAt(i)) {
                                    foundNullElement = true;
                                    continue;
                                }
                                Object elem = array2.get(i, this.$outer.elementType());
                                hs.add(elem);
                            }
                            ArrayBuffer arrayBuffer = new ArrayBuffer();
                            for (i = 0; i < array1.numElements(); ++i) {
                                if (array1.isNullAt(i)) {
                                    if (!foundNullElement) continue;
                                    arrayBuffer.$plus$eq(null);
                                    foundNullElement = false;
                                    continue;
                                }
                                Object elem = array1.get(i, this.$outer.elementType());
                                if (!hs.contains(elem) || hsResult.contains(elem)) continue;
                                arrayBuffer.$plus$eq(elem);
                                hsResult.add(elem);
                            }
                            genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer);
                        } else {
                            genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                        }
                        return genericArrayData;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                } : new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ArrayIntersect $outer;

                    public final ArrayData apply(ArrayData array1, ArrayData array2) {
                        GenericArrayData genericArrayData;
                        if (array1.numElements() != 0 && array2.numElements() != 0) {
                            ArrayBuffer arrayBuffer = new ArrayBuffer();
                            boolean alreadySeenNull = false;
                            for (int i = 0; i < array1.numElements(); ++i) {
                                boolean found = false;
                                Object elem1 = array1.get(i, this.$outer.elementType());
                                if (array1.isNullAt(i)) {
                                    if (!alreadySeenNull) {
                                        for (int j = 0; !found && j < array2.numElements(); ++j) {
                                            found = array2.isNullAt(j);
                                        }
                                        alreadySeenNull = true;
                                    }
                                } else {
                                    for (int j = 0; !found && j < array2.numElements(); ++j) {
                                        if (array2.isNullAt(j)) continue;
                                        Object elem2 = array2.get(j, this.$outer.elementType());
                                        if (!this.$outer.ordering().equiv(elem1, elem2)) continue;
                                        boolean foundArrayBuffer = false;
                                        for (int k = 0; !foundArrayBuffer && k < arrayBuffer.size(); ++k) {
                                            Object va = arrayBuffer.apply(k);
                                            foundArrayBuffer = va != null && this.$outer.ordering().equiv(va, elem1);
                                        }
                                        found = !foundArrayBuffer;
                                    }
                                }
                                Object object = found ? arrayBuffer.$plus$eq(elem1) : BoxedUnit.UNIT;
                            }
                            genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer);
                        } else {
                            genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                        }
                        return genericArrayData;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
                this.bitmap$trans$0 |= 1;
            }
            return this.evalIntersect;
        }
    }

    private Seq inputTypesForMerging$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression$class.inputTypesForMerging(this);
                this.bitmap$trans$0 |= 2;
            }
            return this.inputTypesForMerging;
        }
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (this.bitmap$trans$0 & 2) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression$class.dataTypeCheck(this);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$ArrayBinaryLike$$super$checkInputDataTypes() {
        return BinaryArrayExpressionWithImplicitCast$class.checkInputDataTypes(this);
    }

    @Override
    public DataType dt() {
        return ArrayBinaryLike$class.dt(this);
    }

    @Override
    public DataType et() {
        return ArrayBinaryLike$class.et(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayBinaryLike$class.checkInputDataTypes(this);
    }

    private boolean canUseSpecializedHashSet$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.canUseSpecializedHashSet = ArraySetLike$class.canUseSpecializedHashSet(this);
                this.bitmap$trans$0 |= 4;
            }
            return this.canUseSpecializedHashSet;
        }
    }

    @Override
    public boolean canUseSpecializedHashSet() {
        return (this.bitmap$trans$0 & 4) == 0 ? this.canUseSpecializedHashSet$lzycompute() : this.canUseSpecializedHashSet;
    }

    private Ordering ordering$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.ordering = ArraySetLike$class.ordering(this);
                this.bitmap$trans$0 |= 8;
            }
            return this.ordering;
        }
    }

    @Override
    public Ordering<Object> ordering() {
        return (this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71 = ArraySetLike$class.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71(this);
                this.bitmap$0 = true;
            }
            return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71;
        }
    }

    @Override
    public /* synthetic */ Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71() {
        return this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71 : this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$71$lzycompute();
    }

    private String hsPostFix$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.hsPostFix = ArraySetLike$class.hsPostFix(this);
                this.bitmap$trans$0 |= 0x10;
            }
            return this.hsPostFix;
        }
    }

    @Override
    public String hsPostFix() {
        return (this.bitmap$trans$0 & 0x10) == 0 ? this.hsPostFix$lzycompute() : this.hsPostFix;
    }

    private String hsTypeName$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.hsTypeName = ArraySetLike$class.hsTypeName(this);
                this.bitmap$trans$0 |= 0x20;
            }
            return this.hsTypeName;
        }
    }

    @Override
    public String hsTypeName() {
        return (this.bitmap$trans$0 & 0x20) == 0 ? this.hsTypeName$lzycompute() : this.hsTypeName;
    }

    private String hsValueCast$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.hsValueCast = ArraySetLike$class.hsValueCast(this);
                this.bitmap$trans$0 |= 0x40;
            }
            return this.hsValueCast;
        }
    }

    @Override
    public String hsValueCast() {
        return (this.bitmap$trans$0 & 0x40) == 0 ? this.hsValueCast$lzycompute() : this.hsValueCast;
    }

    private String nullValueHolder$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.nullValueHolder = ArraySetLike$class.nullValueHolder(this);
                this.bitmap$trans$0 |= 0x80;
            }
            return this.nullValueHolder;
        }
    }

    @Override
    public String nullValueHolder() {
        return (this.bitmap$trans$0 & 0x80) == 0 ? this.nullValueHolder$lzycompute() : this.nullValueHolder;
    }

    @Override
    public String genGetValue(String array, String i) {
        return ArraySetLike$class.genGetValue(this, array, i);
    }

    @Override
    public String withResultArrayNullCheck(String body, String value2, String nullElementIndex) {
        return ArraySetLike$class.withResultArrayNullCheck(this, body, value2, nullElementIndex);
    }

    @Override
    public String buildResultArray(String builder, String value2, String size, String nullElementIndex) {
        return ArraySetLike$class.buildResultArray(this, builder, value2, size, nullElementIndex);
    }

    private DataType elementType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast$class.elementType(this);
                this.bitmap$trans$0 |= 0x100;
            }
            return this.elementType;
        }
    }

    @Override
    public DataType elementType() {
        return (this.bitmap$trans$0 & 0x100) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast$class.inputTypes(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        this.dataTypeCheck();
        return new ArrayType(this.elementType(), ((ArrayType)this.left().dataType()).containsNull() && ((ArrayType)this.right().dataType()).containsNull());
    }

    public Function2<ArrayData, ArrayData, ArrayData> evalIntersect() {
        return (this.bitmap$trans$0 & 1) == 0 ? this.evalIntersect$lzycompute() : this.evalIntersect;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        ArrayData array1 = (ArrayData)input1;
        ArrayData array2 = (ArrayData)input2;
        return this.evalIntersect().apply((Object)array1, (Object)array2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String i = ctx.freshName("i");
        String value2 = ctx.freshName("value");
        String size = ctx.freshName("size");
        if (this.canUseSpecializedHashSet()) {
            String jt = CodeGenerator$.MODULE$.javaType(this.elementType());
            String ptName = CodeGenerator$.MODULE$.primitiveTypeName(jt);
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev, i, value2, size, jt, ptName){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ArrayIntersect $outer;
                private final CodegenContext ctx$20;
                private final ExprCode ev$17;
                private final String i$4;
                private final String value$6;
                private final String size$3;
                private final String jt$3;
                private final String ptName$3;

                public final String apply(String array1, String array2) {
                    String foundNullElement = this.ctx$20.freshName("foundNullElement");
                    String nullElementIndex = this.ctx$20.freshName("nullElementIndex");
                    String builder = this.ctx$20.freshName("builder");
                    String openHashSet = OpenHashSet.class.getName();
                    String classTag = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scala.reflect.ClassTag$.MODULE$.", "()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.hsTypeName()}));
                    String hashSet = this.ctx$20.freshName("hashSet");
                    String hashSetResult = this.ctx$20.freshName("hashSetResult");
                    String arrayBuilder = ArrayBuilder.class.getName();
                    String arrayBuilderClass = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$of", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arrayBuilder, this.ptName$3}));
                    String writeArray2ToHashSet = this.withArray2NullCheck$1(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = ", ";\n             |", ".add", "(", "", ");\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jt$3, this.value$6, this.$outer.genGetValue(array2, this.i$4), hashSet, this.$outer.hsPostFix(), this.$outer.hsValueCast(), this.value$6})))).stripMargin(), foundNullElement, array2);
                    String processArray1 = this.withArray1NullAssignment$1(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " ", " = ", ";\n             |if (", ".contains(", "", ") &&\n             |    !", ".contains(", "", ")) {\n             |  if (++", " > ", ") {\n             |    break;\n             |  }\n             |  ", ".add", "(", "", ");\n             |  ", ".$plus$eq(", ");\n             |}\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jt$3, this.value$6, this.$outer.genGetValue(array1, this.i$4), hashSet, this.$outer.hsValueCast(), this.value$6, hashSetResult, this.$outer.hsValueCast(), this.value$6, this.size$3, BoxesRunTime.boxToInteger((int)ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH), hashSetResult, this.$outer.hsPostFix(), this.$outer.hsValueCast(), this.value$6, builder, this.value$6})))).stripMargin(), foundNullElement, nullElementIndex, builder, array1);
                    String declareNullTrackVariables = ((ArrayType)this.$outer.dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |boolean ", " = false;\n             |int ", " = -1;\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{foundNullElement, nullElementIndex})))).stripMargin() : "";
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", " ", " = new ", "", "(", ");\n           |", " ", " = new ", "", "(", ");\n           |", "\n           |for (int ", " = 0; ", " < ", ".numElements(); ", "++) {\n           |  ", "\n           |}\n           |", " ", " = new ", "();\n           |int ", " = 0;\n           |for (int ", " = 0; ", " < ", ".numElements(); ", "++) {\n           |  ", "\n           |}\n           |", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{openHashSet, hashSet, openHashSet, this.$outer.hsPostFix(), classTag, openHashSet, hashSetResult, openHashSet, this.$outer.hsPostFix(), classTag, declareNullTrackVariables, this.i$4, this.i$4, array2, this.i$4, writeArray2ToHashSet, arrayBuilderClass, builder, arrayBuilderClass, this.size$3, this.i$4, this.i$4, array1, this.i$4, processArray1, this.$outer.buildResultArray(builder, ExprValue$.MODULE$.exprValueToString(this.ev$17.value()), this.size$3, nullElementIndex)})))).stripMargin();
                }

                private final String withArray2NullCheck$1(String body, String foundNullElement$5, String array2$1) {
                    return ((ArrayType)this.$outer.right().dataType()).containsNull() ? (((ArrayType)this.$outer.left().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |if (", ".isNullAt(", ")) {\n                 |  ", " = true;\n                 |} else {\n                 |  ", "\n                 |}\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array2$1, this.i$4, foundNullElement$5, body})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |if (!", ".isNullAt(", ")) {\n                 |  ", "\n                 |}\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array2$1, this.i$4, body})))).stripMargin()) : body;
                }

                private final String withArray1NullAssignment$1(String body, String foundNullElement$5, String nullElementIndex$3, String builder$3, String array1$1) {
                    return ((ArrayType)this.$outer.left().dataType()).containsNull() ? (((ArrayType)this.$outer.right().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |if (", ".isNullAt(", ")) {\n                 |  if (", ") {\n                 |    ", " = ", ";\n                 |    ", " = false;\n                 |    ", "++;\n                 |    ", ".$plus$eq(", ");\n                 |  }\n                 |} else {\n                 |  ", "\n                 |}\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array1$1, this.i$4, foundNullElement$5, nullElementIndex$3, this.size$3, foundNullElement$5, this.size$3, builder$3, this.$outer.nullValueHolder(), body})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |if (!", ".isNullAt(", ")) {\n                 |  ", "\n                 |}\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{array1$1, this.i$4, body})))).stripMargin()) : body;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.ctx$20 = ctx$20;
                    this.ev$17 = ev$17;
                    this.i$4 = i$4;
                    this.value$6 = value$6;
                    this.size$3 = size$3;
                    this.jt$3 = jt$3;
                    this.ptName$3 = ptName$3;
                }
            });
        } else {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ArrayIntersect $outer;
                private final CodegenContext ctx$20;
                private final ExprCode ev$17;

                public final String apply(String array1, String array2) {
                    String expr = this.ctx$20.addReferenceObj("arrayIntersectExpr", this.$outer, this.ctx$20.addReferenceObj$default$3());
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = (ArrayData)", ".nullSafeEval(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev$17.value(), expr, array1, array2}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.ctx$20 = ctx$20;
                    this.ev$17 = ev$17;
                }
            });
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "array_intersect";
    }

    public ArrayIntersect copy(Expression left, Expression right) {
        return new ArrayIntersect(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayIntersect";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayIntersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayIntersect)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayIntersect arrayIntersect = (ArrayIntersect)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayIntersect.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayIntersect.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayIntersect.canEqual(this)) return false;
        return true;
    }

    public ArrayIntersect(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes$class.$init$(this);
        BinaryArrayExpressionWithImplicitCast$class.$init$(this);
        ArraySetLike$class.$init$(this);
        ArrayBinaryLike$class.$init$(this);
        ComplexTypeMergingExpression$class.$init$(this);
    }
}

