/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Comparator;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike$NullOrder$;
import org.apache.spark.sql.catalyst.expressions.ArraySortLike$class;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array) - Sorts the input array in ascending order. The elements of the input array must\n      be orderable. Null elements will be placed at the end of the returned array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001>\u0011\u0011\"\u0011:sCf\u001cvN\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!E\u000b\n\u0005Y\u0011!!D!se\u0006L8k\u001c:u\u0019&\\W\r\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0004Qe>$Wo\u0019;\u0011\u0005aq\u0012BA\u0010\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013!B2iS2$W#A\u0012\u0011\u0005E!\u0013BA\u0013\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u000511\r[5mI\u0002BQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtDCA\u0016-!\t\t\u0002\u0001C\u0003\"Q\u0001\u00071\u0005C\u0003/\u0001\u0011\u0005s&\u0001\u0005eCR\fG+\u001f9f+\u0005\u0001\u0004CA\u00195\u001b\u0005\u0011$BA\u001a\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t)$G\u0001\u0005ECR\fG+\u001f9f\u0011\u00159\u0004\u0001\"\u00119\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u000f\u0003\u0019a$o\\8u}%\t!$\u0003\u0002B3\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003f\u0001\"!\r$\n\u0005\u001d\u0013$\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015I\u0005\u0001\"\u0011#\u0003=\t'O]1z\u000bb\u0004(/Z:tS>t\u0007\"B&\u0001\t\u0003b\u0015!\u00038vY2|%\u000fZ3s+\u0005i\u0005C\u0001(^\u001d\ty5L\u0004\u0002Q5:\u0011\u0011+\u0017\b\u0003%bs!aU,\u000f\u0005Q3fB\u0001\u001fV\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!\u0001\u0018\u0002\u0002\u001b\u0005\u0013(/Y=T_J$H*[6f\u0013\tqvLA\u0005Ok2dwJ\u001d3fe*\u0011AL\u0001\u0005\u0006C\u0002!\tEY\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011a\rB\u0001\tC:\fG._:jg&\u0011\u0001.\u001a\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\")!\u000e\u0001C!W\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011An\u001c\t\u000315L!A\\\r\u0003\u0007\u0005s\u0017\u0010C\u0003qS\u0002\u0007A.A\u0003beJ\f\u0017\u0010C\u0003s\u0001\u0011\u00053/A\u0005e_\u001e+gnQ8eKR\u0019AO_@\u0011\u0005UDX\"\u0001<\u000b\u0005]\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003sZ\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006wF\u0004\r\u0001`\u0001\u0004GRD\bCA;~\u0013\tqhO\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\u0005\u0011\u000f1\u0001u\u0003\t)g\u000fC\u0004\u0002\u0006\u0001!\t%a\u0002\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002\nA!\u00111BA\t\u001d\rA\u0012QB\u0005\u0004\u0003\u001fI\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!AB*ue&twMC\u0002\u0002\u0010eA\u0011\"!\u0007\u0001\u0003\u0003%\t!a\u0007\u0002\t\r|\u0007/\u001f\u000b\u0004W\u0005u\u0001\u0002C\u0011\u0002\u0018A\u0005\t\u0019A\u0012\t\u0013\u0005\u0005\u0002!%A\u0005\u0002\u0005\r\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003KQ3aIA\u0014W\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001a3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0012Q\u0006\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u001e\u0001\u0005\u0005I\u0011IA\u001f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\b\t\u0005\u0003\u0003\nY%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0013\u0001\u00026bm\u0006LA!a\u0005\u0002D!I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0011\u0011K\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003'\u00022\u0001GA+\u0013\r\t9&\u0007\u0002\u0004\u0013:$\b\"CA.\u0001\u0005\u0005I\u0011AA/\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001\\A0\u0011)\t\t'!\u0017\u0002\u0002\u0003\u0007\u00111K\u0001\u0004q\u0012\n\u0004\"CA3\u0001\u0005\u0005I\u0011IA4\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA5!\u0015\tY'!\u001dm\u001b\t\tiGC\u0002\u0002pe\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019(!\u001c\u0003\u0011%#XM]1u_JD\u0011\"a\u001e\u0001\u0003\u0003%\t!!\u001f\u0002\u0011\r\fg.R9vC2$B!a\u001f\u0002\u0002B\u0019\u0001$! \n\u0007\u0005}\u0014DA\u0004C_>dW-\u00198\t\u0013\u0005\u0005\u0014QOA\u0001\u0002\u0004a\u0007\"CAC\u0001\u0005\u0005I\u0011IAD\u0003\u0019)\u0017/^1mgR!\u00111PAE\u0011%\t\t'a!\u0002\u0002\u0003\u0007A\u000eK\b\u0001\u0003\u001b\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ!\r\t\u0012qR\u0005\u0004\u0003#\u0013!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003/\u000b\u00111\u000f\u0006!A\u0001\u0002sLR+O\u0007~C\u0013M\u001d:bs&\u0002S\u0006I*peR\u001c\b\u0005\u001e5fA%t\u0007/\u001e;!CJ\u0014\u0018-\u001f\u0011j]\u0002\n7oY3oI&tw\rI8sI\u0016\u0014h\u0006\t+iK\u0002*G.Z7f]R\u001c\be\u001c4!i\",\u0007%\u001b8qkR\u0004\u0013M\u001d:bs\u0002jWo\u001d;\u000bA\u0001\u0002\u0003\u0005\t\u0011cK\u0002z'\u000fZ3sC\ndWM\f\u0011Ok2d\u0007%\u001a7f[\u0016tGo\u001d\u0011xS2d\u0007EY3!a2\f7-\u001a3!CR\u0004C\u000f[3!K:$\u0007e\u001c4!i\",\u0007E]3ukJtW\r\u001a\u0011beJ\f\u0017P\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002\u001e\u00069'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bf\n2(Y\u0001:Cm\n\u0017!]VdG\u000e\f\u0011(G\u001eb\u0003eJ1(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012bE1\u0012#M\t\u0017#G\nb#\u0005\u001a\u0012-]VdG.\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111U\u0001\u0006e9\"d\u0006M\u0004\n\u0003O\u0013\u0011\u0011!E\u0001\u0003S\u000b\u0011\"\u0011:sCf\u001cvN\u001d;\u0011\u0007E\tYK\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAW'\u0015\tY+a,\u001e!\u0019\t\t,a.$W5\u0011\u00111\u0017\u0006\u0004\u0003kK\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003s\u000b\u0019LA\tBEN$(/Y2u\rVt7\r^5p]FBq!KAV\t\u0003\ti\f\u0006\u0002\u0002*\"Q\u0011\u0011YAV\u0003\u0003%)%a1\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0010\t\u0015\u0005\u001d\u00171VA\u0001\n\u0003\u000bI-A\u0003baBd\u0017\u0010F\u0002,\u0003\u0017Da!IAc\u0001\u0004\u0019\u0003BCAh\u0003W\u000b\t\u0011\"!\u0002R\u00069QO\\1qa2LH\u0003BAj\u00033\u0004B\u0001GAkG%\u0019\u0011q[\r\u0003\r=\u0003H/[8o\u0011%\tY.!4\u0002\u0002\u0003\u00071&A\u0002yIAB!\"a8\u0002,\u0006\u0005I\u0011BAq\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\b\u0003BA!\u0003KLA!a:\u0002D\t1qJ\u00196fGR\u0004")
public class ArraySort
extends UnaryExpression
implements ArraySortLike,
Serializable {
    private final Expression child;
    private final transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    private final transient Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    private final transient DataType elementType;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ArraySort, A> function1) {
        return ArraySort$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ArraySort> compose(Function1<A, Expression> function1) {
        return ArraySort$.MODULE$.compose(function1);
    }

    private Comparator org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt = ArraySortLike$class.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
        }
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$lt;
    }

    private Comparator org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt = ArraySortLike$class.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
        }
    }

    @Override
    public Comparator<Object> org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySortLike$$gt;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = ArraySortLike$class.elementType(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.elementType;
        }
    }

    @Override
    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public boolean containsNull() {
        return ArraySortLike$class.containsNull(this);
    }

    @Override
    public Object sortEval(Object array, boolean ascending) {
        return ArraySortLike$class.sortEval(this, array, ascending);
    }

    @Override
    public String sortCodegen(CodegenContext ctx, ExprCode ev, String base, String order) {
        return ArraySortLike$class.sortCodegen(this, ctx, ev, base, order);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayType$[]{ArrayType$.MODULE$}));
    }

    @Override
    public Expression arrayExpression() {
        return this.child();
    }

    @Override
    public int nullOrder() {
        return ArraySortLike$NullOrder$.MODULE$.Greatest();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        void var5_8;
        boolean bl = false;
        ArrayType arrayType2 = null;
        DataType dataType2 = this.child().dataType();
        if (dataType2 instanceof ArrayType) {
            bl = true;
            arrayType2 = (ArrayType)dataType2;
            DataType dt = arrayType2.elementType();
            if (RowOrdering$.MODULE$.isOrderable(dt)) {
                TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                return var5_8;
            }
        }
        if (bl) {
            DataType dt = arrayType2.elementType();
            String dtSimple = dt.catalogString();
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " does not support sorting array of type ", " which is not orderable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName(), dtSimple})));
            return var5_8;
        }
        TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " only supports array input."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prettyName()})));
        return var5_8;
    }

    @Override
    public Object nullSafeEval(Object array) {
        return this.sortEval(array, true);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)new Serializable(this, ctx, ev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArraySort $outer;
            private final CodegenContext ctx$5;
            private final ExprCode ev$5;

            public final String apply(String c) {
                return this.$outer.sortCodegen(this.ctx$5, this.ev$5, c, "true");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$5 = ctx$5;
                this.ev$5 = ev$5;
            }
        });
    }

    @Override
    public String prettyName() {
        return "array_sort";
    }

    public ArraySort copy(Expression child) {
        return new ArraySort(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        Expression expression = this.child();
        Expression expression2 = arraySort.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression child) {
        this.child = child;
        ExpectsInputTypes$class.$init$(this);
        ArraySortLike$class.$init$(this);
    }
}

