/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NextDay$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, day_of_week) - Returns the first date which is later than `start_date` and named as indicated.", examples="\n    Examples:\n      > SELECT _FUNC_('2015-01-14', 'TU');\n       2015-01-20\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0001\u0003\u0001>\u0011qAT3yi\u0012\u000b\u0017P\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\f\u001e!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011#F\u0005\u0003-\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\b!J|G-^2u!\tAb$\u0003\u0002 3\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0005\u0001BK\u0002\u0013\u0005!%A\u0005ti\u0006\u0014H\u000fR1uKV\t1\u0005\u0005\u0002\u0012I%\u0011QE\u0001\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002C\u0014\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\u0015M$\u0018M\u001d;ECR,\u0007\u0005\u0003\u0005*\u0001\tU\r\u0011\"\u0001#\u0003%!\u0017-_(g/\u0016,7\u000e\u0003\u0005,\u0001\tE\t\u0015!\u0003$\u0003)!\u0017-_(g/\u0016,7\u000e\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007=\u0002\u0014\u0007\u0005\u0002\u0012\u0001!)\u0011\u0005\fa\u0001G!)\u0011\u0006\fa\u0001G!)1\u0007\u0001C!E\u0005!A.\u001a4u\u0011\u0015)\u0004\u0001\"\u0011#\u0003\u0015\u0011\u0018n\u001a5u\u0011\u00159\u0004\u0001\"\u00119\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002sA\u0019!HQ#\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 \u000f\u0003\u0019a$o\\8u}%\t!$\u0003\u0002B3\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u0005\r\u0019V-\u001d\u0006\u0003\u0003f\u0001\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0004\u0002\u000bQL\b/Z:\n\u0005);%\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011\u0015a\u0005\u0001\"\u0011N\u0003!!\u0017\r^1UsB,W#\u0001(\u0011\u0005\u0019{\u0015B\u0001)H\u0005!!\u0015\r^1UsB,\u0007\"\u0002*\u0001\t\u0003\u001a\u0016\u0001\u00038vY2\f'\r\\3\u0016\u0003Q\u0003\"\u0001G+\n\u0005YK\"a\u0002\"p_2,\u0017M\u001c\u0005\u00061\u0002!\t%W\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00045v{\u0006C\u0001\r\\\u0013\ta\u0016DA\u0002B]fDQAX,A\u0002i\u000bQa\u001d;beRDQ\u0001Y,A\u0002i\u000ba\u0001Z1z\u001f\u001a<\u0006\"\u00022\u0001\t#\u001a\u0017!\u00033p\u000f\u0016t7i\u001c3f)\r!'n\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003O\n\tqaY8eK\u001e,g.\u0003\u0002jM\nAQ\t\u001f9s\u0007>$W\rC\u0003lC\u0002\u0007A.A\u0002dib\u0004\"!Z7\n\u000594'AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006a\u0006\u0004\r\u0001Z\u0001\u0003KZDQA\u001d\u0001\u0005BM\f!\u0002\u001d:fiRLh*Y7f+\u0005!\bCA;y\u001d\tAb/\u0003\u0002x3\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9\u0018\u0004C\u0004}\u0001\u0005\u0005I\u0011A?\u0002\t\r|\u0007/\u001f\u000b\u0004_y|\bbB\u0011|!\u0003\u0005\ra\t\u0005\bSm\u0004\n\u00111\u0001$\u0011%\t\u0019\u0001AI\u0001\n\u0003\t)!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d!fA\u0012\u0002\n-\u0012\u00111\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016e\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI\"a\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u001e\u0001\t\n\u0011\"\u0001\u0002\u0006\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA\u0011\u0001\u0005\u0005I\u0011IA\u0012\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0012\u0001\u00026bm\u0006L1!_A\u0015\u0011%\t)\u0004AA\u0001\n\u0003\t9$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002:A\u0019\u0001$a\u000f\n\u0007\u0005u\u0012DA\u0002J]RD\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!,!\u0012\t\u0015\u0005\u001d\u0013qHA\u0001\u0002\u0004\tI$A\u0002yIEB\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0014\u0011\u000b\u0005E\u0013q\u000b.\u000e\u0005\u0005M#bAA+3\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u00131\u000b\u0002\t\u0013R,'/\u0019;pe\"I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011qL\u0001\tG\u0006tW)];bYR\u0019A+!\u0019\t\u0013\u0005\u001d\u00131LA\u0001\u0002\u0004Q\u0006\"CA3\u0001\u0005\u0005I\u0011IA4\u0003\u0019)\u0017/^1mgR\u0019A+!\u001b\t\u0013\u0005\u001d\u00131MA\u0001\u0002\u0004Q\u0006f\u0004\u0001\u0002n\u0005M\u0014QOA=\u0003w\ny(!!\u0011\u0007E\ty'C\u0002\u0002r\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002x\u0005\txLR+O\u0007~C3\u000f^1si~#\u0017\r^3-A\u0011\f\u0017pX8g?^,Wm[\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011eCR,\u0007e\u001e5jG\"\u0004\u0013n\u001d\u0011mCR,'\u000f\t;iC:\u0004\u0003m\u001d;beR|F-\u0019;fA\u0002\ng\u000e\u001a\u0011oC6,G\rI1tA%tG-[2bi\u0016$g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti(\u0001(\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'M\u001b.aEj\u0013\u0007N\u0014-A\u001d\"VkJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014'N\u00171c5\u0012\u0004G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019)A\u00032]Ur\u0003gB\u0005\u0002\b\n\t\t\u0011#\u0001\u0002\n\u00069a*\u001a=u\t\u0006L\bcA\t\u0002\f\u001aA\u0011AAA\u0001\u0012\u0003\tiiE\u0003\u0002\f\u0006=U\u0004E\u0004\u0002\u0012\u0006]5eI\u0018\u000e\u0005\u0005M%bAAK3\u00059!/\u001e8uS6,\u0017\u0002BAM\u0003'\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001di\u00131\u0012C\u0001\u0003;#\"!!#\t\u0015\u0005\u0005\u00161RA\u0001\n\u000b\n\u0019+\u0001\u0005u_N#(/\u001b8h)\t\t)\u0003\u0003\u0006\u0002(\u0006-\u0015\u0011!CA\u0003S\u000bQ!\u00199qYf$RaLAV\u0003[Ca!IAS\u0001\u0004\u0019\u0003BB\u0015\u0002&\u0002\u00071\u0005\u0003\u0006\u00022\u0006-\u0015\u0011!CA\u0003g\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00026\u0006\u0005\u0007#\u0002\r\u00028\u0006m\u0016bAA]3\t1q\n\u001d;j_:\u0004R\u0001GA_G\rJ1!a0\u001a\u0005\u0019!V\u000f\u001d7fe!I\u00111YAX\u0003\u0003\u0005\raL\u0001\u0004q\u0012\u0002\u0004BCAd\u0003\u0017\u000b\t\u0011\"\u0003\u0002J\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\r\u0005\u0003\u0002(\u00055\u0017\u0002BAh\u0003S\u0011aa\u00142kK\u000e$\b")
public class NextDay
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression startDate;
    private final Expression dayOfWeek;

    public static Option<Tuple2<Expression, Expression>> unapply(NextDay nextDay) {
        return NextDay$.MODULE$.unapply(nextDay);
    }

    public static Function1<Tuple2<Expression, Expression>, NextDay> tupled() {
        return NextDay$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NextDay>> curried() {
        return NextDay$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression dayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.dayOfWeek();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object start, Object dayOfW) {
        Integer n;
        int dow = DateTimeUtils$.MODULE$.getDayOfWeekFromString((UTF8String)dayOfW);
        if (dow == -1) {
            n = null;
        } else {
            int sd = BoxesRunTime.unboxToInt((Object)start);
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getNextDateForDayOfWeek(sd, dow));
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx, ev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NextDay $outer;
            private final CodegenContext ctx$4;
            private final ExprCode ev$8;

            public final String apply(String sd, String dowS) {
                String string;
                String dateTimeUtilClass = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
                String dayOfWeekTerm = this.ctx$4.freshName("dayOfWeek");
                if (this.$outer.dayOfWeek().foldable()) {
                    UTF8String input = (UTF8String)this.$outer.dayOfWeek().eval(this.$outer.dayOfWeek().eval$default$1());
                    if (input == null || DateTimeUtils$.MODULE$.getDayOfWeekFromString(input) == -1) {
                        string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " = true;\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev$8.isNull()})))).stripMargin();
                    } else {
                        int dayOfWeekValue = DateTimeUtils$.MODULE$.getDayOfWeekFromString(input);
                        string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " = ", ".getNextDateForDayOfWeek(", ", ", ");\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev$8.value(), dateTimeUtilClass, sd, BoxesRunTime.boxToInteger((int)dayOfWeekValue)})))).stripMargin();
                    }
                } else {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |int ", " = ", ".getDayOfWeekFromString(", ");\n           |if (", " == -1) {\n           |  ", " = true;\n           |} else {\n           |  ", " = ", ".getNextDateForDayOfWeek(", ", ", ");\n           |}\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dayOfWeekTerm, dateTimeUtilClass, dowS, dayOfWeekTerm, this.ev$8.isNull(), this.ev$8.value(), dateTimeUtilClass, sd, dayOfWeekTerm})))).stripMargin();
                }
                return string;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$4 = ctx$4;
                this.ev$8 = ev$8;
            }
        });
    }

    @Override
    public String prettyName() {
        return "next_day";
    }

    public NextDay copy(Expression startDate, Expression dayOfWeek) {
        return new NextDay(startDate, dayOfWeek);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.dayOfWeek();
    }

    @Override
    public String productPrefix() {
        return "NextDay";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.dayOfWeek();
                break;
            }
            case 0: {
                expression = this.startDate();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NextDay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NextDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        NextDay nextDay = (NextDay)x$1;
        Expression expression = this.startDate();
        Expression expression2 = nextDay.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.dayOfWeek();
        Expression expression4 = nextDay.dayOfWeek();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nextDay.canEqual(this)) return false;
        return true;
    }

    public NextDay(Expression startDate, Expression dayOfWeek) {
        this.startDate = startDate;
        this.dayOfWeek = dayOfWeek;
        ExpectsInputTypes$class.$init$(this);
    }
}

