/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class StringUtils$ {
    public static final StringUtils$ MODULE$;
    private final Set<UTF8String> trueStrings;
    private final Set<UTF8String> falseStrings;

    static {
        new StringUtils$();
    }

    public String escapeLikeRegex(String pattern) {
        Iterator in = new StringOps(Predef$.MODULE$.augmentString(pattern)).toIterator();
        StringBuilder out = new StringBuilder();
        while (in.hasNext()) {
            block9: {
                char c = BoxesRunTime.unboxToChar((Object)in.next());
                switch (c) {
                    default: {
                        StringBuilder stringBuilder = out.$plus$plus$eq(Pattern.quote(Character.toString(c)));
                        break;
                    }
                    case '%': {
                        StringBuilder stringBuilder = out.$plus$plus$eq(".*");
                        break;
                    }
                    case '_': {
                        StringBuilder stringBuilder = out.$plus$plus$eq(".");
                        break;
                    }
                    case '\\': {
                        char c2;
                        if (!in.hasNext()) break block9;
                        char c3 = c2 = BoxesRunTime.unboxToChar((Object)in.next());
                        switch (c3) {
                            default: {
                                throw this.fail$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the escape character is not allowed to precede '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c2)})), pattern);
                            }
                            case '%': 
                            case '\\': 
                            case '_': 
                        }
                        StringBuilder stringBuilder = out.$plus$plus$eq(Pattern.quote(Character.toString(c2)));
                    }
                }
                continue;
            }
            throw this.fail$1("it is not allowed to end with the escape character", pattern);
        }
        return new StringBuilder().append((Object)"(?s)").append((Object)out.result()).toString();
    }

    public boolean isTrueString(UTF8String s) {
        return this.trueStrings.contains((Object)s.toLowerCase());
    }

    public boolean isFalseString(UTF8String s) {
        return this.falseStrings.contains((Object)s.toLowerCase());
    }

    public Seq<String> filterPattern(Seq<String> names2, String pattern) {
        SortedSet funcNames = SortedSet$.MODULE$.empty((Ordering)Ordering.String$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])pattern.trim().split("\\|")).foreach((Function1)new Serializable(names2, funcNames){
            public static final long serialVersionUID = 0L;
            private final Seq names$1;
            private final SortedSet funcNames$1;

            public final Object apply(String subPattern) {
                BoxedUnit boxedUnit;
                try {
                    Regex regex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)"(?i)").append((Object)subPattern.replaceAll("\\*", ".*")).toString())).r();
                    boxedUnit = this.funcNames$1.$plus$plus$eq((TraversableOnce)this.names$1.filter((Function1)new Serializable(this, regex){
                        public static final long serialVersionUID = 0L;
                        private final Regex regex$1;

                        public final boolean apply(String name2) {
                            return this.regex$1.pattern().matcher(name2).matches();
                        }
                        {
                            this.regex$1 = regex$1;
                        }
                    }));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.names$1 = names$1;
                this.funcNames$1 = funcNames$1;
            }
        });
        return funcNames.toSeq();
    }

    private final Nothing$ fail$1(String message, String pattern$1) {
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the pattern '", "' is invalid, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pattern$1, message})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private StringUtils$() {
        MODULE$ = this;
        this.trueStrings = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t", "true", "y", "yes", "1"}))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UTF8String apply(String x$1) {
                return UTF8String.fromString((String)x$1);
            }
        }, Set$.MODULE$.canBuildFrom());
        this.falseStrings = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f", "false", "n", "no", "0"}))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UTF8String apply(String x$1) {
                return UTF8String.fromString((String)x$1);
            }
        }, Set$.MODULE$.canBuildFrom());
    }
}

