/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.types;

import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$JSortedObject$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@InterfaceStability.Stable
public final class DataType$ {
    public static final DataType$ MODULE$;
    private final Regex FIXED_DECIMAL;
    private final Map<String, DataType> nonDecimalNameToType;
    private final Regex SparkGeneratedName;

    static {
        new DataType$();
    }

    private Regex FIXED_DECIMAL() {
        return this.FIXED_DECIMAL;
    }

    public DataType fromDDL(String ddl) {
        DataType dataType2;
        try {
            dataType2 = CatalystSqlParser$.MODULE$.parseDataType(ddl);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            StructType structType2 = CatalystSqlParser$.MODULE$.parseTableSchema(ddl);
            dataType2 = structType2;
        }
        return dataType2;
    }

    public DataType fromJson(String json) {
        return this.parseDataType(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
    }

    private Map<String, DataType> nonDecimalNameToType() {
        return this.nonDecimalNameToType;
    }

    private DataType nameToType(String name2) {
        DataType dataType2;
        String string = name2;
        if ("decimal".equals(string)) {
            dataType2 = DecimalType$.MODULE$.USER_DEFAULT();
        } else {
            Option option = this.FIXED_DECIMAL().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String precision = (String)((LinearSeqOptimized)option.get()).apply(0);
                String scale = (String)((LinearSeqOptimized)option.get()).apply(1);
                dataType2 = new DecimalType(new StringOps(Predef$.MODULE$.augmentString(precision)).toInt(), new StringOps(Predef$.MODULE$.augmentString(scale)).toInt());
            } else {
                dataType2 = (DataType)this.nonDecimalNameToType().getOrElse((Object)string, (Function0)new Serializable(name2){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final Nothing$ apply() {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to convert the JSON string '", "' to a data type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
                    }
                    {
                        this.name$1 = name$1;
                    }
                });
            }
        }
        return dataType2;
    }

    public DataType parseDataType(JsonAST.JValue json) {
        JsonAST.JValue jValue;
        block8: {
            DataType dataType2;
            block3: {
                JsonAST.JString jString;
                String string;
                Option<List<Tuple2<String, JsonAST.JValue>>> option;
                block7: {
                    JsonAST.JString jString2;
                    String string2;
                    String string3;
                    String string4;
                    Option<List<Tuple2<String, JsonAST.JValue>>> option2;
                    block6: {
                        JsonAST.JString jString3;
                        String string5;
                        Option<List<Tuple2<String, JsonAST.JValue>>> option3;
                        block5: {
                            JsonAST.JString jString4;
                            String string6;
                            Option<List<Tuple2<String, JsonAST.JValue>>> option4;
                            block4: {
                                JsonAST.JString jString5;
                                String string7;
                                block2: {
                                    jValue = json;
                                    if (!(jValue instanceof JsonAST.JString)) break block2;
                                    JsonAST.JString jString6 = (JsonAST.JString)jValue;
                                    String name2 = jString6.s();
                                    dataType2 = this.nameToType(name2);
                                    break block3;
                                }
                                Option<List<Tuple2<String, JsonAST.JValue>>> option5 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue);
                                if (option5.isEmpty() || option5.get() == null || ((LinearSeqOptimized)option5.get()).lengthCompare(3) != 0) break block4;
                                Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option5.get()).apply(0);
                                Tuple2 tuple22 = (Tuple2)((LinearSeqOptimized)option5.get()).apply(1);
                                Tuple2 tuple23 = (Tuple2)((LinearSeqOptimized)option5.get()).apply(2);
                                if (tuple2 == null) break block4;
                                String string8 = (String)tuple2._1();
                                JsonAST.JValue jValue2 = (JsonAST.JValue)tuple2._2();
                                if (!"containsNull".equals(string8) || !(jValue2 instanceof JsonAST.JBool)) break block4;
                                JsonAST.JBool jBool = (JsonAST.JBool)jValue2;
                                boolean n = jBool.value();
                                if (tuple22 == null) break block4;
                                String string9 = (String)tuple22._1();
                                JsonAST.JValue t = (JsonAST.JValue)tuple22._2();
                                if (!"elementType".equals(string9) || t == null) break block4;
                                JsonAST.JValue jValue3 = t;
                                if (tuple23 == null) break block4;
                                String string10 = (String)tuple23._1();
                                JsonAST.JValue jValue4 = (JsonAST.JValue)tuple23._2();
                                if (!"type".equals(string10) || !(jValue4 instanceof JsonAST.JString) || !"array".equals(string7 = (jString5 = (JsonAST.JString)jValue4).s())) break block4;
                                dataType2 = new ArrayType(this.parseDataType(jValue3), n);
                                break block3;
                            }
                            if ((option4 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() || option4.get() == null || ((LinearSeqOptimized)option4.get()).lengthCompare(4) != 0) break block5;
                            Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option4.get()).apply(0);
                            Tuple2 tuple24 = (Tuple2)((LinearSeqOptimized)option4.get()).apply(1);
                            Tuple2 tuple25 = (Tuple2)((LinearSeqOptimized)option4.get()).apply(2);
                            Tuple2 tuple26 = (Tuple2)((LinearSeqOptimized)option4.get()).apply(3);
                            if (tuple2 == null) break block5;
                            String string11 = (String)tuple2._1();
                            JsonAST.JValue k = (JsonAST.JValue)tuple2._2();
                            if (!"keyType".equals(string11) || k == null) break block5;
                            JsonAST.JValue jValue5 = k;
                            if (tuple24 == null) break block5;
                            String string12 = (String)tuple24._1();
                            JsonAST.JValue jValue6 = (JsonAST.JValue)tuple24._2();
                            if (!"type".equals(string12) || !(jValue6 instanceof JsonAST.JString) || !"map".equals(string6 = (jString4 = (JsonAST.JString)jValue6).s()) || tuple25 == null) break block5;
                            String string13 = (String)tuple25._1();
                            JsonAST.JValue jValue7 = (JsonAST.JValue)tuple25._2();
                            if (!"valueContainsNull".equals(string13) || !(jValue7 instanceof JsonAST.JBool)) break block5;
                            JsonAST.JBool jBool = (JsonAST.JBool)jValue7;
                            boolean n = jBool.value();
                            if (tuple26 == null) break block5;
                            String string14 = (String)tuple26._1();
                            JsonAST.JValue v = (JsonAST.JValue)tuple26._2();
                            if (!"valueType".equals(string14) || v == null) break block5;
                            JsonAST.JValue jValue8 = v;
                            dataType2 = new MapType(this.parseDataType(jValue5), this.parseDataType(jValue8), n);
                            break block3;
                        }
                        if ((option3 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() || option3.get() == null || ((LinearSeqOptimized)option3.get()).lengthCompare(2) != 0) break block6;
                        Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option3.get()).apply(0);
                        Tuple2 tuple27 = (Tuple2)((LinearSeqOptimized)option3.get()).apply(1);
                        if (tuple2 == null) break block6;
                        String string15 = (String)tuple2._1();
                        JsonAST.JValue jValue9 = (JsonAST.JValue)tuple2._2();
                        if (!"fields".equals(string15) || !(jValue9 instanceof JsonAST.JArray)) break block6;
                        JsonAST.JArray jArray = (JsonAST.JArray)jValue9;
                        List fields = jArray.arr();
                        if (tuple27 == null) break block6;
                        String string16 = (String)tuple27._1();
                        JsonAST.JValue jValue10 = (JsonAST.JValue)tuple27._2();
                        if (!"type".equals(string16) || !(jValue10 instanceof JsonAST.JString) || !"struct".equals(string5 = (jString3 = (JsonAST.JString)jValue10).s())) break block6;
                        dataType2 = StructType$.MODULE$.apply((Seq<StructField>)((Seq)fields.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final StructField apply(JsonAST.JValue json) {
                                return DataType$.MODULE$.org$apache$spark$sql$types$DataType$$parseStructField(json);
                            }
                        }, List$.MODULE$.canBuildFrom())));
                        break block3;
                    }
                    if ((option2 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(4) != 0) break block7;
                    Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(0);
                    Tuple2 tuple28 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(1);
                    Tuple2 tuple29 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(2);
                    Tuple2 tuple210 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(3);
                    if (tuple2 == null) break block7;
                    String string17 = (String)tuple2._1();
                    JsonAST.JValue jValue11 = (JsonAST.JValue)tuple2._2();
                    if (!"class".equals(string17) || !(jValue11 instanceof JsonAST.JString)) break block7;
                    JsonAST.JString jString7 = (JsonAST.JString)jValue11;
                    String udtClass = jString7.s();
                    if (tuple28 == null || !"pyClass".equals(string4 = (String)tuple28._1()) || tuple29 == null || !"sqlType".equals(string3 = (String)tuple29._1()) || tuple210 == null) break block7;
                    String string18 = (String)tuple210._1();
                    JsonAST.JValue jValue12 = (JsonAST.JValue)tuple210._2();
                    if (!"type".equals(string18) || !(jValue12 instanceof JsonAST.JString) || !"udt".equals(string2 = (jString2 = (JsonAST.JString)jValue12).s())) break block7;
                    dataType2 = (UserDefinedType)Utils$.MODULE$.classForName(udtClass).newInstance();
                    break block3;
                }
                if ((option = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) break block8;
                Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option.get()).apply(0);
                Tuple2 tuple211 = (Tuple2)((LinearSeqOptimized)option.get()).apply(1);
                Tuple2 tuple212 = (Tuple2)((LinearSeqOptimized)option.get()).apply(2);
                Tuple2 tuple213 = (Tuple2)((LinearSeqOptimized)option.get()).apply(3);
                if (tuple2 == null) break block8;
                String string19 = (String)tuple2._1();
                JsonAST.JValue jValue13 = (JsonAST.JValue)tuple2._2();
                if (!"pyClass".equals(string19) || !(jValue13 instanceof JsonAST.JString)) break block8;
                JsonAST.JString jString8 = (JsonAST.JString)jValue13;
                String pyClass = jString8.s();
                if (tuple211 == null) break block8;
                String string20 = (String)tuple211._1();
                JsonAST.JValue jValue14 = (JsonAST.JValue)tuple211._2();
                if (!"serializedClass".equals(string20) || !(jValue14 instanceof JsonAST.JString)) break block8;
                JsonAST.JString jString9 = (JsonAST.JString)jValue14;
                String serialized = jString9.s();
                if (tuple212 == null) break block8;
                String string21 = (String)tuple212._1();
                JsonAST.JValue v = (JsonAST.JValue)tuple212._2();
                if (!"sqlType".equals(string21) || v == null) break block8;
                JsonAST.JValue jValue15 = v;
                if (tuple213 == null) break block8;
                String string22 = (String)tuple213._1();
                JsonAST.JValue jValue16 = (JsonAST.JValue)tuple213._2();
                if (!"type".equals(string22) || !(jValue16 instanceof JsonAST.JString) || !"udt".equals(string = (jString = (JsonAST.JString)jValue16).s())) break block8;
                dataType2 = new PythonUserDefinedType(this.parseDataType(jValue15), pyClass, serialized);
            }
            return dataType2;
        }
        Object[] objectArray = new Object[1];
        JsonAST.JValue x$7 = jValue;
        Formats x$8 = JsonMethods$.MODULE$.render$default$2(x$7);
        objectArray[0] = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$7, x$8));
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to convert the JSON string '", "' to a data type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
    }

    public StructField org$apache$spark$sql$types$DataType$$parseStructField(JsonAST.JValue json) {
        JsonAST.JValue jValue;
        block4: {
            StructField structField2;
            block3: {
                Option<List<Tuple2<String, JsonAST.JValue>>> option;
                block2: {
                    jValue = json;
                    Option<List<Tuple2<String, JsonAST.JValue>>> option2 = DataType$JSortedObject$.MODULE$.unapplySeq(jValue);
                    if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(4) != 0) break block2;
                    Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(0);
                    Tuple2 tuple22 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(1);
                    Tuple2 tuple23 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(2);
                    Tuple2 tuple24 = (Tuple2)((LinearSeqOptimized)option2.get()).apply(3);
                    if (tuple2 == null) break block2;
                    String string = (String)tuple2._1();
                    JsonAST.JValue metadata2 = (JsonAST.JValue)tuple2._2();
                    if (!"metadata".equals(string) || !(metadata2 instanceof JsonAST.JObject)) break block2;
                    JsonAST.JObject jObject = (JsonAST.JObject)metadata2;
                    if (tuple22 == null) break block2;
                    String string2 = (String)tuple22._1();
                    JsonAST.JValue jValue2 = (JsonAST.JValue)tuple22._2();
                    if (!"name".equals(string2) || !(jValue2 instanceof JsonAST.JString)) break block2;
                    JsonAST.JString jString = (JsonAST.JString)jValue2;
                    String name2 = jString.s();
                    if (tuple23 == null) break block2;
                    String string3 = (String)tuple23._1();
                    JsonAST.JValue jValue3 = (JsonAST.JValue)tuple23._2();
                    if (!"nullable".equals(string3) || !(jValue3 instanceof JsonAST.JBool)) break block2;
                    JsonAST.JBool jBool = (JsonAST.JBool)jValue3;
                    boolean nullable2 = jBool.value();
                    if (tuple24 == null) break block2;
                    String string4 = (String)tuple24._1();
                    JsonAST.JValue dataType2 = (JsonAST.JValue)tuple24._2();
                    if (!"type".equals(string4) || dataType2 == null) break block2;
                    JsonAST.JValue jValue4 = dataType2;
                    structField2 = new StructField(name2, this.parseDataType(jValue4), nullable2, Metadata$.MODULE$.fromJObject(jObject));
                    break block3;
                }
                if ((option = DataType$JSortedObject$.MODULE$.unapplySeq(jValue)).isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(3) != 0) break block4;
                Tuple2 tuple2 = (Tuple2)((LinearSeqOptimized)option.get()).apply(0);
                Tuple2 tuple25 = (Tuple2)((LinearSeqOptimized)option.get()).apply(1);
                Tuple2 tuple26 = (Tuple2)((LinearSeqOptimized)option.get()).apply(2);
                if (tuple2 == null) break block4;
                String string = (String)tuple2._1();
                JsonAST.JValue jValue5 = (JsonAST.JValue)tuple2._2();
                if (!"name".equals(string) || !(jValue5 instanceof JsonAST.JString)) break block4;
                JsonAST.JString jString = (JsonAST.JString)jValue5;
                String name3 = jString.s();
                if (tuple25 == null) break block4;
                String string5 = (String)tuple25._1();
                JsonAST.JValue jValue6 = (JsonAST.JValue)tuple25._2();
                if (!"nullable".equals(string5) || !(jValue6 instanceof JsonAST.JBool)) break block4;
                JsonAST.JBool jBool = (JsonAST.JBool)jValue6;
                boolean nullable3 = jBool.value();
                if (tuple26 == null) break block4;
                String string6 = (String)tuple26._1();
                JsonAST.JValue dataType3 = (JsonAST.JValue)tuple26._2();
                if (!"type".equals(string6) || dataType3 == null) break block4;
                JsonAST.JValue jValue7 = dataType3;
                structField2 = new StructField(name3, this.parseDataType(jValue7), nullable3, StructField$.MODULE$.apply$default$4());
            }
            return structField2;
        }
        Object[] objectArray = new Object[1];
        JsonAST.JValue x$9 = jValue;
        Formats x$10 = JsonMethods$.MODULE$.render$default$2(x$9);
        objectArray[0] = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$9, x$10));
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to convert the JSON string '", "' to a field."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
    }

    public void buildFormattedString(DataType dataType2, String prefix, StringBuilder builder) {
        DataType dataType3 = dataType2;
        if (dataType3 instanceof ArrayType) {
            ArrayType arrayType2 = (ArrayType)dataType3;
            arrayType2.buildFormattedString(prefix, builder);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType3 instanceof StructType) {
            StructType structType2 = (StructType)dataType3;
            structType2.buildFormattedString(prefix, builder);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType3 instanceof MapType) {
            MapType mapType2 = (MapType)dataType3;
            mapType2.buildFormattedString(prefix, builder);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public boolean equalsIgnoreNullability(DataType left, DataType right) {
        Tuple2 tuple2;
        block10: {
            boolean bl;
            block8: {
                block9: {
                    block7: {
                        while (true) {
                            if ((tuple2 = new Tuple2((Object)left, (Object)right)) != null) {
                                DataType dataType2 = (DataType)tuple2._1();
                                DataType dataType3 = (DataType)tuple2._2();
                                if (dataType2 instanceof ArrayType) {
                                    ArrayType arrayType2 = (ArrayType)dataType2;
                                    DataType leftElementType = arrayType2.elementType();
                                    if (dataType3 instanceof ArrayType) {
                                        DataType rightElementType;
                                        ArrayType arrayType3 = (ArrayType)dataType3;
                                        right = rightElementType = arrayType3.elementType();
                                        left = leftElementType;
                                        continue;
                                    }
                                }
                            }
                            if (tuple2 == null) break block7;
                            DataType dataType4 = (DataType)tuple2._1();
                            DataType dataType5 = (DataType)tuple2._2();
                            if (!(dataType4 instanceof MapType)) break block7;
                            MapType mapType2 = (MapType)dataType4;
                            DataType leftKeyType = mapType2.keyType();
                            DataType leftValueType = mapType2.valueType();
                            if (!(dataType5 instanceof MapType)) break block7;
                            MapType mapType3 = (MapType)dataType5;
                            DataType rightKeyType = mapType3.keyType();
                            DataType rightValueType = mapType3.valueType();
                            if (!this.equalsIgnoreNullability(leftKeyType, rightKeyType)) break;
                            right = rightValueType;
                            left = leftValueType;
                        }
                        bl = false;
                        break block8;
                    }
                    if (tuple2 == null) break block9;
                    DataType dataType6 = (DataType)tuple2._1();
                    DataType dataType7 = (DataType)tuple2._2();
                    if (!(dataType6 instanceof StructType)) break block9;
                    StructType structType2 = (StructType)dataType6;
                    StructField[] leftFields = structType2.fields();
                    if (!(dataType7 instanceof StructType)) break block9;
                    StructType structType3 = (StructType)dataType7;
                    StructField[] rightFields = structType3.fields();
                    bl = leftFields.length == rightFields.length && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])leftFields).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rightFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<StructField, StructField> x0$1) {
                            Tuple2<StructField, StructField> tuple2 = x0$1;
                            if (tuple2 != null) {
                                StructField l = (StructField)tuple2._1();
                                StructField r = (StructField)tuple2._2();
                                String string = l.name();
                                String string2 = r.name();
                                boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && DataType$.MODULE$.equalsIgnoreNullability(l.dataType(), r.dataType());
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                    break block8;
                }
                if (tuple2 == null) break block10;
                DataType l = (DataType)tuple2._1();
                DataType r = (DataType)tuple2._2();
                DataType dataType8 = l;
                DataType dataType9 = r;
                bl = !(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null);
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsIgnoreCompatibleNullability(DataType from, DataType to) {
        Tuple2 tuple2;
        block11: {
            boolean bl;
            block8: {
                block10: {
                    block9: {
                        while (true) {
                            if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                                DataType dataType2 = (DataType)tuple2._1();
                                DataType dataType3 = (DataType)tuple2._2();
                                if (dataType2 instanceof ArrayType) {
                                    ArrayType arrayType2 = (ArrayType)dataType2;
                                    DataType fromElement = arrayType2.elementType();
                                    boolean fn = arrayType2.containsNull();
                                    if (dataType3 instanceof ArrayType) {
                                        ArrayType arrayType3 = (ArrayType)dataType3;
                                        DataType toElement = arrayType3.elementType();
                                        boolean tn = arrayType3.containsNull();
                                        if (!tn && fn) {
                                            bl = false;
                                            break block8;
                                        }
                                        to = toElement;
                                        from = fromElement;
                                        continue;
                                    }
                                }
                            }
                            if (tuple2 == null) break block9;
                            DataType dataType4 = (DataType)tuple2._1();
                            DataType dataType5 = (DataType)tuple2._2();
                            if (!(dataType4 instanceof MapType)) break block9;
                            MapType mapType2 = (MapType)dataType4;
                            DataType fromKey = mapType2.keyType();
                            DataType fromValue = mapType2.valueType();
                            boolean fn = mapType2.valueContainsNull();
                            if (!(dataType5 instanceof MapType)) break block9;
                            MapType mapType3 = (MapType)dataType5;
                            DataType toKey = mapType3.keyType();
                            DataType toValue = mapType3.valueType();
                            boolean tn = mapType3.valueContainsNull();
                            if (!tn && fn || !this.equalsIgnoreCompatibleNullability(fromKey, toKey)) break;
                            to = toValue;
                            from = fromValue;
                        }
                        bl = false;
                        break block8;
                    }
                    if (tuple2 == null) break block10;
                    DataType dataType6 = (DataType)tuple2._1();
                    DataType dataType7 = (DataType)tuple2._2();
                    if (!(dataType6 instanceof StructType)) break block10;
                    StructType structType2 = (StructType)dataType6;
                    StructField[] fromFields = structType2.fields();
                    if (!(dataType7 instanceof StructType)) break block10;
                    StructType structType3 = (StructType)dataType7;
                    StructField[] toFields = structType3.fields();
                    bl = fromFields.length == toFields.length && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fromFields).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])toFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<StructField, StructField> x0$2) {
                            Tuple2<StructField, StructField> tuple2 = x0$2;
                            if (tuple2 == null) throw new MatchError(tuple2);
                            StructField fromField = (StructField)tuple2._1();
                            StructField toField = (StructField)tuple2._2();
                            String string = fromField.name();
                            String string2 = toField.name();
                            if (string == null) {
                                if (string2 != null) {
                                    return false;
                                }
                            } else if (!string.equals(string2)) return false;
                            if (!toField.nullable()) {
                                if (fromField.nullable()) return false;
                            }
                            if (!DataType$.MODULE$.equalsIgnoreCompatibleNullability(fromField.dataType(), toField.dataType())) return false;
                            return true;
                        }
                    });
                    break block8;
                }
                if (tuple2 == null) break block11;
                DataType fromDataType = (DataType)tuple2._1();
                DataType toDataType = (DataType)tuple2._2();
                DataType dataType8 = fromDataType;
                DataType dataType9 = toDataType;
                bl = !(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null);
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsIgnoreCaseAndNullability(DataType from, DataType to) {
        Tuple2 tuple2;
        block10: {
            boolean bl;
            block8: {
                block9: {
                    block7: {
                        while (true) {
                            if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                                DataType dataType2 = (DataType)tuple2._1();
                                DataType dataType3 = (DataType)tuple2._2();
                                if (dataType2 instanceof ArrayType) {
                                    ArrayType arrayType2 = (ArrayType)dataType2;
                                    DataType fromElement = arrayType2.elementType();
                                    if (dataType3 instanceof ArrayType) {
                                        DataType toElement;
                                        ArrayType arrayType3 = (ArrayType)dataType3;
                                        to = toElement = arrayType3.elementType();
                                        from = fromElement;
                                        continue;
                                    }
                                }
                            }
                            if (tuple2 == null) break block7;
                            DataType dataType4 = (DataType)tuple2._1();
                            DataType dataType5 = (DataType)tuple2._2();
                            if (!(dataType4 instanceof MapType)) break block7;
                            MapType mapType2 = (MapType)dataType4;
                            DataType fromKey = mapType2.keyType();
                            DataType fromValue = mapType2.valueType();
                            if (!(dataType5 instanceof MapType)) break block7;
                            MapType mapType3 = (MapType)dataType5;
                            DataType toKey = mapType3.keyType();
                            DataType toValue = mapType3.valueType();
                            if (!this.equalsIgnoreCaseAndNullability(fromKey, toKey)) break;
                            to = toValue;
                            from = fromValue;
                        }
                        bl = false;
                        break block8;
                    }
                    if (tuple2 == null) break block9;
                    DataType dataType6 = (DataType)tuple2._1();
                    DataType dataType7 = (DataType)tuple2._2();
                    if (!(dataType6 instanceof StructType)) break block9;
                    StructType structType2 = (StructType)dataType6;
                    StructField[] fromFields = structType2.fields();
                    if (!(dataType7 instanceof StructType)) break block9;
                    StructType structType3 = (StructType)dataType7;
                    StructField[] toFields = structType3.fields();
                    bl = fromFields.length == toFields.length && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fromFields).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])toFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<StructField, StructField> x0$3) {
                            Tuple2<StructField, StructField> tuple2 = x0$3;
                            if (tuple2 != null) {
                                StructField l = (StructField)tuple2._1();
                                StructField r = (StructField)tuple2._2();
                                boolean bl = l.name().equalsIgnoreCase(r.name()) && DataType$.MODULE$.equalsIgnoreCaseAndNullability(l.dataType(), r.dataType());
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                    break block8;
                }
                if (tuple2 == null) break block10;
                DataType fromDataType = (DataType)tuple2._1();
                DataType toDataType = (DataType)tuple2._2();
                DataType dataType8 = fromDataType;
                DataType dataType9 = toDataType;
                bl = !(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null);
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsStructurally(DataType from, DataType to, boolean ignoreNullability) {
        Tuple2 tuple2;
        block6: {
            boolean bl;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            tuple2 = new Tuple2((Object)from, (Object)to);
                            if (tuple2 == null) break block2;
                            DataType left = (DataType)tuple2._1();
                            DataType right = (DataType)tuple2._2();
                            if (!(left instanceof ArrayType)) break block2;
                            ArrayType arrayType2 = (ArrayType)left;
                            if (!(right instanceof ArrayType)) break block2;
                            ArrayType arrayType3 = (ArrayType)right;
                            bl = this.equalsStructurally(arrayType2.elementType(), arrayType3.elementType(), this.equalsStructurally$default$3()) && (ignoreNullability || arrayType2.containsNull() == arrayType3.containsNull());
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        DataType left = (DataType)tuple2._1();
                        DataType right = (DataType)tuple2._2();
                        if (!(left instanceof MapType)) break block4;
                        MapType mapType2 = (MapType)left;
                        if (!(right instanceof MapType)) break block4;
                        MapType mapType3 = (MapType)right;
                        bl = this.equalsStructurally(mapType2.keyType(), mapType3.keyType(), this.equalsStructurally$default$3()) && this.equalsStructurally(mapType2.valueType(), mapType3.valueType(), this.equalsStructurally$default$3()) && (ignoreNullability || mapType2.valueContainsNull() == mapType3.valueContainsNull());
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    DataType dataType2 = (DataType)tuple2._1();
                    DataType dataType3 = (DataType)tuple2._2();
                    if (!(dataType2 instanceof StructType)) break block5;
                    StructType structType2 = (StructType)dataType2;
                    StructField[] fromFields = structType2.fields();
                    if (!(dataType3 instanceof StructType)) break block5;
                    StructType structType3 = (StructType)dataType3;
                    StructField[] toFields = structType3.fields();
                    bl = fromFields.length == toFields.length && Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fromFields).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])toFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(ignoreNullability){
                        public static final long serialVersionUID = 0L;
                        private final boolean ignoreNullability$1;

                        public final boolean apply(Tuple2<StructField, StructField> x0$4) {
                            Tuple2<StructField, StructField> tuple2 = x0$4;
                            if (tuple2 != null) {
                                StructField l = (StructField)tuple2._1();
                                StructField r = (StructField)tuple2._2();
                                boolean bl = DataType$.MODULE$.equalsStructurally(l.dataType(), r.dataType(), DataType$.MODULE$.equalsStructurally$default$3()) && (this.ignoreNullability$1 || l.nullable() == r.nullable());
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.ignoreNullability$1 = ignoreNullability$1;
                        }
                    });
                    break block3;
                }
                if (tuple2 == null) break block6;
                DataType fromDataType = (DataType)tuple2._1();
                DataType toDataType = (DataType)tuple2._2();
                DataType dataType4 = fromDataType;
                DataType dataType5 = toDataType;
                bl = !(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null);
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean equalsStructurally$default$3() {
        return false;
    }

    private Regex SparkGeneratedName() {
        return this.SparkGeneratedName;
    }

    public boolean org$apache$spark$sql$types$DataType$$isSparkGeneratedName(String name2) {
        String string = name2;
        Option option = this.SparkGeneratedName().unapplySeq((CharSequence)string);
        boolean bl = !option.isEmpty();
        return bl;
    }

    public boolean canWrite(DataType write2, DataType read2, Function2<String, String, Object> resolver, String context, Function1<String, BoxedUnit> addError) {
        Tuple2 tuple2;
        block20: {
            boolean bl;
            block15: {
                block19: {
                    DataType r;
                    DataType w;
                    block18: {
                        boolean bl2;
                        block17: {
                            block16: {
                                boolean bl3;
                                boolean typesCompatible;
                                block14: {
                                    boolean bl4;
                                    tuple2 = new Tuple2((Object)write2, (Object)read2);
                                    if (tuple2 == null) break block14;
                                    DataType wArr = (DataType)tuple2._1();
                                    DataType rArr = (DataType)tuple2._2();
                                    if (!(wArr instanceof ArrayType)) break block14;
                                    ArrayType arrayType2 = (ArrayType)wArr;
                                    if (!(rArr instanceof ArrayType)) break block14;
                                    ArrayType arrayType3 = (ArrayType)rArr;
                                    boolean typesCompatible2 = this.canWrite(arrayType2.elementType(), arrayType3.elementType(), resolver, new StringBuilder().append((Object)context).append((Object)".element").toString(), addError);
                                    if (arrayType2.containsNull() && !arrayType3.containsNull()) {
                                        addError.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write nullable elements to array of non-nulls: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context})));
                                        bl4 = false;
                                    } else {
                                        bl4 = typesCompatible2;
                                    }
                                    bl = bl4;
                                    break block15;
                                }
                                if (tuple2 == null) break block16;
                                DataType wMap = (DataType)tuple2._1();
                                DataType rMap = (DataType)tuple2._2();
                                if (!(wMap instanceof MapType)) break block16;
                                MapType mapType2 = (MapType)wMap;
                                if (!(rMap instanceof MapType)) break block16;
                                MapType mapType3 = (MapType)rMap;
                                boolean keyCompatible = this.canWrite(mapType2.keyType(), mapType3.keyType(), resolver, new StringBuilder().append((Object)context).append((Object)".key").toString(), addError);
                                boolean valueCompatible = this.canWrite(mapType2.valueType(), mapType3.valueType(), resolver, new StringBuilder().append((Object)context).append((Object)".value").toString(), addError);
                                boolean bl5 = typesCompatible = keyCompatible && valueCompatible;
                                if (mapType2.valueContainsNull() && !mapType3.valueContainsNull()) {
                                    addError.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write nullable values to map of non-nulls: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context})));
                                    bl3 = false;
                                } else {
                                    bl3 = typesCompatible;
                                }
                                bl = bl3;
                                break block15;
                            }
                            if (tuple2 == null) break block17;
                            DataType dataType2 = (DataType)tuple2._1();
                            DataType dataType3 = (DataType)tuple2._2();
                            if (!(dataType2 instanceof StructType)) break block17;
                            StructType structType2 = (StructType)dataType2;
                            StructField[] writeFields = structType2.fields();
                            if (!(dataType3 instanceof StructType)) break block17;
                            StructType structType3 = (StructType)dataType3;
                            StructField[] readFields = structType3.fields();
                            BooleanRef fieldCompatible = BooleanRef.create((boolean)true);
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])readFields).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])writeFields), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(resolver, context, addError, fieldCompatible){
                                public static final long serialVersionUID = 0L;
                                private final Function2 resolver$1;
                                private final String context$1;
                                private final Function1 addError$1;
                                private final BooleanRef fieldCompatible$1;

                                public final void apply(Tuple2<StructField, StructField> x0$5) {
                                    Tuple2<StructField, StructField> tuple2 = x0$5;
                                    if (tuple2 != null) {
                                        BoxedUnit boxedUnit;
                                        StructField rField = (StructField)tuple2._1();
                                        StructField wField = (StructField)tuple2._2();
                                        boolean namesMatch = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)wField.name(), (Object)rField.name())) || DataType$.MODULE$.org$apache$spark$sql$types$DataType$$isSparkGeneratedName(wField.name());
                                        String fieldContext = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.context$1, rField.name()}));
                                        boolean typesCompatible = DataType$.MODULE$.canWrite(wField.dataType(), rField.dataType(), (Function2<String, String, Object>)this.resolver$1, fieldContext, (Function1<String, BoxedUnit>)this.addError$1);
                                        if (namesMatch) {
                                            if (!rField.nullable() && wField.nullable()) {
                                                this.addError$1.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write nullable values to non-null field: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldContext})));
                                                this.fieldCompatible$1.elem = false;
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else if (typesCompatible) {
                                                boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                this.fieldCompatible$1.elem = false;
                                                boxedUnit = BoxedUnit.UNIT;
                                            }
                                        } else {
                                            this.addError$1.apply((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Struct '", "' field name does not match (may be out of order): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.context$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected '", "', found '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rField.name(), wField.name()}))).toString());
                                            this.fieldCompatible$1.elem = false;
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.resolver$1 = resolver$1;
                                    this.context$1 = context$1;
                                    this.addError$1 = addError$1;
                                    this.fieldCompatible$1 = fieldCompatible$1;
                                }
                            });
                            if (Predef$.MODULE$.refArrayOps((Object[])readFields).size() > Predef$.MODULE$.refArrayOps((Object[])writeFields).size()) {
                                String missingFieldsStr = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])readFields).takeRight(Predef$.MODULE$.refArrayOps((Object[])readFields).size() - Predef$.MODULE$.refArrayOps((Object[])writeFields).size())).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(StructField f) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name()}));
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
                                if (new StringOps(Predef$.MODULE$.augmentString(missingFieldsStr)).nonEmpty()) {
                                    addError.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Struct '", "' missing fields: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context, missingFieldsStr})));
                                    fieldCompatible.elem = false;
                                }
                            } else if (Predef$.MODULE$.refArrayOps((Object[])writeFields).size() > Predef$.MODULE$.refArrayOps((Object[])readFields).size()) {
                                String extraFieldsStr = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])writeFields).takeRight(Predef$.MODULE$.refArrayOps((Object[])writeFields).size() - Predef$.MODULE$.refArrayOps((Object[])readFields).size())).map((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(StructField f) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name()}));
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ");
                                addError.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write extra fields to struct '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context, extraFieldsStr})));
                                fieldCompatible.elem = false;
                            }
                            bl = fieldCompatible.elem;
                            break block15;
                        }
                        if (tuple2 == null) break block18;
                        DataType w2 = (DataType)tuple2._1();
                        DataType r2 = (DataType)tuple2._2();
                        if (!(w2 instanceof AtomicType)) break block18;
                        AtomicType atomicType = (AtomicType)w2;
                        if (!(r2 instanceof AtomicType)) break block18;
                        AtomicType atomicType2 = (AtomicType)r2;
                        if (Cast$.MODULE$.canSafeCast(atomicType, atomicType2)) {
                            bl2 = true;
                        } else {
                            addError.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot safely cast '", "': ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context, atomicType, atomicType2})));
                            bl2 = false;
                        }
                        bl = bl2;
                        break block15;
                    }
                    if (tuple2 == null || !(w = (DataType)tuple2._1()).sameType(r = (DataType)tuple2._2()) || w instanceof NullType) break block19;
                    bl = true;
                    break block15;
                }
                if (tuple2 == null) break block20;
                DataType w = (DataType)tuple2._1();
                DataType r = (DataType)tuple2._2();
                addError.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot write '", "': ", " is incompatible with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context, w, r})));
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public Function1<String, BoxedUnit> canWrite$default$5() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$2) {
            }
        };
    }

    private DataType$() {
        MODULE$ = this;
        this.FIXED_DECIMAL = new StringOps(Predef$.MODULE$.augmentString("decimal\\(\\s*(\\d+)\\s*,\\s*(\\-?\\d+)\\s*\\)")).r();
        this.nonDecimalNameToType = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{NullType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, BinaryType$.MODULE$, IntegerType$.MODULE$, BooleanType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, ShortType$.MODULE$, ByteType$.MODULE$, StringType$.MODULE$, CalendarIntervalType$.MODULE$}))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(DataType t) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.typeName()), (Object)t);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.SparkGeneratedName = new StringOps(Predef$.MODULE$.augmentString("col\\d+")).r();
    }
}

