/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.math.BigDecimal;
import org.apache.orc.storage.ql.io.sarg.PredicateLeaf;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;
import org.apache.orc.storage.ql.io.sarg.SearchArgumentFactory;
import org.apache.orc.storage.serde2.io.HiveDecimalWritable;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$$anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$$anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument$1$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$$anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument$2$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class OrcFilters$ {
    public static final OrcFilters$ MODULE$;

    static {
        new OrcFilters$();
    }

    public Option<Filter> buildTree(Seq<Filter> filters) {
        Tuple2 tuple2;
        block6: {
            None$ none$;
            block3: {
                Tuple2 tuple22;
                block5: {
                    Seq<Filter> seq;
                    block4: {
                        block2: {
                            seq = filters;
                            Some some = Seq$.MODULE$.unapplySeq(seq);
                            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(0) != 0) break block2;
                            none$ = None$.MODULE$;
                            break block3;
                        }
                        Some some = Seq$.MODULE$.unapplySeq(seq);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0) break block4;
                        Filter filter = (Filter)((SeqLike)some.get()).apply(0);
                        none$ = new Some((Object)filter);
                        break block3;
                    }
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block5;
                    Filter filter1 = (Filter)((SeqLike)some.get()).apply(0);
                    Filter filter2 = (Filter)((SeqLike)some.get()).apply(1);
                    none$ = new Some((Object)new And(filter1, filter2));
                    break block3;
                }
                tuple2 = filters.splitAt(filters.length() / 2);
                if (tuple2 == null) break block6;
                Seq left = (Seq)tuple2._1();
                Seq right = (Seq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)left, (Object)right);
                Seq left2 = (Seq)tuple23._1();
                Seq right2 = (Seq)tuple23._2();
                none$ = new Some((Object)new And((Filter)this.buildTree((Seq<Filter>)left2).get(), (Filter)this.buildTree((Seq<Filter>)right2).get()));
            }
            return none$;
        }
        throw new MatchError((Object)tuple2);
    }

    private String quoteAttributeNameIfNeeded(String name2) {
        return !name2.contains("`") && name2.contains(".") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2})) : name2;
    }

    public Option<SearchArgument> createFilter(StructType schema2, Seq<Filter> filters) {
        Map dataTypeMap = ((TraversableOnce)schema2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, DataType> apply(StructField f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f.dataType());
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq convertibleFilters = (Seq)filters.flatMap((Function1)new Serializable(dataTypeMap){
            public static final long serialVersionUID = 0L;
            private final Map dataTypeMap$1;

            public final Iterable<Filter> apply(Filter filter) {
                return Option$.MODULE$.option2Iterable(OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.dataTypeMap$1, filter, SearchArgumentFactory.newBuilder()).map((Function1)new Serializable(this, filter){
                    public static final long serialVersionUID = 0L;
                    private final Filter filter$1;

                    public final Filter apply(SearchArgument.Builder _) {
                        return this.filter$1;
                    }
                    {
                        this.filter$1 = filter$1;
                    }
                }));
            }
            {
                this.dataTypeMap$1 = dataTypeMap$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return this.buildTree((Seq<Filter>)convertibleFilters).flatMap((Function1)new Serializable(dataTypeMap){
            public static final long serialVersionUID = 0L;
            private final Map dataTypeMap$1;

            public final Option<SearchArgument> apply(Filter conjunction) {
                return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.dataTypeMap$1, conjunction, SearchArgumentFactory.newBuilder()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SearchArgument apply(SearchArgument.Builder builder2) {
                        return builder2.build();
                    }
                });
            }
            {
                this.dataTypeMap$1 = dataTypeMap$1;
            }
        });
    }

    private boolean isSearchableType(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = BinaryType$.MODULE$.equals(dataType2) ? false : dataType2 instanceof AtomicType;
        return bl;
    }

    private PredicateLeaf.Type getPredicateLeafType(DataType dataType) {
        block9: {
            PredicateLeaf.Type type;
            block3: {
                DataType dataType2;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        dataType2 = dataType;
                                        if (!BooleanType$.MODULE$.equals(dataType2)) break block2;
                                        type = PredicateLeaf.Type.BOOLEAN;
                                        break block3;
                                    }
                                    boolean bl = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2)));
                                    if (!bl) break block4;
                                    type = PredicateLeaf.Type.LONG;
                                    break block3;
                                }
                                boolean bl = FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2);
                                if (!bl) break block5;
                                type = PredicateLeaf.Type.FLOAT;
                                break block3;
                            }
                            if (!StringType$.MODULE$.equals(dataType2)) break block6;
                            type = PredicateLeaf.Type.STRING;
                            break block3;
                        }
                        if (!DateType$.MODULE$.equals(dataType2)) break block7;
                        type = PredicateLeaf.Type.DATE;
                        break block3;
                    }
                    if (!TimestampType$.MODULE$.equals(dataType2)) break block8;
                    type = PredicateLeaf.Type.TIMESTAMP;
                    break block3;
                }
                if (!(dataType2 instanceof DecimalType)) break block9;
                type = PredicateLeaf.Type.DECIMAL;
            }
            return type;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataType: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType.catalogString()})));
    }

    public Object org$apache$spark$sql$execution$datasources$orc$OrcFilters$$castLiteralValue(Object value, DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        boolean bl = ByteType$.MODULE$.equals(dataType2) ? true : (ShortType$.MODULE$.equals(dataType2) ? true : (IntegerType$.MODULE$.equals(dataType2) ? true : LongType$.MODULE$.equals(dataType2)));
        if (bl) {
            object = BoxesRunTime.boxToLong((long)((Number)value).longValue());
        } else {
            boolean bl2 = FloatType$.MODULE$.equals(dataType2) ? true : DoubleType$.MODULE$.equals(dataType2);
            if (bl2) {
                object = BoxesRunTime.boxToDouble((double)((Number)value).doubleValue());
            } else if (dataType2 instanceof DecimalType) {
                BigDecimal decimal = (BigDecimal)value;
                HiveDecimalWritable decimalWritable = new HiveDecimalWritable(decimal.longValue());
                decimalWritable.mutateEnforcePrecisionScale(decimal.precision(), decimal.scale());
                object = decimalWritable;
            } else {
                object = value;
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<SearchArgument.Builder> org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument(Map<String, DataType> dataTypeMap, Filter expression, SearchArgument.Builder builder2) {
        IsNotNull isNotNull;
        String attribute;
        IsNull isNull;
        String attribute2;
        Filter filter = expression;
        if (filter instanceof And) {
            And and = (And)filter;
            Filter left = and.left();
            Filter right = and.right();
            return this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument(dataTypeMap, left, SearchArgumentFactory.newBuilder()).flatMap((Function1)new Serializable(dataTypeMap, builder2, left, right){
                public static final long serialVersionUID = 0L;
                public final Map dataTypeMap$2;
                public final SearchArgument.Builder builder$1;
                public final Filter left$1;
                public final Filter right$1;

                public final Option<SearchArgument.Builder> apply(SearchArgument.Builder _) {
                    return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.dataTypeMap$2, this.right$1, SearchArgumentFactory.newBuilder()).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument$1 $outer;

                        public final Option<SearchArgument.Builder> apply(SearchArgument.Builder _) {
                            return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.$outer.dataTypeMap$2, this.$outer.left$1, this.$outer.builder$1.startAnd()).flatMap((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument$1$$anonfun$apply$3 $outer;

                                public final Option<SearchArgument.Builder> apply(SearchArgument.Builder lhs) {
                                    return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$anonfun$$anonfun$$$outer().dataTypeMap$2, this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$anonfun$$anonfun$$$outer().right$1, lhs).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final SearchArgument.Builder apply(SearchArgument.Builder rhs) {
                                            return rhs.end();
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument$1 org$apache$spark$sql$execution$datasources$orc$OrcFilters$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.dataTypeMap$2 = dataTypeMap$2;
                    this.builder$1 = builder$1;
                    this.left$1 = left$1;
                    this.right$1 = right$1;
                }
            });
        }
        if (filter instanceof Or) {
            Or or = (Or)filter;
            Filter left = or.left();
            Filter right = or.right();
            return this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument(dataTypeMap, left, SearchArgumentFactory.newBuilder()).flatMap((Function1)new Serializable(dataTypeMap, builder2, left, right){
                public static final long serialVersionUID = 0L;
                public final Map dataTypeMap$2;
                public final SearchArgument.Builder builder$1;
                public final Filter left$2;
                public final Filter right$2;

                public final Option<SearchArgument.Builder> apply(SearchArgument.Builder _) {
                    return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.dataTypeMap$2, this.right$2, SearchArgumentFactory.newBuilder()).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument$2 $outer;

                        public final Option<SearchArgument.Builder> apply(SearchArgument.Builder _) {
                            return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.$outer.dataTypeMap$2, this.$outer.left$2, this.$outer.builder$1.startOr()).flatMap((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument$2$$anonfun$apply$6 $outer;

                                public final Option<SearchArgument.Builder> apply(SearchArgument.Builder lhs) {
                                    return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$anonfun$$anonfun$$$outer().dataTypeMap$2, this.$outer.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$anonfun$$anonfun$$$outer().right$2, lhs).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final SearchArgument.Builder apply(SearchArgument.Builder rhs) {
                                            return rhs.end();
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument$2 org$apache$spark$sql$execution$datasources$orc$OrcFilters$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.dataTypeMap$2 = dataTypeMap$2;
                    this.builder$1 = builder$1;
                    this.left$2 = left$2;
                    this.right$2 = right$2;
                }
            });
        }
        if (filter instanceof Not) {
            Not not = (Not)filter;
            Filter child = not.child();
            return this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument(dataTypeMap, child, SearchArgumentFactory.newBuilder()).flatMap((Function1)new Serializable(dataTypeMap, builder2, child){
                public static final long serialVersionUID = 0L;
                private final Map dataTypeMap$2;
                private final SearchArgument.Builder builder$1;
                private final Filter child$1;

                public final Option<SearchArgument.Builder> apply(SearchArgument.Builder _) {
                    return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$buildSearchArgument((Map<String, DataType>)this.dataTypeMap$2, this.child$1, this.builder$1.startNot()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final SearchArgument.Builder apply(SearchArgument.Builder negate) {
                            return negate.end();
                        }
                    });
                }
                {
                    this.dataTypeMap$2 = dataTypeMap$2;
                    this.builder$1 = builder$1;
                    this.child$1 = child$1;
                }
            });
        }
        if (filter instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter;
            String attribute3 = equalTo.attribute();
            Object value = equalTo.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute3))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute3);
                Object castedValue = this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute3));
                return new Some((Object)builder2.startAnd().equals(quotedName, this.getType$1(attribute3, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter;
            String attribute4 = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute4))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute4);
                Object castedValue = this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute4));
                return new Some((Object)builder2.startAnd().nullSafeEquals(quotedName, this.getType$1(attribute4, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof LessThan) {
            LessThan lessThan = (LessThan)filter;
            String attribute5 = lessThan.attribute();
            Object value = lessThan.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute5))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute5);
                Object castedValue = this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute5));
                return new Some((Object)builder2.startAnd().lessThan(quotedName, this.getType$1(attribute5, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter;
            String attribute6 = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute6))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute6);
                Object castedValue = this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute6));
                return new Some((Object)builder2.startAnd().lessThanEquals(quotedName, this.getType$1(attribute6, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter;
            String attribute7 = greaterThan.attribute();
            Object value = greaterThan.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute7))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute7);
                Object castedValue = this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute7));
                return new Some((Object)builder2.startNot().lessThanEquals(quotedName, this.getType$1(attribute7, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter;
            String attribute8 = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            if (this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute8))) {
                String quotedName = this.quoteAttributeNameIfNeeded(attribute8);
                Object castedValue = this.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$castLiteralValue(value, (DataType)dataTypeMap.apply((Object)attribute8));
                return new Some((Object)builder2.startNot().lessThan(quotedName, this.getType$1(attribute8, dataTypeMap), castedValue).end());
            }
        }
        if (filter instanceof IsNull && this.isSearchableType((DataType)dataTypeMap.apply((Object)(attribute2 = (isNull = (IsNull)filter).attribute())))) {
            String quotedName = this.quoteAttributeNameIfNeeded(attribute2);
            return new Some((Object)builder2.startAnd().isNull(quotedName, this.getType$1(attribute2, dataTypeMap)).end());
        }
        if (filter instanceof IsNotNull && this.isSearchableType((DataType)dataTypeMap.apply((Object)(attribute = (isNotNull = (IsNotNull)filter).attribute())))) {
            String quotedName = this.quoteAttributeNameIfNeeded(attribute);
            return new Some((Object)builder2.startNot().isNull(quotedName, this.getType$1(attribute, dataTypeMap)).end());
        }
        if (!(filter instanceof In)) return None$.MODULE$;
        In in = (In)filter;
        String attribute9 = in.attribute();
        Object[] values2 = in.values();
        if (!this.isSearchableType((DataType)dataTypeMap.apply((Object)attribute9))) return None$.MODULE$;
        String quotedName = this.quoteAttributeNameIfNeeded(attribute9);
        Object[] castedValues = (Object[])Predef$.MODULE$.genericArrayOps((Object)values2).map((Function1)new Serializable(dataTypeMap, attribute9){
            public static final long serialVersionUID = 0L;
            private final Map dataTypeMap$2;
            private final String attribute$1;

            public final Object apply(Object v) {
                return OrcFilters$.MODULE$.org$apache$spark$sql$execution$datasources$orc$OrcFilters$$castLiteralValue(v, (DataType)this.dataTypeMap$2.apply((Object)this.attribute$1));
            }
            {
                this.dataTypeMap$2 = dataTypeMap$2;
                this.attribute$1 = attribute$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        return new Some((Object)builder2.startAnd().in(quotedName, this.getType$1(attribute9, dataTypeMap), (Object[])Predef$.MODULE$.genericArrayOps((Object)castedValues).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x$2) {
                return x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyRef()))).end());
    }

    private final PredicateLeaf.Type getType$1(String attribute, Map dataTypeMap$2) {
        return this.getPredicateLeafType((DataType)dataTypeMap$2.apply((Object)attribute));
    }

    private OrcFilters$() {
        MODULE$ = this;
    }
}

