/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.stat;

import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.stat.FrequentItems;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class FrequentItems$
implements Logging {
    public static final FrequentItems$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FrequentItems$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Dataset<Row> singlePassFreqItems(Dataset<Row> df, Seq<String> cols, double support) {
        Predef$.MODULE$.require(support >= 1.0E-4 && support <= 1.0, (Function0)new Serializable(support){
            public static final long serialVersionUID = 0L;
            private final double support$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Support must be in [1e-4, 1], but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.support$1)}));
            }
            {
                this.support$1 = support$1;
            }
        });
        int numCols = cols.length();
        int sizeOfMap = (int)(1.0 / support);
        Seq countMaps = (Seq)Seq$.MODULE$.tabulate(numCols, (Function1)new Serializable(sizeOfMap){
            public static final long serialVersionUID = 0L;
            private final int sizeOfMap$1;

            public final FrequentItems.FreqItemCounter apply(int i) {
                return new FrequentItems.FreqItemCounter(this.sizeOfMap$1);
            }
            {
                this.sizeOfMap$1 = sizeOfMap$1;
            }
        });
        StructType originalSchema = df.schema();
        Tuple2[] colInfo = (Tuple2[])((TraversableOnce)cols.map((Function1)new Serializable(originalSchema){
            public static final long serialVersionUID = 0L;
            private final StructType originalSchema$1;

            public final Tuple2<String, DataType> apply(String name2) {
                int index = this.originalSchema$1.fieldIndex(name2);
                return new Tuple2((Object)name2, (Object)this.originalSchema$1.fields()[index].dataType());
            }
            {
                this.originalSchema$1 = originalSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        RDD<Row> qual$1 = df.select((Seq<Column>)((Seq)cols.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String x$1) {
                return Column$.MODULE$.apply(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom()))).rdd();
        Seq x$2 = countMaps;
        Serializable x$3 = new Serializable(numCols){
            public static final long serialVersionUID = 0L;
            private final int numCols$1;

            public final Seq<FrequentItems.FreqItemCounter> apply(Seq<FrequentItems.FreqItemCounter> counts, Row row) {
                for (int i = 0; i < this.numCols$1; ++i) {
                    FrequentItems.FreqItemCounter thisMap = (FrequentItems.FreqItemCounter)counts.apply(i);
                    Object key = row.get(i);
                    thisMap.add(key, 1L);
                }
                return counts;
            }
            {
                this.numCols$1 = numCols$1;
            }
        };
        Serializable x$4 = new Serializable(numCols){
            public static final long serialVersionUID = 0L;
            private final int numCols$1;

            public final Seq<FrequentItems.FreqItemCounter> apply(Seq<FrequentItems.FreqItemCounter> baseCounts, Seq<FrequentItems.FreqItemCounter> counts) {
                for (int i = 0; i < this.numCols$1; ++i) {
                    ((FrequentItems.FreqItemCounter)baseCounts.apply(i)).merge((FrequentItems.FreqItemCounter)counts.apply(i));
                }
                return baseCounts;
            }
            {
                this.numCols$1 = numCols$1;
            }
        };
        int x$5 = qual$1.treeAggregate$default$4((Object)x$2);
        Seq freqItems = (Seq)qual$1.treeAggregate((Object)x$2, (Function2)x$3, (Function2)x$4, x$5, ClassTag$.MODULE$.apply(Seq.class));
        Seq justItems = (Seq)freqItems.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object[] apply(FrequentItems.FreqItemCounter m) {
                return (Object[])m.baseMap().keys().toArray(ClassTag$.MODULE$.Any());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Row resultRow = Row$.MODULE$.apply(justItems);
        StructField[] outputCols = (StructField[])Predef$.MODULE$.refArrayOps((Object[])colInfo).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(Tuple2<String, DataType> v) {
                return new StructField(new StringBuilder().append((Object)((String)v._1())).append((Object)"_freqItems").toString(), (DataType)new ArrayType((DataType)v._2(), false), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        Seq schema2 = new StructType(outputCols).toAttributes();
        return Dataset$.MODULE$.ofRows(df.sparkSession(), (LogicalPlan)LocalRelation$.MODULE$.fromExternalRows(schema2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{resultRow}))));
    }

    private FrequentItems$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

