/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.template.NoSuchAttributeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportAttributeModel {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public Map<String, Object> getImportedAttributes(TilesContainer container, String name, String toName, boolean ignore, Object ... requestItems) {
        HashMap<String, Object> retValue = new HashMap<String, Object>();
        AttributeContext attributeContext = container.getAttributeContext(requestItems);
        if (name != null) {
            this.importSingleAttribute(container, attributeContext, name, toName, ignore, retValue, requestItems);
        } else {
            this.importAttributes(attributeContext.getCascadedAttributeNames(), container, attributeContext, retValue, ignore, requestItems);
            this.importAttributes(attributeContext.getLocalAttributeNames(), container, attributeContext, retValue, ignore, requestItems);
        }
        return retValue;
    }

    private void importSingleAttribute(TilesContainer container, AttributeContext attributeContext, String name, String toName, boolean ignore, Map<String, Object> attributes, Object ... requestItems) {
        block9: {
            Attribute attr = attributeContext.getAttribute(name);
            if (attr != null) {
                try {
                    Object attributeValue = container.evaluate(attr, requestItems);
                    if (attributeValue == null) {
                        if (!ignore) {
                            throw new NoSuchAttributeException("Error importing attributes. Attribute '" + name + "' has a null value ");
                        }
                        break block9;
                    }
                    if (toName != null) {
                        attributes.put(toName, attributeValue);
                        break block9;
                    }
                    attributes.put(name, attributeValue);
                }
                catch (RuntimeException e) {
                    if (!ignore) {
                        throw e;
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Ignoring Tiles Exception", (Throwable)e);
                    }
                    break block9;
                }
            }
            if (!ignore) {
                throw new NoSuchAttributeException("Error importing attributes. Attribute '" + name + "' is null");
            }
        }
    }

    private void importAttributes(Collection<String> names, TilesContainer container, AttributeContext attributeContext, Map<String, Object> attributes, boolean ignore, Object ... requestItems) {
        if (names == null || names.isEmpty()) {
            return;
        }
        for (String name : names) {
            if (name == null && !ignore) {
                throw new NoSuchAttributeException("Error importing attributes. Attribute with null key found.");
            }
            if (name == null) continue;
            this.importSingleAttribute(container, attributeContext, name, name, ignore, attributes, requestItems);
        }
    }
}

