/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyTranslator;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.TranslatorCustomizer;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.TranslationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class GroovyTranslatorTest
extends AbstractGremlinTest {
    private static final GremlinGroovyScriptEngine engine = new GremlinGroovyScriptEngine();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHandleStrategies() throws Exception {
        GraphTraversalSource g = this.graph.traversal().withStrategies(new TraversalStrategy[]{SubgraphStrategy.create((Configuration)new MapConfiguration((Map)new HashMap<String, Object>(){
            {
                this.put("vertices", __.has((String)"name", (Object)"marko"));
            }
        }))});
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("g", (Object)g);
        Traversal.Admin traversal = engine.eval(g.V(new Object[0]).values(new String[]{"name"}).asAdmin().getBytecode(), (Bindings)bindings, "g");
        Assert.assertEquals((Object)"marko", (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = engine.eval(g.withoutStrategies(new Class[]{SubgraphStrategy.class}).V(new Object[0]).count().asAdmin().getBytecode(), (Bindings)bindings, "g");
        Assert.assertEquals((Object)new Long(6L), (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = engine.eval(g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.create((Configuration)new MapConfiguration((Map)new HashMap<String, Object>(){
            {
                this.put("vertices", __.has((String)"name", (Object)"marko"));
            }
        })), ReadOnlyStrategy.instance()}).V(new Object[0]).values(new String[]{"name"}).asAdmin().getBytecode(), (Bindings)bindings, "g");
        Assert.assertEquals((Object)"marko", (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportStringSupplierLambdas() {
        GraphTraversalSource g = this.graph.traversal();
        g = g.withStrategies(new TraversalStrategy[]{new TranslationStrategy((TraversalSource)g, (Translator)GroovyTranslator.of((String)"g"))});
        GraphTraversal.Admin t = g.withSideEffect("lengthSum", (Object)0).withSack((Object)1).V(new Object[0]).filter(Lambda.predicate((String)"it.get().label().equals('person')")).flatMap(Lambda.function((String)"it.get().vertices(Direction.OUT)")).map(Lambda.function((String)"it.get().value('name').length()")).sideEffect(Lambda.consumer((String)"{ x -> x.sideEffects(\"lengthSum\", x.<Integer>sideEffects('lengthSum') + x.get()) }")).order().by(Lambda.comparator((String)"a,b -> a <=> b")).sack(Lambda.biFunction((String)"{ a,b -> a + b }")).asAdmin();
        ArrayList<Object> sacks = new ArrayList<Object>();
        ArrayList<Object> lengths = new ArrayList<Object>();
        while (t.hasNext()) {
            Traverser.Admin traverser = t.nextTraverser();
            sacks.add(traverser.sack());
            lengths.add(traverser.get());
        }
        Assert.assertFalse((boolean)t.hasNext());
        Assert.assertEquals((long)6L, (long)lengths.size());
        Assert.assertEquals((long)3L, (long)((Integer)lengths.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)lengths.get(1)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)lengths.get(2)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)lengths.get(3)).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)lengths.get(4)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)lengths.get(5)).intValue());
        Assert.assertEquals((long)6L, (long)sacks.size());
        Assert.assertEquals((long)4L, (long)((Integer)sacks.get(0)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)sacks.get(1)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)sacks.get(2)).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)sacks.get(3)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)sacks.get(4)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)sacks.get(5)).intValue());
        Assert.assertEquals((long)24L, (long)((Number)t.getSideEffects().get("lengthSum")).intValue());
        String script = GroovyTranslator.of((String)"g").translate(t.getBytecode());
        Assert.assertEquals((Object)"g.withSideEffect(\"lengthSum\",(int) 0).withSack((int) 1).V().filter({it.get().label().equals('person')}).flatMap({it.get().vertices(Direction.OUT)}).map({it.get().value('name').length()}).sideEffect({ x -> x.sideEffects(\"lengthSum\", x.<Integer>sideEffects('lengthSum') + x.get()) }).order().by({a,b -> a <=> b}).sack({ a,b -> a + b })", (Object)script);
        this.assertThatScriptOk(script, "g", g);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHandleMaps() {
        String script = GroovyTranslator.of((String)"g").translate(this.g.V(new Object[0]).id().is((Object)new LinkedHashMap<Object, Object>(){
            {
                this.put(3, "32");
                this.put(Arrays.asList(1, 2, 3.1), 4);
            }
        }).asAdmin().getBytecode());
        Assert.assertEquals((Object)"g.V().id().is([((int) 3):(\"32\"),([(int) 1, (int) 2, 3.1d]):((int) 4)])", (Object)script);
        this.assertThatScriptOk(script, "g", this.g);
    }

    @Test
    public void shouldHandleEmptyMaps() {
        Lambda.OneArgLambda identity = new Lambda.OneArgLambda("it.get()", "gremlin-groovy");
        String script = GroovyTranslator.of((String)"g").translate(this.g.inject((Object[])new Map[]{Collections.emptyMap()}).map((Function)identity).asAdmin().getBytecode());
        Assert.assertEquals((Object)"g.inject([]).map({it.get()})", (Object)script);
        this.assertThatScriptOk(script, "g", this.g);
    }

    @Test
    public void shouldHandleDate() {
        Calendar c = Calendar.getInstance();
        c.set(1975, 8, 7);
        Date d = c.getTime();
        this.assertTranslation(String.format("new java.util.Date(%s)", d.getTime()), d);
    }

    @Test
    public void shouldHandleTimestamp() {
        Calendar c = Calendar.getInstance();
        c.set(1975, 8, 7);
        Timestamp t = new Timestamp(c.getTime().getTime());
        this.assertTranslation(String.format("new java.sql.Timestamp(%s)", t.getTime()), t);
    }

    @Test
    public void shouldHandleUuid() {
        UUID uuid = UUID.fromString("ffffffff-fd49-1e4b-0000-00000d4b8a1d");
        this.assertTranslation(String.format("java.util.UUID.fromString('%s')", uuid), uuid);
    }

    @Test
    public void shouldHandleColumn() {
        this.assertTranslation("Column.keys", Column.keys);
    }

    @Test
    public void shouldHandleDirection() {
        this.assertTranslation("Direction.BOTH", Direction.BOTH);
    }

    @Test
    public void shouldHandleOrder() {
        this.assertTranslation("Order.decr", Order.decr);
    }

    @Test
    public void shouldHandlePop() {
        this.assertTranslation("Pop.last", Pop.last);
    }

    @Test
    public void shouldHandleScope() {
        this.assertTranslation("Scope.local", Scope.local);
    }

    @Test
    public void shouldOverrideDefaultTypeTranslationWithSomethingBonkers() {
        String thingToSuffixAllStringsWith = "-why-would-anyone-do-this";
        String script = GroovyTranslator.of((String)"g", x -> x instanceof String ? x + "-why-would-anyone-do-this" : x).translate(this.g.inject((Object[])new String[]{"yyy", "xxx"}).asAdmin().getBytecode());
        Assert.assertEquals((Object)String.format("g.inject(\"yyy%s\",\"xxx%s\")", "-why-would-anyone-do-this", "-why-would-anyone-do-this"), (Object)script);
        this.assertThatScriptOk(script, "g", this.g);
    }

    @Test
    public void shouldIncludeCustomTypeTranslationForSomethingSilly() throws Exception {
        SillyClass notSillyEnough = SillyClass.from("not silly enough", 100);
        GraphTraversalSource g = this.graph.traversal();
        String scriptBad = GroovyTranslator.of((String)"g").translate(g.inject((Object[])new SillyClass[]{notSillyEnough}).asAdmin().getBytecode());
        Assert.assertEquals((Object)String.format("g.inject(%s)", "not silly enough:100"), (Object)scriptBad);
        String scriptGood = GroovyTranslator.of((String)"g", x -> x instanceof SillyClass ? new Translator.ScriptTranslator.Handled(String.format("org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyTranslatorTest.SillyClass.from('%s', (int) %s)", ((SillyClass)x).getX(), ((SillyClass)x).getY())) : x).translate(g.inject((Object[])new SillyClass[]{notSillyEnough}).asAdmin().getBytecode());
        Assert.assertEquals((Object)String.format("g.inject(org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyTranslatorTest.SillyClass.from('%s', (int) %s))", notSillyEnough.getX(), notSillyEnough.getY()), (Object)scriptGood);
        this.assertThatScriptOk(scriptGood, "g", g);
        GremlinGroovyScriptEngine customEngine = new GremlinGroovyScriptEngine(new Customizer[]{new SillyClassTranslatorCustomizer()});
        SimpleBindings b = new SimpleBindings();
        b.put("g", (Object)g);
        Traversal.Admin t = customEngine.eval(g.inject((Object[])new SillyClass[]{notSillyEnough}).asAdmin().getBytecode(), (Bindings)b, "g");
        SillyClass sc = (SillyClass)t.next();
        Assert.assertEquals((Object)notSillyEnough.getX(), (Object)sc.getX());
        Assert.assertEquals((long)notSillyEnough.getY(), (long)sc.getY());
        Assert.assertThat((Object)t.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveValidToString() {
        Assert.assertEquals((Object)"translator[h:gremlin-groovy]", (Object)GroovyTranslator.of((String)"h").toString());
    }

    @Test
    public void shouldEscapeStrings() {
        this.assertTranslation("501L,\"Foo Bar\",(int) 25,\"\"\"`~!@#\\$%^&*()-_=+[{]}\\\\|;:'\\\",<.>/?\"\"\"", 501L, "Foo Bar", 25, "`~!@#$%^&*()-_=+[{]}\\|;:'\",<.>/?");
    }

    @Test
    public void shouldHandleVertexAndEdge() {
        GraphTraversalSource g = this.graph.traversal();
        String id1 = "customer:10:foo bar $100#90";
        DetachedVertex vertex1 = DetachedVertex.build().setLabel("customer").setId((Object)id1).create();
        String script1 = GroovyTranslator.of((String)"g").translate(g.inject((Object[])new Vertex[]{vertex1}).asAdmin().getBytecode());
        Assert.assertEquals((Object)"g.inject(new org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex(\"customer:10:foo bar \\$100#90\",\"customer\", Collections.emptyMap()))", (Object)script1);
        this.assertThatScriptOk(script1, "g", g);
        String id2 = "user:20:foo\\u0020bar\\u005c\\u0022mr\\u005c\\u0022\\u00241000#50";
        DetachedVertex vertex2 = DetachedVertex.build().setLabel("user").setId((Object)id2).create();
        String script2 = GroovyTranslator.of((String)"g").translate(g.inject((Object[])new Vertex[]{vertex2}).asAdmin().getBytecode());
        Assert.assertEquals((Object)"g.inject(new org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex(\"user:20:foo\\\\u0020bar\\\\u005c\\\\u0022mr\\\\u005c\\\\u0022\\\\u00241000#50\",\"user\", Collections.emptyMap()))", (Object)script2);
        this.assertThatScriptOk(script2, "g", g);
        String id3 = "knows:30:foo bar $100:\\u0020\\u0024500#70";
        DetachedEdge edge = DetachedEdge.build().setLabel("knows").setId((Object)id3).setOutV(vertex1).setInV(vertex2).create();
        String script3 = GroovyTranslator.of((String)"g").translate(g.inject((Object[])new Edge[]{edge}).asAdmin().getBytecode());
        Assert.assertEquals((Object)"g.inject(new org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge(\"knows:30:foo bar \\$100:\\\\u0020\\\\u0024500#70\",\"knows\",Collections.emptyMap(),\"customer:10:foo bar \\$100#90\",\"customer\",\"user:20:foo\\\\u0020bar\\\\u005c\\\\u0022mr\\\\u005c\\\\u0022\\\\u00241000#50\",\"user\"))", (Object)script3);
        this.assertThatScriptOk(script3, "g", g);
    }

    public static Object eval(String s, Object ... args) throws ScriptException {
        return engine.eval(s, (Bindings)new SimpleBindings(ElementHelper.asMap((Object[])args)));
    }

    public static Object eval(String s, Bindings b) throws ScriptException {
        return engine.eval(s, b);
    }

    private void assertTranslation(String expectedTranslation, Object ... objs) {
        String script = GroovyTranslator.of((String)"g").translate(this.g.inject(objs).asAdmin().getBytecode());
        Assert.assertEquals((Object)String.format("g.inject(%s)", expectedTranslation), (Object)script);
        this.assertThatScriptOk(script, "g", this.g);
    }

    private void assertThatScriptOk(String s, Object ... args) {
        try {
            Assert.assertNotNull((Object)GroovyTranslatorTest.eval(s, args));
        }
        catch (ScriptException se) {
            se.printStackTrace();
            Assert.fail((String)"Script should have eval'd");
        }
    }

    public static class SillyClassTranslatorCustomizer
    implements TranslatorCustomizer {
        public Translator.ScriptTranslator.TypeTranslator createTypeTranslator() {
            return x -> x instanceof SillyClass ? new Translator.ScriptTranslator.Handled(String.format("org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyTranslatorTest.SillyClass.from('%s', (int) %s)", ((SillyClass)x).getX(), ((SillyClass)x).getY())) : x;
        }
    }

    public static class SillyClass {
        private final String x;
        private final int y;

        private SillyClass(String x, int y) {
            this.x = x;
            this.y = y;
        }

        public static SillyClass from(String x, int y) {
            return new SillyClass(x, y);
        }

        public String getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return this.x + ":" + String.valueOf(this.y);
        }
    }
}

