/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.algorithm.generator;

import java.util.Random;
import org.apache.tinkerpop.gremlin.algorithm.generator.Distribution;

public class NormalDistribution
implements Distribution {
    private final double stdDeviation;
    private final double mean;

    public NormalDistribution(double stdDeviation) {
        this(stdDeviation, 0.0);
    }

    private NormalDistribution(double stdDeviation, double mean) {
        if (stdDeviation < 0.0) {
            throw new IllegalArgumentException("Standard deviation must be non-negative: " + stdDeviation);
        }
        if (mean < 0.0) {
            throw new IllegalArgumentException("Mean must be positive: " + mean);
        }
        this.stdDeviation = stdDeviation;
        this.mean = mean;
    }

    @Override
    public Distribution initialize(int invocations, int expectedTotal) {
        double mean = (double)expectedTotal * 1.0 / (double)invocations;
        return new NormalDistribution(this.stdDeviation, mean);
    }

    @Override
    public int nextValue(Random random) {
        if (this.mean == 0.0) {
            throw new IllegalStateException("Distribution has not been initialized");
        }
        return (int)Math.round(random.nextGaussian() * this.stdDeviation + this.mean);
    }

    @Override
    public int nextConditionalValue(Random random, int otherValue) {
        return this.nextValue(random);
    }

    public String toString() {
        return "NormalDistribution{stdDeviation=" + this.stdDeviation + ", mean=" + this.mean + '}';
    }
}

