/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Map;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class ElementMapTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Map<Object, Object>> get_g_V_elementMap();

    public abstract Traversal<Vertex, Map<Object, Object>> get_g_V_elementMapXname_ageX();

    public abstract Traversal<Edge, Map<Object, Object>> get_g_EX11X_elementMap(Object var1);

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_elementMap() {
        Traversal<Vertex, Map<Object, Object>> traversal = this.get_g_V_elementMap();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Map values = (Map)traversal.next();
            String name = (String)values.get("name");
            Assert.assertEquals((long)4L, (long)values.size());
            if (name.equals("marko")) {
                Assert.assertEquals((Object)29, values.get("age"));
                Assert.assertEquals((Object)"person", values.get(T.label));
            } else if (name.equals("josh")) {
                Assert.assertEquals((Object)32, values.get("age"));
                Assert.assertEquals((Object)"person", values.get(T.label));
            } else if (name.equals("peter")) {
                Assert.assertEquals((Object)35, values.get("age"));
                Assert.assertEquals((Object)"person", values.get(T.label));
            } else if (name.equals("vadas")) {
                Assert.assertEquals((Object)27, values.get("age"));
                Assert.assertEquals((Object)"person", values.get(T.label));
            } else if (name.equals("lop")) {
                Assert.assertEquals((Object)"java", values.get("lang"));
                Assert.assertEquals((Object)"software", values.get(T.label));
            } else if (name.equals("ripple")) {
                Assert.assertEquals((Object)"java", values.get("lang"));
                Assert.assertEquals((Object)"software", values.get(T.label));
            } else {
                throw new IllegalStateException("It is not possible to reach here: " + values);
            }
            MatcherAssert.assertThat((Object)values.containsKey(T.id), (Matcher)Is.is((Object)true));
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_elementMapXname_ageX() {
        Traversal<Vertex, Map<Object, Object>> traversal = this.get_g_V_elementMapXname_ageX();
        this.printTraversalForm(traversal);
        int counter = 0;
        while (traversal.hasNext()) {
            ++counter;
            Map values = (Map)traversal.next();
            String name = (String)values.get("name");
            if (name.equals("marko")) {
                Assert.assertEquals((Object)29, values.get("age"));
                Assert.assertEquals((Object)"person", values.get(T.label));
                Assert.assertEquals((long)4L, (long)values.size());
            } else if (name.equals("josh")) {
                Assert.assertEquals((Object)32, values.get("age"));
                Assert.assertEquals((Object)"person", values.get(T.label));
                Assert.assertEquals((long)4L, (long)values.size());
            } else if (name.equals("peter")) {
                Assert.assertEquals((Object)35, values.get("age"));
                Assert.assertEquals((Object)"person", values.get(T.label));
                Assert.assertEquals((long)4L, (long)values.size());
            } else if (name.equals("vadas")) {
                Assert.assertEquals((Object)27, values.get("age"));
                Assert.assertEquals((Object)"person", values.get(T.label));
                Assert.assertEquals((long)4L, (long)values.size());
            } else if (name.equals("lop")) {
                Assert.assertNull(values.get("lang"));
                Assert.assertEquals((Object)"software", values.get(T.label));
                Assert.assertEquals((long)3L, (long)values.size());
            } else if (name.equals("ripple")) {
                Assert.assertNull(values.get("lang"));
                Assert.assertEquals((Object)"software", values.get(T.label));
                Assert.assertEquals((long)3L, (long)values.size());
            } else {
                throw new IllegalStateException("It is not possible to reach here: " + values);
            }
            MatcherAssert.assertThat((Object)values.containsKey(T.id), (Matcher)Is.is((Object)true));
        }
        Assert.assertEquals((long)6L, (long)counter);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_EX11X_elementMap() {
        Object edgeId = this.convertToEdgeId("josh", "created", "lop");
        Traversal<Edge, Map<Object, Object>> traversal = this.get_g_EX11X_elementMap(edgeId);
        this.printTraversalForm(traversal);
        Map m = (Map)traversal.next();
        Assert.assertEquals((long)5L, (long)m.size());
        Assert.assertEquals((Object)0.4, m.get("weight"));
        Assert.assertEquals((Object)"created", m.get(T.label));
        Assert.assertEquals((Object)edgeId, m.get(T.id));
        Vertex vJosh = this.convertToVertex("josh");
        Assert.assertEquals((Object)vJosh.id(), ((Map)m.get(Direction.OUT)).get(T.id));
        if (!this.hasGraphComputerRequirement()) {
            Assert.assertEquals((Object)vJosh.label(), ((Map)m.get(Direction.OUT)).get(T.label));
        }
        Vertex vLop = this.convertToVertex("lop");
        Assert.assertEquals((Object)vLop.id(), ((Map)m.get(Direction.IN)).get(T.id));
        if (!this.hasGraphComputerRequirement()) {
            Assert.assertEquals((Object)vLop.label(), ((Map)m.get(Direction.IN)).get(T.label));
        }
        MatcherAssert.assertThat((Object)traversal.hasNext(), (Matcher)Is.is((Object)false));
    }

    public static class Traversals
    extends ElementMapTest {
        @Override
        public Traversal<Vertex, Map<Object, Object>> get_g_V_elementMap() {
            return this.g.V(new Object[0]).elementMap(new String[0]);
        }

        @Override
        public Traversal<Vertex, Map<Object, Object>> get_g_V_elementMapXname_ageX() {
            return this.g.V(new Object[0]).elementMap(new String[]{"name", "age"});
        }

        @Override
        public Traversal<Edge, Map<Object, Object>> get_g_EX11X_elementMap(Object e11Id) {
            return this.g.E(new Object[]{e11Id}).elementMap(new String[0]);
        }
    }
}

