/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.util.detached;

import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;
import org.apache.tinkerpop.gremlin.structure.util.Host;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedProperty;
import org.junit.Assert;
import org.junit.Test;

public class DetachedPropertyTest
extends AbstractGremlinTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldNotConstructNewWithSomethingAlreadyDetached() {
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("test", v, new Object[]{"xxx", "yyy"});
        DetachedProperty dp = DetachedFactory.detach((Property)e.property("xxx"));
        Assert.assertSame((Object)dp, (Object)DetachedFactory.detach((Property)dp));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldConstructDetachedPropertyWithPropertyFromEdge() {
        DetachedProperty p = DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight"));
        Assert.assertEquals((Object)"weight", (Object)p.key());
        Assert.assertEquals((double)0.4, (double)((Double)p.value()), (double)1.0E-6);
        Assert.assertEquals(DetachedEdge.class, p.element().getClass());
    }

    @Test(expected=IllegalStateException.class)
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotSupportRemove() {
        DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight")).remove();
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldBeEqualProperties() {
        Assert.assertTrue((boolean)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight")).equals((Object)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight"))));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToGraph() {
        Edge e = (Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next();
        Property toDetach = (Property)e.properties(new String[]{"weight"}).next();
        DetachedProperty detachedProperty = DetachedFactory.detach((Property)toDetach);
        Property attached = (Property)detachedProperty.attach(Attachable.Method.get((Host)this.graph));
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedProperty));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldAttachToVertex() {
        Edge e = (Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next();
        Property toDetach = e.property("weight");
        DetachedProperty detachedProperty = DetachedFactory.detach((Property)toDetach);
        Property attached = (Property)detachedProperty.attach(Attachable.Method.get((Host)e.outVertex()));
        Assert.assertEquals((Object)toDetach, (Object)attached);
        Assert.assertFalse((boolean)(attached instanceof DetachedProperty));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldBeEqualPropertiesWithSameKeyValueAndDifferentElement() {
        Assert.assertTrue((boolean)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).next()).property("weight")).equals((Object)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("josh", "created", "lop")}).next()).property("weight"))));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotBeEqualPropertiesAsThereIsDifferentValue() {
        Assert.assertFalse((boolean)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("marko", "created", "lop")}).next()).property("weight")).equals((Object)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{this.convertToEdgeId("peter", "created", "lop")}).next()).property("weight"))));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="DoubleValues")
    public void shouldNotBeEqualPropertiesAsThereIsDifferentKey() {
        Object joshCreatedLopEdgeId = this.convertToEdgeId("josh", "created", "lop");
        Edge e = ((Vertex)this.g.V(new Object[]{this.convertToVertexId("josh")}).next()).addEdge("created", (Vertex)this.g.V(new Object[]{this.convertToVertexId("lop")}).next(), new Object[]{"double", 0.4});
        Assert.assertFalse((boolean)DetachedFactory.detach((Property)e.property("double")).equals((Object)DetachedFactory.detach((Property)((Edge)this.g.E(new Object[]{joshCreatedLopEdgeId}).next()).property("weight"))));
    }
}

