/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.util.Locale;
import org.apache.wicket.util.convert.converter.AbstractIntegerConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZeroPaddingIntegerConverter
extends AbstractIntegerConverter<Integer> {
    private static final long serialVersionUID = 1L;
    private final int zeroPadLength;

    public ZeroPaddingIntegerConverter(int zeroPadLength) {
        this.zeroPadLength = zeroPadLength;
    }

    @Override
    public String convertToString(Integer value, Locale locale) {
        String result = super.convertToString(value, locale);
        while (result.length() < this.zeroPadLength) {
            result = "0" + result;
        }
        return result;
    }

    @Override
    public Integer convertToObject(String value, Locale locale) {
        Object number = this.parse(value, -2.147483648E9, 2.147483647E9, locale);
        if (number == null) {
            return null;
        }
        return ((Number)number).intValue();
    }

    @Override
    protected Class<Integer> getTargetType() {
        return Integer.class;
    }
}

