/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.truetype.TTFFontLoader;
import org.apache.fop.fonts.type1.Type1FontLoader;

public abstract class FontLoader {
    protected static Log log = LogFactory.getLog((Class)FontLoader.class);
    protected String fontFileURI = null;
    protected FontResolver resolver = null;
    protected CustomFont returnFont = null;
    protected boolean loaded = false;

    public FontLoader(String fontFileURI, FontResolver resolver) {
        this.fontFileURI = fontFileURI;
        this.resolver = resolver;
    }

    private static boolean isType1(String fontURI) {
        return fontURI.toLowerCase().endsWith(".pfb");
    }

    public static CustomFont loadFont(File fontFile, FontResolver resolver) throws IOException {
        return FontLoader.loadFont(fontFile.getAbsolutePath(), resolver);
    }

    public static CustomFont loadFont(URL fontUrl, FontResolver resolver) throws IOException {
        return FontLoader.loadFont(fontUrl.toExternalForm(), resolver);
    }

    public static CustomFont loadFont(String fontFileURI, FontResolver resolver) throws IOException {
        boolean type1 = FontLoader.isType1(fontFileURI = fontFileURI.trim());
        FontLoader loader = type1 ? new Type1FontLoader(fontFileURI, resolver) : new TTFFontLoader(fontFileURI, resolver);
        return loader.getFont();
    }

    protected static InputStream openFontUri(FontResolver resolver, String uri) throws IOException, MalformedURLException {
        InputStream in = null;
        if (resolver != null) {
            Source source = resolver.resolve(uri);
            if (source == null) {
                String err = "Cannot load font: failed to create Source for font file " + uri;
                throw new IOException(err);
            }
            if (source instanceof StreamSource) {
                in = ((StreamSource)source).getInputStream();
            }
            if (in == null && source.getSystemId() != null) {
                in = new URL(source.getSystemId()).openStream();
            }
            if (in == null) {
                String err = "Cannot load font: failed to create InputStream from Source for font file " + uri;
                throw new IOException(err);
            }
        } else {
            in = new URL(uri).openStream();
        }
        return in;
    }

    protected abstract void read() throws IOException;

    public CustomFont getFont() throws IOException {
        if (!this.loaded) {
            this.read();
        }
        return this.returnFont;
    }
}

