/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.LinkedList;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.ImageLayout;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public abstract class AbstractGraphicsLayoutManager
extends LeafNodeLayoutManager {
    protected AbstractGraphics fobj;

    public AbstractGraphicsLayoutManager(AbstractGraphics node) {
        super(node);
        this.fobj = node;
    }

    private Viewport getInlineArea() {
        Dimension intrinsicSize = new Dimension(this.fobj.getIntrinsicWidth(), this.fobj.getIntrinsicHeight());
        ImageLayout imageLayout = new ImageLayout(this.fobj, this, intrinsicSize);
        Rectangle placement = imageLayout.getPlacement();
        CommonBorderPaddingBackground borderProps = this.fobj.getCommonBorderPaddingBackground();
        int beforeBPD = borderProps.getPadding(0, false, this);
        placement.y += (beforeBPD += borderProps.getBorderWidth(0, false));
        int startIPD = borderProps.getPadding(2, false, this);
        placement.x += (startIPD += borderProps.getBorderWidth(2, false));
        Area viewportArea = this.getChildArea();
        TraitSetter.setProducerID(viewportArea, this.fobj.getId());
        this.transferForeignAttributes(viewportArea);
        Viewport vp = new Viewport(viewportArea);
        TraitSetter.setProducerID(vp, this.fobj.getId());
        vp.setIPD(imageLayout.getViewportSize().width);
        vp.setBPD(imageLayout.getViewportSize().height);
        vp.setContentPosition(placement);
        vp.setClip(imageLayout.isClipped());
        vp.setOffset(0);
        TraitSetter.addBorders(vp, this.fobj.getCommonBorderPaddingBackground(), false, false, false, false, this);
        TraitSetter.addPadding(vp, this.fobj.getCommonBorderPaddingBackground(), false, false, false, false, this);
        TraitSetter.addBackground(vp, this.fobj.getCommonBorderPaddingBackground(), this);
        return vp;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        Viewport areaCurrent = this.getInlineArea();
        this.setCurrentArea(areaCurrent);
        return super.getNextKnuthElements(context, alignment);
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext context) {
        return new AlignmentContext(this.get(context).getAllocBPD(), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), context.getAlignmentContext());
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }

    abstract Area getChildArea();

    public int getBaseLength(int lengthBase, FObj fobj) {
        switch (lengthBase) {
            case 7: {
                return this.getIntrinsicWidth();
            }
            case 8: {
                return this.getIntrinsicHeight();
            }
            case 12: {
                return this.get(null).getBPD();
            }
        }
        return super.getBaseLength(lengthBase, fobj);
    }

    protected int getIntrinsicWidth() {
        return this.fobj.getIntrinsicWidth();
    }

    protected int getIntrinsicHeight() {
        return this.fobj.getIntrinsicHeight();
    }
}

