/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.base.Throwables;
import java.io.File;
import javax.annotation.PostConstruct;
import org.apereo.cas.config.monitor.ConfigurationDirectoryPathWatchService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.CasConfigurationPropertiesEnvironmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration(value="casConfigurationSupportUtilitiesConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasConfigurationSupportUtilitiesConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasConfigurationSupportUtilitiesConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @Configuration(value="casCoreConfigurationWatchConfiguration")
    @Profile(value={"standalone"})
    @ConditionalOnProperty(value={"spring.cloud.config.enabled"}, havingValue="false")
    public class CasCoreConfigurationWatchConfiguration {
        @Autowired
        private ApplicationEventPublisher eventPublisher;
        @Autowired
        @Qualifier(value="configurationPropertiesEnvironmentManager")
        private CasConfigurationPropertiesEnvironmentManager configurationPropertiesEnvironmentManager;

        @PostConstruct
        public void init() {
            this.runNativeConfigurationDirectoryPathWatchService();
        }

        public void runNativeConfigurationDirectoryPathWatchService() {
            try {
                File config = this.configurationPropertiesEnvironmentManager.getStandaloneProfileConfigurationDirectory();
                if (CasConfigurationSupportUtilitiesConfiguration.this.casProperties.getEvents().isTrackConfigurationModifications() && config.exists()) {
                    LOGGER.debug("Starting to watch configuration directory [{}]", (Object)config);
                    Thread th = new Thread(new ConfigurationDirectoryPathWatchService(config.toPath(), this.eventPublisher));
                    th.start();
                } else {
                    LOGGER.info("CAS is configured to NOT watch configuration directory [{}]. Changes require manual reloads/restarts.", (Object)config);
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

