/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.monitor;

import com.google.common.base.Throwables;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.events.config.CasConfigurationCreatedEvent;
import org.apereo.cas.support.events.config.CasConfigurationDeletedEvent;
import org.apereo.cas.support.events.config.CasConfigurationModifiedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ConfigurationDirectoryPathWatchService
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationDirectoryPathWatchService.class);
    private static final long MONITOR_INTERVAL = 5000L;
    private final WatchService watcher;
    private final Path directory;
    private final ApplicationEventPublisher eventPublisher;

    public ConfigurationDirectoryPathWatchService(Path directory, ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        try {
            this.directory = directory;
            this.watcher = FileSystems.getDefault().newWatchService();
            this.directory.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void watch() {
        WatchKey key;
        boolean valid;
        long lastModified = System.currentTimeMillis();
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    LOGGER.warn("An overflow event occurred. File system events may be lost or discarded.");
                    continue;
                }
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                try {
                    Path child = this.directory.resolve(filename);
                    if (System.currentTimeMillis() - lastModified < 5000L) continue;
                    LOGGER.debug("Detected configuration change [{}]", (Object)kind.name());
                    if (StringUtils.equalsIgnoreCase((CharSequence)StandardWatchEventKinds.ENTRY_CREATE.name(), (CharSequence)kind.name())) {
                        this.eventPublisher.publishEvent((ApplicationEvent)new CasConfigurationCreatedEvent((Object)this, child));
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)StandardWatchEventKinds.ENTRY_DELETE.name(), (CharSequence)kind.name())) {
                        this.eventPublisher.publishEvent((ApplicationEvent)new CasConfigurationDeletedEvent((Object)this, child));
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)StandardWatchEventKinds.ENTRY_MODIFY.name(), (CharSequence)kind.name())) {
                        this.eventPublisher.publishEvent((ApplicationEvent)new CasConfigurationModifiedEvent((Object)this, child));
                    }
                    lastModified = System.currentTimeMillis();
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
        } while (valid = key.reset());
    }

    @Override
    public void run() {
        this.watch();
    }
}

